/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;

public class ListImagePipelineImagesPublisher
implements SdkPublisher<ListImagePipelineImagesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImagePipelineImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImagePipelineImagesPublisher(ImagebuilderAsyncClient client, ListImagePipelineImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImagePipelineImagesPublisher(ImagebuilderAsyncClient client, ListImagePipelineImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImagePipelineImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImagePipelineImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListImagePipelineImagesResponseFetcher
    implements AsyncPageFetcher<ListImagePipelineImagesResponse> {
        private ListImagePipelineImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagePipelineImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImagePipelineImagesResponse> nextPage(ListImagePipelineImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagePipelineImagesPublisher.this.client.listImagePipelineImages(ListImagePipelineImagesPublisher.this.firstRequest);
            }
            return ListImagePipelineImagesPublisher.this.client.listImagePipelineImages((ListImagePipelineImagesRequest)((Object)ListImagePipelineImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

