/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An image recipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageRecipe implements SdkPojo, Serializable, ToCopyableBuilder<ImageRecipe.Builder, ImageRecipe> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField
            .<List<ComponentConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(ImageRecipe::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::parentImage)).setter(setter(Builder::parentImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()).build();

    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMapping>> builder(MarshallingType.LIST)
            .getter(getter(ImageRecipe::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ImageRecipe::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageRecipe::workingDirectory)).setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, PLATFORM_FIELD, OWNER_FIELD, VERSION_FIELD, COMPONENTS_FIELD, PARENT_IMAGE_FIELD,
            BLOCK_DEVICE_MAPPINGS_FIELD, DATE_CREATED_FIELD, TAGS_FIELD, WORKING_DIRECTORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String platform;

    private final String owner;

    private final String version;

    private final List<ComponentConfiguration> components;

    private final String parentImage;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final String dateCreated;

    private final Map<String, String> tags;

    private final String workingDirectory;

    private ImageRecipe(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.platform = builder.platform;
        this.owner = builder.owner;
        this.version = builder.version;
        this.components = builder.components;
        this.parentImage = builder.parentImage;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.dateCreated = builder.dateCreated;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image recipe.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the image recipe.
     * </p>
     * 
     * @return The name of the image recipe.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the image recipe.
     * </p>
     * 
     * @return The description of the image recipe.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The platform of the image recipe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image recipe.
     * @see Platform
     */
    public Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the image recipe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image recipe.
     * @see Platform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The owner of the image recipe.
     * </p>
     * 
     * @return The owner of the image recipe.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The version of the image recipe.
     * </p>
     * 
     * @return The version of the image recipe.
     */
    public String version() {
        return version;
    }

    /**
     * Returns true if the Components property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components of the image recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The components of the image recipe.
     */
    public List<ComponentConfiguration> components() {
        return components;
    }

    /**
     * <p>
     * The parent image of the image recipe.
     * </p>
     * 
     * @return The parent image of the image recipe.
     */
    public String parentImage() {
        return parentImage;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mappings to apply when creating images from this recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The block device mappings to apply when creating images from this recipe.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The date on which this image recipe was created.
     * </p>
     * 
     * @return The date on which this image recipe was created.
     */
    public String dateCreated() {
        return dateCreated;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the image recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the image recipe.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The working directory to be used during build and test workflows.
     * </p>
     * 
     * @return The working directory to be used during build and test workflows.
     */
    public String workingDirectory() {
        return workingDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(components());
        hashCode = 31 * hashCode + Objects.hashCode(parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageRecipe)) {
            return false;
        }
        ImageRecipe other = (ImageRecipe) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(owner(), other.owner())
                && Objects.equals(version(), other.version()) && Objects.equals(components(), other.components())
                && Objects.equals(parentImage(), other.parentImage())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(tags(), other.tags())
                && Objects.equals(workingDirectory(), other.workingDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImageRecipe").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Platform", platformAsString()).add("Owner", owner()).add("Version", version())
                .add("Components", components()).add("ParentImage", parentImage())
                .add("BlockDeviceMappings", blockDeviceMappings()).add("DateCreated", dateCreated()).add("Tags", tags())
                .add("WorkingDirectory", workingDirectory()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "parentImage":
            return Optional.ofNullable(clazz.cast(parentImage()));
        case "blockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageRecipe, T> g) {
        return obj -> g.apply((ImageRecipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageRecipe> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image recipe.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the image recipe.
         * </p>
         * 
         * @param name
         *        The name of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the image recipe.
         * </p>
         * 
         * @param description
         *        The description of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The platform of the image recipe.
         * </p>
         * 
         * @param platform
         *        The platform of the image recipe.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the image recipe.
         * </p>
         * 
         * @param platform
         *        The platform of the image recipe.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The owner of the image recipe.
         * </p>
         * 
         * @param owner
         *        The owner of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The version of the image recipe.
         * </p>
         * 
         * @param version
         *        The version of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The components of the image recipe.
         * </p>
         * 
         * @param components
         *        The components of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ComponentConfiguration> components);

        /**
         * <p>
         * The components of the image recipe.
         * </p>
         * 
         * @param components
         *        The components of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ComponentConfiguration... components);

        /**
         * <p>
         * The components of the image recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<ComponentConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<ComponentConfiguration>)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link List<ComponentConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(List<ComponentConfiguration>)
         */
        Builder components(Consumer<ComponentConfiguration.Builder>... components);

        /**
         * <p>
         * The parent image of the image recipe.
         * </p>
         * 
         * @param parentImage
         *        The parent image of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentImage(String parentImage);

        /**
         * <p>
         * The block device mappings to apply when creating images from this recipe.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings to apply when creating images from this recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mappings to apply when creating images from this recipe.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings to apply when creating images from this recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mappings to apply when creating images from this recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceBlockDeviceMapping>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceBlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceBlockDeviceMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<InstanceBlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The date on which this image recipe was created.
         * </p>
         * 
         * @param dateCreated
         *        The date on which this image recipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * The tags of the image recipe.
         * </p>
         * 
         * @param tags
         *        The tags of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The working directory to be used during build and test workflows.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory to be used during build and test workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String platform;

        private String owner;

        private String version;

        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();

        private String parentImage;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String dateCreated;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workingDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageRecipe model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            platform(model.platform);
            owner(model.owner);
            version(model.version);
            components(model.components);
            parentImage(model.parentImage);
            blockDeviceMappings(model.blockDeviceMappings);
            dateCreated(model.dateCreated);
            tags(model.tags);
            workingDirectory(model.workingDirectory);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<ComponentConfiguration.Builder> getComponents() {
            return components != null ? components.stream().map(ComponentConfiguration::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ComponentConfiguration... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder>... components) {
            components(Stream.of(components).map(c -> ComponentConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        public final String getParentImage() {
            return parentImage;
        }

        @Override
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public ImageRecipe build() {
            return new ImageRecipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
