/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A distribution configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionConfiguration.Builder, DistributionConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DistributionConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DistributionConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DistributionConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Distribution>> DISTRIBUTIONS_FIELD = SdkField
            .<List<Distribution>> builder(MarshallingType.LIST)
            .memberName("distributions")
            .getter(getter(DistributionConfiguration::distributions))
            .setter(setter(Builder::distributions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Distribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(Distribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(DistributionConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(DistributionConfiguration::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateUpdated").getter(getter(DistributionConfiguration::dateUpdated))
            .setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DistributionConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DISTRIBUTIONS_FIELD, TIMEOUT_MINUTES_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final List<Distribution> distributions;

    private final Integer timeoutMinutes;

    private final String dateCreated;

    private final String dateUpdated;

    private final Map<String, String> tags;

    private DistributionConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.distributions = builder.distributions;
        this.timeoutMinutes = builder.timeoutMinutes;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the distribution configuration.
     * </p>
     * 
     * @return The name of the distribution configuration.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the distribution configuration.
     * </p>
     * 
     * @return The description of the distribution configuration.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Distributions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDistributions() {
        return distributions != null && !(distributions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The distributions of the distribution configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDistributions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The distributions of the distribution configuration.
     */
    public List<Distribution> distributions() {
        return distributions;
    }

    /**
     * <p>
     * The maximum duration in minutes for this distribution configuration.
     * </p>
     * 
     * @return The maximum duration in minutes for this distribution configuration.
     */
    public Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * <p>
     * The date on which this distribution configuration was created.
     * </p>
     * 
     * @return The date on which this distribution configuration was created.
     */
    public String dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date on which this distribution configuration was last updated.
     * </p>
     * 
     * @return The date on which this distribution configuration was last updated.
     */
    public String dateUpdated() {
        return dateUpdated;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the distribution configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the distribution configuration.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(distributions());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfiguration)) {
            return false;
        }
        DistributionConfiguration other = (DistributionConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(distributions(), other.distributions())
                && Objects.equals(timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(dateCreated(), other.dateCreated())
                && Objects.equals(dateUpdated(), other.dateUpdated()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DistributionConfiguration").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Distributions", distributions()).add("TimeoutMinutes", timeoutMinutes())
                .add("DateCreated", dateCreated()).add("DateUpdated", dateUpdated()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "distributions":
            return Optional.ofNullable(clazz.cast(distributions()));
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "dateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DistributionConfiguration, T> g) {
        return obj -> g.apply((DistributionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the distribution configuration.
         * </p>
         * 
         * @param name
         *        The name of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the distribution configuration.
         * </p>
         * 
         * @param description
         *        The description of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The distributions of the distribution configuration.
         * </p>
         * 
         * @param distributions
         *        The distributions of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributions(Collection<Distribution> distributions);

        /**
         * <p>
         * The distributions of the distribution configuration.
         * </p>
         * 
         * @param distributions
         *        The distributions of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributions(Distribution... distributions);

        /**
         * <p>
         * The distributions of the distribution configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Distribution>.Builder} avoiding the need to
         * create one manually via {@link List<Distribution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Distribution>.Builder#build()} is called immediately and its
         * result is passed to {@link #distributions(List<Distribution>)}.
         * 
         * @param distributions
         *        a consumer that will call methods on {@link List<Distribution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributions(List<Distribution>)
         */
        Builder distributions(Consumer<Distribution.Builder>... distributions);

        /**
         * <p>
         * The maximum duration in minutes for this distribution configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The maximum duration in minutes for this distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The date on which this distribution configuration was created.
         * </p>
         * 
         * @param dateCreated
         *        The date on which this distribution configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * The date on which this distribution configuration was last updated.
         * </p>
         * 
         * @param dateUpdated
         *        The date on which this distribution configuration was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(String dateUpdated);

        /**
         * <p>
         * The tags of the distribution configuration.
         * </p>
         * 
         * @param tags
         *        The tags of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private List<Distribution> distributions = DefaultSdkAutoConstructList.getInstance();

        private Integer timeoutMinutes;

        private String dateCreated;

        private String dateUpdated;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfiguration model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            distributions(model.distributions);
            timeoutMinutes(model.timeoutMinutes);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Distribution.Builder> getDistributions() {
            return distributions != null ? distributions.stream().map(Distribution::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder distributions(Collection<Distribution> distributions) {
            this.distributions = DistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Distribution... distributions) {
            distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<Distribution.Builder>... distributions) {
            distributions(Stream.of(distributions).map(c -> Distribution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDistributions(Collection<Distribution.BuilderImpl> distributions) {
            this.distributions = DistributionListCopier.copyFromBuilder(distributions);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final String getDateUpdated() {
            return dateUpdated;
        }

        @Override
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DistributionConfiguration build() {
            return new DistributionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
