/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an image pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImagePipeline implements SdkPojo, Serializable, ToCopyableBuilder<ImagePipeline.Builder, ImagePipeline> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ImagePipeline::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImagePipeline::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ImagePipeline::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ImagePipeline::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enhancedImageMetadataEnabled")
            .getter(getter(ImagePipeline::enhancedImageMetadataEnabled))
            .setter(setter(Builder::enhancedImageMetadataEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled")
                    .build()).build();

    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageRecipeArn").getter(getter(ImagePipeline::imageRecipeArn)).setter(setter(Builder::imageRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()).build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("infrastructureConfigurationArn")
            .getter(getter(ImagePipeline::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("distributionConfigurationArn")
            .getter(getter(ImagePipeline::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField
            .<ImageTestsConfiguration> builder(MarshallingType.SDK_POJO).memberName("imageTestsConfiguration")
            .getter(getter(ImagePipeline::imageTestsConfiguration)).setter(setter(Builder::imageTestsConfiguration))
            .constructor(ImageTestsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build())
            .build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(ImagePipeline::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImagePipeline::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(ImagePipeline::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateUpdated").getter(getter(ImagePipeline::dateUpdated)).setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()).build();

    private static final SdkField<String> DATE_LAST_RUN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateLastRun").getter(getter(ImagePipeline::dateLastRun)).setter(setter(Builder::dateLastRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateLastRun").build()).build();

    private static final SdkField<String> DATE_NEXT_RUN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateNextRun").getter(getter(ImagePipeline::dateNextRun)).setter(setter(Builder::dateNextRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateNextRun").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ImagePipeline::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, PLATFORM_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD, IMAGE_RECIPE_ARN_FIELD,
            INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD,
            SCHEDULE_FIELD, STATUS_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, DATE_LAST_RUN_FIELD, DATE_NEXT_RUN_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String platform;

    private final Boolean enhancedImageMetadataEnabled;

    private final String imageRecipeArn;

    private final String infrastructureConfigurationArn;

    private final String distributionConfigurationArn;

    private final ImageTestsConfiguration imageTestsConfiguration;

    private final Schedule schedule;

    private final String status;

    private final String dateCreated;

    private final String dateUpdated;

    private final String dateLastRun;

    private final String dateNextRun;

    private final Map<String, String> tags;

    private ImagePipeline(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.platform = builder.platform;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.imageRecipeArn = builder.imageRecipeArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.dateLastRun = builder.dateLastRun;
        this.dateNextRun = builder.dateNextRun;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image pipeline.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the image pipeline.
     * </p>
     * 
     * @return The name of the image pipeline.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the image pipeline.
     * </p>
     * 
     * @return The description of the image pipeline.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The platform of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image pipeline.
     * @see Platform
     */
    public Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image pipeline.
     * @see Platform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * Collects additional information about the image being created, including the operating system (OS) version and
     * package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by
     * default.
     * </p>
     * 
     * @return Collects additional information about the image being created, including the operating system (OS)
     *         version and package list. This information is used to enhance the overall experience of using EC2 Image
     *         Builder. Enabled by default.
     */
    public Boolean enhancedImageMetadataEnabled() {
        return enhancedImageMetadataEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
     */
    public String imageRecipeArn() {
        return imageRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    public String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
     */
    public String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    /**
     * <p>
     * The image tests configuration of the image pipeline.
     * </p>
     * 
     * @return The image tests configuration of the image pipeline.
     */
    public ImageTestsConfiguration imageTestsConfiguration() {
        return imageTestsConfiguration;
    }

    /**
     * <p>
     * The schedule of the image pipeline.
     * </p>
     * 
     * @return The schedule of the image pipeline.
     */
    public Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the image pipeline.
     * @see PipelineStatus
     */
    public PipelineStatus status() {
        return PipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the image pipeline.
     * @see PipelineStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date on which this image pipeline was created.
     * </p>
     * 
     * @return The date on which this image pipeline was created.
     */
    public String dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date on which this image pipeline was last updated.
     * </p>
     * 
     * @return The date on which this image pipeline was last updated.
     */
    public String dateUpdated() {
        return dateUpdated;
    }

    /**
     * <p>
     * The date on which this image pipeline was last run.
     * </p>
     * 
     * @return The date on which this image pipeline was last run.
     */
    public String dateLastRun() {
        return dateLastRun;
    }

    /**
     * <p>
     * The date on which this image pipeline will next be run.
     * </p>
     * 
     * @return The date on which this image pipeline will next be run.
     */
    public String dateNextRun() {
        return dateNextRun;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of this image pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of this image pipeline.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(dateLastRun());
        hashCode = 31 * hashCode + Objects.hashCode(dateNextRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagePipeline)) {
            return false;
        }
        ImagePipeline other = (ImagePipeline) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled())
                && Objects.equals(imageRecipeArn(), other.imageRecipeArn())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn())
                && Objects.equals(imageTestsConfiguration(), other.imageTestsConfiguration())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && Objects.equals(dateLastRun(), other.dateLastRun()) && Objects.equals(dateNextRun(), other.dateNextRun())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImagePipeline").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Platform", platformAsString()).add("EnhancedImageMetadataEnabled", enhancedImageMetadataEnabled())
                .add("ImageRecipeArn", imageRecipeArn()).add("InfrastructureConfigurationArn", infrastructureConfigurationArn())
                .add("DistributionConfigurationArn", distributionConfigurationArn())
                .add("ImageTestsConfiguration", imageTestsConfiguration()).add("Schedule", schedule())
                .add("Status", statusAsString()).add("DateCreated", dateCreated()).add("DateUpdated", dateUpdated())
                .add("DateLastRun", dateLastRun()).add("DateNextRun", dateNextRun()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "enhancedImageMetadataEnabled":
            return Optional.ofNullable(clazz.cast(enhancedImageMetadataEnabled()));
        case "imageRecipeArn":
            return Optional.ofNullable(clazz.cast(imageRecipeArn()));
        case "infrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        case "imageTestsConfiguration":
            return Optional.ofNullable(clazz.cast(imageTestsConfiguration()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "dateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "dateLastRun":
            return Optional.ofNullable(clazz.cast(dateLastRun()));
        case "dateNextRun":
            return Optional.ofNullable(clazz.cast(dateNextRun()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImagePipeline, T> g) {
        return obj -> g.apply((ImagePipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImagePipeline> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image pipeline.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the image pipeline.
         * </p>
         * 
         * @param name
         *        The name of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the image pipeline.
         * </p>
         * 
         * @param description
         *        The description of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The platform of the image pipeline.
         * </p>
         * 
         * @param platform
         *        The platform of the image pipeline.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the image pipeline.
         * </p>
         * 
         * @param platform
         *        The platform of the image pipeline.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * Collects additional information about the image being created, including the operating system (OS) version
         * and package list. This information is used to enhance the overall experience of using EC2 Image Builder.
         * Enabled by default.
         * </p>
         * 
         * @param enhancedImageMetadataEnabled
         *        Collects additional information about the image being created, including the operating system (OS)
         *        version and package list. This information is used to enhance the overall experience of using EC2
         *        Image Builder. Enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
         * </p>
         * 
         * @param imageRecipeArn
         *        The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageRecipeArn(String imageRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image
         *        pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        /**
         * <p>
         * The image tests configuration of the image pipeline.
         * </p>
         * 
         * @param imageTestsConfiguration
         *        The image tests configuration of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration);

        /**
         * <p>
         * The image tests configuration of the image pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageTestsConfiguration.Builder} avoiding the
         * need to create one manually via {@link ImageTestsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageTestsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageTestsConfiguration(ImageTestsConfiguration)}.
         * 
         * @param imageTestsConfiguration
         *        a consumer that will call methods on {@link ImageTestsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTestsConfiguration(ImageTestsConfiguration)
         */
        default Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return imageTestsConfiguration(ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration).build());
        }

        /**
         * <p>
         * The schedule of the image pipeline.
         * </p>
         * 
         * @param schedule
         *        The schedule of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule of the image pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link Schedule.Builder} avoiding the need to create
         * one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the image pipeline.
         * </p>
         * 
         * @param status
         *        The status of the image pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the image pipeline.
         * </p>
         * 
         * @param status
         *        The status of the image pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(PipelineStatus status);

        /**
         * <p>
         * The date on which this image pipeline was created.
         * </p>
         * 
         * @param dateCreated
         *        The date on which this image pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * The date on which this image pipeline was last updated.
         * </p>
         * 
         * @param dateUpdated
         *        The date on which this image pipeline was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(String dateUpdated);

        /**
         * <p>
         * The date on which this image pipeline was last run.
         * </p>
         * 
         * @param dateLastRun
         *        The date on which this image pipeline was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateLastRun(String dateLastRun);

        /**
         * <p>
         * The date on which this image pipeline will next be run.
         * </p>
         * 
         * @param dateNextRun
         *        The date on which this image pipeline will next be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateNextRun(String dateNextRun);

        /**
         * <p>
         * The tags of this image pipeline.
         * </p>
         * 
         * @param tags
         *        The tags of this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String platform;

        private Boolean enhancedImageMetadataEnabled;

        private String imageRecipeArn;

        private String infrastructureConfigurationArn;

        private String distributionConfigurationArn;

        private ImageTestsConfiguration imageTestsConfiguration;

        private Schedule schedule;

        private String status;

        private String dateCreated;

        private String dateUpdated;

        private String dateLastRun;

        private String dateNextRun;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImagePipeline model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            platform(model.platform);
            enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            imageRecipeArn(model.imageRecipeArn);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            distributionConfigurationArn(model.distributionConfigurationArn);
            imageTestsConfiguration(model.imageTestsConfiguration);
            schedule(model.schedule);
            status(model.status);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            dateLastRun(model.dateLastRun);
            dateNextRun(model.dateNextRun);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        public final String getImageRecipeArn() {
            return imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return imageTestsConfiguration != null ? imageTestsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final String getDateUpdated() {
            return dateUpdated;
        }

        @Override
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getDateLastRun() {
            return dateLastRun;
        }

        @Override
        public final Builder dateLastRun(String dateLastRun) {
            this.dateLastRun = dateLastRun;
            return this;
        }

        public final void setDateLastRun(String dateLastRun) {
            this.dateLastRun = dateLastRun;
        }

        public final String getDateNextRun() {
            return dateNextRun;
        }

        @Override
        public final Builder dateNextRun(String dateNextRun) {
            this.dateNextRun = dateNextRun;
            return this;
        }

        public final void setDateNextRun(String dateNextRun) {
            this.dateNextRun = dateNextRun;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public ImagePipeline build() {
            return new ImagePipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
