/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resources produced by this image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputResources implements SdkPojo, Serializable, ToCopyableBuilder<OutputResources.Builder, OutputResources> {
    private static final SdkField<List<Ami>> AMIS_FIELD = SdkField
            .<List<Ami>> builder(MarshallingType.LIST)
            .memberName("amis")
            .getter(getter(OutputResources::amis))
            .setter(setter(Builder::amis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ami> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ami::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Ami> amis;

    private OutputResources(BuilderImpl builder) {
        this.amis = builder.amis;
    }

    /**
     * Returns true if the Amis property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAmis() {
        return amis != null && !(amis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 AMIs created by this image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAmis()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The EC2 AMIs created by this image.
     */
    public List<Ami> amis() {
        return amis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAmis() ? amis() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputResources)) {
            return false;
        }
        OutputResources other = (OutputResources) obj;
        return hasAmis() == other.hasAmis() && Objects.equals(amis(), other.amis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputResources").add("Amis", hasAmis() ? amis() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amis":
            return Optional.ofNullable(clazz.cast(amis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputResources, T> g) {
        return obj -> g.apply((OutputResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputResources> {
        /**
         * <p>
         * The EC2 AMIs created by this image.
         * </p>
         * 
         * @param amis
         *        The EC2 AMIs created by this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Collection<Ami> amis);

        /**
         * <p>
         * The EC2 AMIs created by this image.
         * </p>
         * 
         * @param amis
         *        The EC2 AMIs created by this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Ami... amis);

        /**
         * <p>
         * The EC2 AMIs created by this image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ami>.Builder} avoiding the need to create
         * one manually via {@link List<Ami>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ami>.Builder#build()} is called immediately and its result
         * is passed to {@link #amis(List<Ami>)}.
         * 
         * @param amis
         *        a consumer that will call methods on {@link List<Ami>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amis(List<Ami>)
         */
        Builder amis(Consumer<Ami.Builder>... amis);
    }

    static final class BuilderImpl implements Builder {
        private List<Ami> amis = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputResources model) {
            amis(model.amis);
        }

        public final Collection<Ami.Builder> getAmis() {
            if (amis instanceof SdkAutoConstructList) {
                return null;
            }
            return amis != null ? amis.stream().map(Ami::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder amis(Collection<Ami> amis) {
            this.amis = AmiListCopier.copy(amis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Ami... amis) {
            amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Consumer<Ami.Builder>... amis) {
            amis(Stream.of(amis).map(c -> Ami.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAmis(Collection<Ami.BuilderImpl> amis) {
            this.amis = AmiListCopier.copyFromBuilder(amis);
        }

        @Override
        public OutputResources build() {
            return new OutputResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
