/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutComponentPolicyRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<PutComponentPolicyRequest.Builder, PutComponentPolicyRequest> {
    private static final SdkField<String> COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentArn").getter(getter(PutComponentPolicyRequest::componentArn))
            .setter(setter(Builder::componentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentArn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(PutComponentPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ARN_FIELD,
            POLICY_FIELD));

    private final String componentArn;

    private final String policy;

    private PutComponentPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.componentArn = builder.componentArn;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component that this policy should be applied to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component that this policy should be applied to.
     */
    public String componentArn() {
        return componentArn;
    }

    /**
     * <p>
     * The policy to apply.
     * </p>
     * 
     * @return The policy to apply.
     */
    public String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutComponentPolicyRequest)) {
            return false;
        }
        PutComponentPolicyRequest other = (PutComponentPolicyRequest) obj;
        return Objects.equals(componentArn(), other.componentArn()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutComponentPolicyRequest").add("ComponentArn", componentArn()).add("Policy", policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentArn":
            return Optional.ofNullable(clazz.cast(componentArn()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutComponentPolicyRequest, T> g) {
        return obj -> g.apply((PutComponentPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutComponentPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component that this policy should be applied to.
         * </p>
         * 
         * @param componentArn
         *        The Amazon Resource Name (ARN) of the component that this policy should be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentArn(String componentArn);

        /**
         * <p>
         * The policy to apply.
         * </p>
         * 
         * @param policy
         *        The policy to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String componentArn;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutComponentPolicyRequest model) {
            super(model);
            componentArn(model.componentArn);
            policy(model.policy);
        }

        public final String getComponentArn() {
            return componentArn;
        }

        @Override
        public final Builder componentArn(String componentArn) {
            this.componentArn = componentArn;
            return this;
        }

        public final void setComponentArn(String componentArn) {
            this.componentArn = componentArn;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutComponentPolicyRequest build() {
            return new PutComponentPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
