/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon EBS-specific block device mapping specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsInstanceBlockDeviceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsInstanceBlockDeviceSpecification.Builder, EbsInstanceBlockDeviceSpecification> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("encrypted").getter(getter(EbsInstanceBlockDeviceSpecification::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteOnTermination").getter(getter(EbsInstanceBlockDeviceSpecification::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteOnTermination").build())
            .build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("iops")
            .getter(getter(EbsInstanceBlockDeviceSpecification::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(EbsInstanceBlockDeviceSpecification::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotId").getter(getter(EbsInstanceBlockDeviceSpecification::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeSize").getter(getter(EbsInstanceBlockDeviceSpecification::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeType").getter(getter(EbsInstanceBlockDeviceSpecification::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_FIELD,
            DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ID_FIELD, VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean encrypted;

    private final Boolean deleteOnTermination;

    private final Integer iops;

    private final String kmsKeyId;

    private final String snapshotId;

    private final Integer volumeSize;

    private final String volumeType;

    private EbsInstanceBlockDeviceSpecification(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * Use to configure device encryption.
     * </p>
     * 
     * @return Use to configure device encryption.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * Use to configure delete on termination of the associated device.
     * </p>
     * 
     * @return Use to configure delete on termination of the associated device.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * Use to configure device IOPS.
     * </p>
     * 
     * @return Use to configure device IOPS.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Use to configure the KMS key to use when encrypting the device.
     * </p>
     * 
     * @return Use to configure the KMS key to use when encrypting the device.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The snapshot that defines the device contents.
     * </p>
     * 
     * @return The snapshot that defines the device contents.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Use to override the device's volume size.
     * </p>
     * 
     * @return Use to override the device's volume size.
     */
    public Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * Use to override the device's volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link EbsVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Use to override the device's volume type.
     * @see EbsVolumeType
     */
    public EbsVolumeType volumeType() {
        return EbsVolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * Use to override the device's volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link EbsVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Use to override the device's volume type.
     * @see EbsVolumeType
     */
    public String volumeTypeAsString() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInstanceBlockDeviceSpecification)) {
            return false;
        }
        EbsInstanceBlockDeviceSpecification other = (EbsInstanceBlockDeviceSpecification) obj;
        return Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(iops(), other.iops())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EbsInstanceBlockDeviceSpecification").add("Encrypted", encrypted())
                .add("DeleteOnTermination", deleteOnTermination()).add("Iops", iops()).add("KmsKeyId", kmsKeyId())
                .add("SnapshotId", snapshotId()).add("VolumeSize", volumeSize()).add("VolumeType", volumeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "deleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "snapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "volumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "volumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsInstanceBlockDeviceSpecification, T> g) {
        return obj -> g.apply((EbsInstanceBlockDeviceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsInstanceBlockDeviceSpecification> {
        /**
         * <p>
         * Use to configure device encryption.
         * </p>
         * 
         * @param encrypted
         *        Use to configure device encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * Use to configure delete on termination of the associated device.
         * </p>
         * 
         * @param deleteOnTermination
         *        Use to configure delete on termination of the associated device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * Use to configure device IOPS.
         * </p>
         * 
         * @param iops
         *        Use to configure device IOPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Use to configure the KMS key to use when encrypting the device.
         * </p>
         * 
         * @param kmsKeyId
         *        Use to configure the KMS key to use when encrypting the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The snapshot that defines the device contents.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot that defines the device contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Use to override the device's volume size.
         * </p>
         * 
         * @param volumeSize
         *        Use to override the device's volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * Use to override the device's volume type.
         * </p>
         * 
         * @param volumeType
         *        Use to override the device's volume type.
         * @see EbsVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsVolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Use to override the device's volume type.
         * </p>
         * 
         * @param volumeType
         *        Use to override the device's volume type.
         * @see EbsVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsVolumeType
         */
        Builder volumeType(EbsVolumeType volumeType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean encrypted;

        private Boolean deleteOnTermination;

        private Integer iops;

        private String kmsKeyId;

        private String snapshotId;

        private Integer volumeSize;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInstanceBlockDeviceSpecification model) {
            encrypted(model.encrypted);
            deleteOnTermination(model.deleteOnTermination);
            iops(model.iops);
            kmsKeyId(model.kmsKeyId);
            snapshotId(model.snapshotId);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(EbsVolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public EbsInstanceBlockDeviceSpecification build() {
            return new EbsInstanceBlockDeviceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
