/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteComponentResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<DeleteComponentResponse.Builder, DeleteComponentResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(DeleteComponentResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> COMPONENT_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentBuildVersionArn").getter(getter(DeleteComponentResponse::componentBuildVersionArn))
            .setter(setter(Builder::componentBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentBuildVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            COMPONENT_BUILD_VERSION_ARN_FIELD));

    private final String requestIdValue;

    private final String componentBuildVersionArn;

    private DeleteComponentResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.componentBuildVersionArn = builder.componentBuildVersionArn;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component build version that was deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component build version that was deleted.
     */
    public final String componentBuildVersionArn() {
        return componentBuildVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(componentBuildVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteComponentResponse)) {
            return false;
        }
        DeleteComponentResponse other = (DeleteComponentResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(componentBuildVersionArn(), other.componentBuildVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteComponentResponse").add("RequestId", requestId())
                .add("ComponentBuildVersionArn", componentBuildVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "componentBuildVersionArn":
            return Optional.ofNullable(clazz.cast(componentBuildVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteComponentResponse, T> g) {
        return obj -> g.apply((DeleteComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteComponentResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component build version that was deleted.
         * </p>
         * 
         * @param componentBuildVersionArn
         *        The Amazon Resource Name (ARN) of the component build version that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentBuildVersionArn(String componentBuildVersionArn);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private String componentBuildVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteComponentResponse model) {
            super(model);
            requestId(model.requestIdValue);
            componentBuildVersionArn(model.componentBuildVersionArn);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getComponentBuildVersionArn() {
            return componentBuildVersionArn;
        }

        @Override
        public final Builder componentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
            return this;
        }

        public final void setComponentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
        }

        @Override
        public DeleteComponentResponse build() {
            return new DeleteComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
