/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.imagebuilder.model.CallRateLimitExceededException;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ClientException;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ForbiddenException;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterValueException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidRequestException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidVersionNumberException;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceDependencyException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceInUseException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceUnavailableException;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher;
import software.amazon.awssdk.services.imagebuilder.transform.CancelImageCreationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListContainerRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListDistributionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelineImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelinesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListInfrastructureConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.StartImagePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ImagebuilderAsyncClient}.
 *
 * @see ImagebuilderAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultImagebuilderAsyncClient implements ImagebuilderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultImagebuilderAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultImagebuilderAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     *
     * @param cancelImageCreationRequest
     * @return A Java Future containing the result of the CancelImageCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CancelImageCreation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelImageCreationResponse> cancelImageCreation(
            CancelImageCreationRequest cancelImageCreationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImageCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImageCreation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelImageCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelImageCreationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelImageCreationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelImageCreationRequest, CancelImageCreationResponse>()
                            .withOperationName("CancelImageCreation")
                            .withMarshaller(new CancelImageCreationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelImageCreationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelImageCreationRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CancelImageCreationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image.
     * </p>
     *
     * @param createComponentRequest
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateComponent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequest createComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateComponentRequest, CreateComponentResponse>()
                            .withOperationName("CreateComponent")
                            .withMarshaller(new CreateComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createComponentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createComponentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createContainerRecipeRequest
     * @return A Java Future containing the result of the CreateContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateContainerRecipe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerRecipeResponse> createContainerRecipe(
            CreateContainerRecipeRequest createContainerRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContainerRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContainerRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerRecipeRequest, CreateContainerRecipeResponse>()
                            .withOperationName("CreateContainerRecipe")
                            .withMarshaller(new CreateContainerRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createContainerRecipeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createContainerRecipeRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateContainerRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param createDistributionConfigurationRequest
     * @return A Java Future containing the result of the CreateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateDistributionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDistributionConfigurationResponse> createDistributionConfiguration(
            CreateDistributionConfigurationRequest createDistributionConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionConfigurationRequest, CreateDistributionConfigurationResponse>()
                            .withOperationName("CreateDistributionConfiguration")
                            .withMarshaller(new CreateDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDistributionConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDistributionConfigurationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                            .withOperationName("CreateImage").withMarshaller(new CreateImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createImageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createImageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param createImagePipelineRequest
     * @return A Java Future containing the result of the CreateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImagePipeline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImagePipelineResponse> createImagePipeline(
            CreateImagePipelineRequest createImagePipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImagePipelineRequest, CreateImagePipelineResponse>()
                            .withOperationName("CreateImagePipeline")
                            .withMarshaller(new CreateImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createImagePipelineRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createImagePipelineRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createImageRecipeRequest
     * @return A Java Future containing the result of the CreateImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImageRecipe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageRecipeResponse> createImageRecipe(CreateImageRecipeRequest createImageRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImageRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRecipeRequest, CreateImageRecipeResponse>()
                            .withOperationName("CreateImageRecipe")
                            .withMarshaller(new CreateImageRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createImageRecipeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createImageRecipeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateImageRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the CreateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateInfrastructureConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInfrastructureConfigurationResponse> createInfrastructureConfiguration(
            CreateInfrastructureConfigurationRequest createInfrastructureConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInfrastructureConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInfrastructureConfigurationRequest, CreateInfrastructureConfigurationResponse>()
                            .withOperationName("CreateInfrastructureConfiguration")
                            .withMarshaller(new CreateInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createInfrastructureConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createInfrastructureConfigurationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     *
     * @param deleteComponentRequest
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteComponent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteComponentResponse> deleteComponent(DeleteComponentRequest deleteComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteComponentRequest, DeleteComponentResponse>()
                            .withOperationName("DeleteComponent")
                            .withMarshaller(new DeleteComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteComponentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteComponentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     *
     * @param deleteContainerRecipeRequest
     * @return A Java Future containing the result of the DeleteContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteContainerRecipe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContainerRecipeResponse> deleteContainerRecipe(
            DeleteContainerRecipeRequest deleteContainerRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContainerRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContainerRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContainerRecipeRequest, DeleteContainerRecipeResponse>()
                            .withOperationName("DeleteContainerRecipe")
                            .withMarshaller(new DeleteContainerRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteContainerRecipeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteContainerRecipeRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteContainerRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     * @return A Java Future containing the result of the DeleteDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteDistributionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDistributionConfigurationResponse> deleteDistributionConfiguration(
            DeleteDistributionConfigurationRequest deleteDistributionConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDistributionConfigurationRequest, DeleteDistributionConfigurationResponse>()
                            .withOperationName("DeleteDistributionConfiguration")
                            .withMarshaller(new DeleteDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDistributionConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDistributionConfigurationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an image.
     * </p>
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                            .withOperationName("DeleteImage").withMarshaller(new DeleteImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteImageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteImageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     *
     * @param deleteImagePipelineRequest
     * @return A Java Future containing the result of the DeleteImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImagePipeline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImagePipelineResponse> deleteImagePipeline(
            DeleteImagePipelineRequest deleteImagePipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImagePipelineRequest, DeleteImagePipelineResponse>()
                            .withOperationName("DeleteImagePipeline")
                            .withMarshaller(new DeleteImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteImagePipelineRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteImagePipelineRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     *
     * @param deleteImageRecipeRequest
     * @return A Java Future containing the result of the DeleteImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImageRecipe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageRecipeResponse> deleteImageRecipe(DeleteImageRecipeRequest deleteImageRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImageRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageRecipeRequest, DeleteImageRecipeResponse>()
                            .withOperationName("DeleteImageRecipe")
                            .withMarshaller(new DeleteImageRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteImageRecipeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteImageRecipeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteImageRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the DeleteInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteInfrastructureConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInfrastructureConfigurationResponse> deleteInfrastructureConfiguration(
            DeleteInfrastructureConfigurationRequest deleteInfrastructureConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInfrastructureConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInfrastructureConfigurationRequest, DeleteInfrastructureConfigurationResponse>()
                            .withOperationName("DeleteInfrastructureConfiguration")
                            .withMarshaller(new DeleteInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteInfrastructureConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteInfrastructureConfigurationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     *
     * @param getComponentRequest
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetComponentResponse> getComponent(GetComponentRequest getComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComponentRequest, GetComponentResponse>()
                            .withOperationName("GetComponent").withMarshaller(new GetComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getComponentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getComponentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     *
     * @param getComponentPolicyRequest
     * @return A Java Future containing the result of the GetComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponentPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComponentPolicyResponse> getComponentPolicy(GetComponentPolicyRequest getComponentPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetComponentPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComponentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComponentPolicyRequest, GetComponentPolicyResponse>()
                            .withOperationName("GetComponentPolicy")
                            .withMarshaller(new GetComponentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getComponentPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getComponentPolicyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetComponentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     *
     * @param getContainerRecipeRequest
     * @return A Java Future containing the result of the GetContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerRecipeResponse> getContainerRecipe(GetContainerRecipeRequest getContainerRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerRecipeRequest, GetContainerRecipeResponse>()
                            .withOperationName("GetContainerRecipe")
                            .withMarshaller(new GetContainerRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerRecipeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerRecipeRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     * @return A Java Future containing the result of the GetContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerRecipePolicyResponse> getContainerRecipePolicy(
            GetContainerRecipePolicyRequest getContainerRecipePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerRecipePolicyRequest, GetContainerRecipePolicyResponse>()
                            .withOperationName("GetContainerRecipePolicy")
                            .withMarshaller(new GetContainerRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerRecipePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerRecipePolicyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     *
     * @param getDistributionConfigurationRequest
     * @return A Java Future containing the result of the GetDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetDistributionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionConfigurationResponse> getDistributionConfiguration(
            GetDistributionConfigurationRequest getDistributionConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionConfigurationRequest, GetDistributionConfigurationResponse>()
                            .withOperationName("GetDistributionConfiguration")
                            .withMarshaller(new GetDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDistributionConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionConfigurationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     *
     * @param getImageRequest
     * @return A Java Future containing the result of the GetImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImageResponse> getImage(GetImageRequest getImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImageRequest, GetImageResponse>().withOperationName("GetImage")
                            .withMarshaller(new GetImageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     *
     * @param getImagePipelineRequest
     * @return A Java Future containing the result of the GetImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePipeline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImagePipelineResponse> getImagePipeline(GetImagePipelineRequest getImagePipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImagePipelineRequest, GetImagePipelineResponse>()
                            .withOperationName("GetImagePipeline")
                            .withMarshaller(new GetImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImagePipelineRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImagePipelineRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     *
     * @param getImagePolicyRequest
     * @return A Java Future containing the result of the GetImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImagePolicyResponse> getImagePolicy(GetImagePolicyRequest getImagePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImagePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImagePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImagePolicyRequest, GetImagePolicyResponse>()
                            .withOperationName("GetImagePolicy")
                            .withMarshaller(new GetImagePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImagePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImagePolicyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetImagePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     *
     * @param getImageRecipeRequest
     * @return A Java Future containing the result of the GetImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImageRecipeResponse> getImageRecipe(GetImageRecipeRequest getImageRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImageRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImageRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImageRecipeRequest, GetImageRecipeResponse>()
                            .withOperationName("GetImageRecipe")
                            .withMarshaller(new GetImageRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImageRecipeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImageRecipeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetImageRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     *
     * @param getImageRecipePolicyRequest
     * @return A Java Future containing the result of the GetImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImageRecipePolicyResponse> getImageRecipePolicy(
            GetImageRecipePolicyRequest getImageRecipePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImageRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImageRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImageRecipePolicyRequest, GetImageRecipePolicyResponse>()
                            .withOperationName("GetImageRecipePolicy")
                            .withMarshaller(new GetImageRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImageRecipePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImageRecipePolicyRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetImageRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        GetInfrastructureConfiguration request object.
     * @return A Java Future containing the result of the GetInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetInfrastructureConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInfrastructureConfigurationResponse> getInfrastructureConfiguration(
            GetInfrastructureConfigurationRequest getInfrastructureConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInfrastructureConfigurationRequest, GetInfrastructureConfigurationResponse>()
                            .withOperationName("GetInfrastructureConfiguration")
                            .withMarshaller(new GetInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInfrastructureConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInfrastructureConfigurationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     *
     * @param importComponentRequest
     * @return A Java Future containing the result of the ImportComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ImportComponent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportComponentResponse> importComponent(ImportComponentRequest importComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportComponentRequest, ImportComponentResponse>()
                            .withOperationName("ImportComponent")
                            .withMarshaller(new ImportComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importComponentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importComponentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ImportComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     * @return A Java Future containing the result of the ListComponentBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComponentBuildVersionsResponse> listComponentBuildVersions(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponentBuildVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComponentBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComponentBuildVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListComponentBuildVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComponentBuildVersionsRequest, ListComponentBuildVersionsResponse>()
                            .withOperationName("ListComponentBuildVersions")
                            .withMarshaller(new ListComponentBuildVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listComponentBuildVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listComponentBuildVersionsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListComponentBuildVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher publisher = client.listComponentBuildVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher publisher = client.listComponentBuildVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListComponentBuildVersionsPublisher listComponentBuildVersionsPaginator(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) {
        return new ListComponentBuildVersionsPublisher(this, applyPaginatorUserAgent(listComponentBuildVersionsRequest));
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComponentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListComponentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComponentsRequest, ListComponentsResponse>()
                            .withOperationName("ListComponents")
                            .withMarshaller(new ListComponentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listComponentsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listComponentsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListComponentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    public ListComponentsPublisher listComponentsPaginator(ListComponentsRequest listComponentsRequest) {
        return new ListComponentsPublisher(this, applyPaginatorUserAgent(listComponentsRequest));
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A Java Future containing the result of the ListContainerRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContainerRecipesResponse> listContainerRecipes(
            ListContainerRecipesRequest listContainerRecipesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContainerRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerRecipes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContainerRecipesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListContainerRecipesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContainerRecipesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContainerRecipesRequest, ListContainerRecipesResponse>()
                            .withOperationName("ListContainerRecipes")
                            .withMarshaller(new ListContainerRecipesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listContainerRecipesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listContainerRecipesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListContainerRecipesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher publisher = client.listContainerRecipesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher publisher = client.listContainerRecipesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    public ListContainerRecipesPublisher listContainerRecipesPaginator(ListContainerRecipesRequest listContainerRecipesRequest) {
        return new ListContainerRecipesPublisher(this, applyPaginatorUserAgent(listContainerRecipesRequest));
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A Java Future containing the result of the ListDistributionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionConfigurationsResponse> listDistributionConfigurations(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDistributionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDistributionConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDistributionConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionConfigurationsRequest, ListDistributionConfigurationsResponse>()
                            .withOperationName("ListDistributionConfigurations")
                            .withMarshaller(new ListDistributionConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDistributionConfigurationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionConfigurationsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListDistributionConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher publisher = client.listDistributionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher publisher = client.listDistributionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDistributionConfigurationsPublisher listDistributionConfigurationsPaginator(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) {
        return new ListDistributionConfigurationsPublisher(this, applyPaginatorUserAgent(listDistributionConfigurationsRequest));
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A Java Future containing the result of the ListImageBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageBuildVersionsResponse> listImageBuildVersions(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageBuildVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImageBuildVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageBuildVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageBuildVersionsRequest, ListImageBuildVersionsResponse>()
                            .withOperationName("ListImageBuildVersions")
                            .withMarshaller(new ListImageBuildVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImageBuildVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listImageBuildVersionsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListImageBuildVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher publisher = client.listImageBuildVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher publisher = client.listImageBuildVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListImageBuildVersionsPublisher listImageBuildVersionsPaginator(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) {
        return new ListImageBuildVersionsPublisher(this, applyPaginatorUserAgent(listImageBuildVersionsRequest));
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A Java Future containing the result of the ListImagePipelineImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagePipelineImagesResponse> listImagePipelineImages(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelineImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelineImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagePipelineImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImagePipelineImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagePipelineImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagePipelineImagesRequest, ListImagePipelineImagesResponse>()
                            .withOperationName("ListImagePipelineImages")
                            .withMarshaller(new ListImagePipelineImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImagePipelineImagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listImagePipelineImagesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListImagePipelineImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher publisher = client.listImagePipelineImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher publisher = client.listImagePipelineImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    public ListImagePipelineImagesPublisher listImagePipelineImagesPaginator(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) {
        return new ListImagePipelineImagesPublisher(this, applyPaginatorUserAgent(listImagePipelineImagesRequest));
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A Java Future containing the result of the ListImagePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagePipelinesResponse> listImagePipelines(ListImagePipelinesRequest listImagePipelinesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagePipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImagePipelinesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagePipelinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagePipelinesRequest, ListImagePipelinesResponse>()
                            .withOperationName("ListImagePipelines")
                            .withMarshaller(new ListImagePipelinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImagePipelinesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listImagePipelinesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListImagePipelinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher publisher = client.listImagePipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher publisher = client.listImagePipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    public ListImagePipelinesPublisher listImagePipelinesPaginator(ListImagePipelinesRequest listImagePipelinesRequest) {
        return new ListImagePipelinesPublisher(this, applyPaginatorUserAgent(listImagePipelinesRequest));
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A Java Future containing the result of the ListImageRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageRecipesResponse> listImageRecipes(ListImageRecipesRequest listImageRecipesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageRecipes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageRecipesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImageRecipesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageRecipesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageRecipesRequest, ListImageRecipesResponse>()
                            .withOperationName("ListImageRecipes")
                            .withMarshaller(new ListImageRecipesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImageRecipesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listImageRecipesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListImageRecipesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher publisher = client.listImageRecipesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher publisher = client.listImageRecipesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    public ListImageRecipesPublisher listImageRecipesPaginator(ListImageRecipesRequest listImageRecipesRequest) {
        return new ListImageRecipesPublisher(this, applyPaginatorUserAgent(listImageRecipesRequest));
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     *
     * @param listImagesRequest
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagesResponse> listImages(ListImagesRequest listImagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagesRequest, ListImagesResponse>().withOperationName("ListImages")
                            .withMarshaller(new ListImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listImagesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    public ListImagesPublisher listImagesPaginator(ListImagesRequest listImagesRequest) {
        return new ListImagesPublisher(this, applyPaginatorUserAgent(listImagesRequest));
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A Java Future containing the result of the ListInfrastructureConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInfrastructureConfigurationsResponse> listInfrastructureConfigurations(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listInfrastructureConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInfrastructureConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInfrastructureConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListInfrastructureConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInfrastructureConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInfrastructureConfigurationsRequest, ListInfrastructureConfigurationsResponse>()
                            .withOperationName("ListInfrastructureConfigurations")
                            .withMarshaller(new ListInfrastructureConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listInfrastructureConfigurationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listInfrastructureConfigurationsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListInfrastructureConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher publisher = client.listInfrastructureConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher publisher = client.listInfrastructureConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListInfrastructureConfigurationsPublisher listInfrastructureConfigurationsPaginator(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) {
        return new ListInfrastructureConfigurationsPublisher(this,
                applyPaginatorUserAgent(listInfrastructureConfigurationsRequest));
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putComponentPolicyRequest
     * @return A Java Future containing the result of the PutComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutComponentPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutComponentPolicyResponse> putComponentPolicy(PutComponentPolicyRequest putComponentPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutComponentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutComponentPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutComponentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutComponentPolicyRequest, PutComponentPolicyResponse>()
                            .withOperationName("PutComponentPolicy")
                            .withMarshaller(new PutComponentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putComponentPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putComponentPolicyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<PutComponentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for
     * the resource to be visible to all principals with whom the resource is shared.
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     * @return A Java Future containing the result of the PutContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutContainerRecipePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutContainerRecipePolicyResponse> putContainerRecipePolicy(
            PutContainerRecipePolicyRequest putContainerRecipePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutContainerRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutContainerRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutContainerRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutContainerRecipePolicyRequest, PutContainerRecipePolicyResponse>()
                            .withOperationName("PutContainerRecipePolicy")
                            .withMarshaller(new PutContainerRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putContainerRecipePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putContainerRecipePolicyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<PutContainerRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putImagePolicyRequest
     * @return A Java Future containing the result of the PutImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImagePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutImagePolicyResponse> putImagePolicy(PutImagePolicyRequest putImagePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImagePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutImagePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutImagePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutImagePolicyRequest, PutImagePolicyResponse>()
                            .withOperationName("PutImagePolicy")
                            .withMarshaller(new PutImagePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putImagePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putImagePolicyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutImagePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     *
     * @param putImageRecipePolicyRequest
     * @return A Java Future containing the result of the PutImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImageRecipePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutImageRecipePolicyResponse> putImageRecipePolicy(
            PutImageRecipePolicyRequest putImageRecipePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImageRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutImageRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutImageRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutImageRecipePolicyRequest, PutImageRecipePolicyResponse>()
                            .withOperationName("PutImageRecipePolicy")
                            .withMarshaller(new PutImageRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putImageRecipePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putImageRecipePolicyRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PutImageRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     * @return A Java Future containing the result of the StartImagePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.StartImagePipelineExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartImagePipelineExecutionResponse> startImagePipelineExecution(
            StartImagePipelineExecutionRequest startImagePipelineExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImagePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImagePipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartImagePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartImagePipelineExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartImagePipelineExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartImagePipelineExecutionRequest, StartImagePipelineExecutionResponse>()
                            .withOperationName("StartImagePipelineExecution")
                            .withMarshaller(new StartImagePipelineExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startImagePipelineExecutionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startImagePipelineExecutionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartImagePipelineExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     * @return A Java Future containing the result of the UpdateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateDistributionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDistributionConfigurationResponse> updateDistributionConfiguration(
            UpdateDistributionConfigurationRequest updateDistributionConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionConfigurationRequest, UpdateDistributionConfigurationResponse>()
                            .withOperationName("UpdateDistributionConfiguration")
                            .withMarshaller(new UpdateDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDistributionConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDistributionConfigurationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param updateImagePipelineRequest
     * @return A Java Future containing the result of the UpdateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateImagePipeline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateImagePipelineResponse> updateImagePipeline(
            UpdateImagePipelineRequest updateImagePipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateImagePipelineRequest, UpdateImagePipelineResponse>()
                            .withOperationName("UpdateImagePipeline")
                            .withMarshaller(new UpdateImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateImagePipelineRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateImagePipelineRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the UpdateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateInfrastructureConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInfrastructureConfigurationResponse> updateInfrastructureConfiguration(
            UpdateInfrastructureConfigurationRequest updateInfrastructureConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInfrastructureConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInfrastructureConfigurationRequest, UpdateInfrastructureConfigurationResponse>()
                            .withOperationName("UpdateInfrastructureConfiguration")
                            .withMarshaller(new UpdateInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateInfrastructureConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateInfrastructureConfigurationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ImagebuilderException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CallRateLimitExceededException")
                                .exceptionBuilderSupplier(CallRateLimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVersionNumberException")
                                .exceptionBuilderSupplier(InvalidVersionNumberException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientException")
                                .exceptionBuilderSupplier(ClientException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDependencyException")
                                .exceptionBuilderSupplier(ResourceDependencyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ImagebuilderRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
