/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageRecipeRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateImageRecipeRequest.Builder, CreateImageRecipeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateImageRecipeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateImageRecipeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(CreateImageRecipeRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField
            .<List<ComponentConfiguration>> builder(MarshallingType.LIST)
            .memberName("components")
            .getter(getter(CreateImageRecipeRequest::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentImage").getter(getter(CreateImageRecipeRequest::parentImage)).setter(setter(Builder::parentImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()).build();

    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("blockDeviceMappings")
            .getter(getter(CreateImageRecipeRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateImageRecipeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workingDirectory").getter(getter(CreateImageRecipeRequest::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateImageRecipeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SEMANTIC_VERSION_FIELD, COMPONENTS_FIELD, PARENT_IMAGE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, TAGS_FIELD,
            WORKING_DIRECTORY_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String description;

    private final String semanticVersion;

    private final List<ComponentConfiguration> components;

    private final String parentImage;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final Map<String, String> tags;

    private final String workingDirectory;

    private final String clientToken;

    private CreateImageRecipeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.semanticVersion = builder.semanticVersion;
        this.components = builder.components;
        this.parentImage = builder.parentImage;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the image recipe.
     * </p>
     * 
     * @return The name of the image recipe.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the image recipe.
     * </p>
     * 
     * @return The description of the image recipe.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The semantic version of the image recipe.
     * </p>
     * 
     * @return The semantic version of the image recipe.
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * Returns true if the Components property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components of the image recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The components of the image recipe.
     */
    public List<ComponentConfiguration> components() {
        return components;
    }

    /**
     * <p>
     * The parent image of the image recipe. The value of the string can be the ARN of the parent image or an AMI ID.
     * The format for the ARN follows this example:
     * <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/xxxx.x.x</code>. You can
     * provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter
     * an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which
     * you are using Image Builder.
     * </p>
     * 
     * @return The parent image of the image recipe. The value of the string can be the ARN of the parent image or an
     *         AMI ID. The format for the ARN follows this example:
     *         <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/xxxx.x.x</code>.
     *         You can provide the specific version that you want to use, or you can use a wildcard in all of the
     *         fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be
     *         in the same Region in which you are using Image Builder.
     */
    public String parentImage() {
        return parentImage;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mappings of the image recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The block device mappings of the image recipe.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the image recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the image recipe.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The working directory to be used during build and test workflows.
     * </p>
     * 
     * @return The working directory to be used during build and test workflows.
     */
    public String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * The idempotency token used to make this request idempotent.
     * </p>
     * 
     * @return The idempotency token used to make this request idempotent.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(components());
        hashCode = 31 * hashCode + Objects.hashCode(parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRecipeRequest)) {
            return false;
        }
        CreateImageRecipeRequest other = (CreateImageRecipeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(semanticVersion(), other.semanticVersion()) && Objects.equals(components(), other.components())
                && Objects.equals(parentImage(), other.parentImage())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(tags(), other.tags())
                && Objects.equals(workingDirectory(), other.workingDirectory())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateImageRecipeRequest").add("Name", name()).add("Description", description())
                .add("SemanticVersion", semanticVersion()).add("Components", components()).add("ParentImage", parentImage())
                .add("BlockDeviceMappings", blockDeviceMappings()).add("Tags", tags())
                .add("WorkingDirectory", workingDirectory()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "parentImage":
            return Optional.ofNullable(clazz.cast(parentImage()));
        case "blockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRecipeRequest, T> g) {
        return obj -> g.apply((CreateImageRecipeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageRecipeRequest> {
        /**
         * <p>
         * The name of the image recipe.
         * </p>
         * 
         * @param name
         *        The name of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the image recipe.
         * </p>
         * 
         * @param description
         *        The description of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The semantic version of the image recipe.
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The components of the image recipe.
         * </p>
         * 
         * @param components
         *        The components of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ComponentConfiguration> components);

        /**
         * <p>
         * The components of the image recipe.
         * </p>
         * 
         * @param components
         *        The components of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ComponentConfiguration... components);

        /**
         * <p>
         * The components of the image recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<ComponentConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<ComponentConfiguration>)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link List<ComponentConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(List<ComponentConfiguration>)
         */
        Builder components(Consumer<ComponentConfiguration.Builder>... components);

        /**
         * <p>
         * The parent image of the image recipe. The value of the string can be the ARN of the parent image or an AMI
         * ID. The format for the ARN follows this example:
         * <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/xxxx.x.x</code>. You
         * can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you
         * enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region
         * in which you are using Image Builder.
         * </p>
         * 
         * @param parentImage
         *        The parent image of the image recipe. The value of the string can be the ARN of the parent image or an
         *        AMI ID. The format for the ARN follows this example:
         *        <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/xxxx.x.x</code>
         *        . You can provide the specific version that you want to use, or you can use a wildcard in all of the
         *        fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must
         *        be in the same Region in which you are using Image Builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentImage(String parentImage);

        /**
         * <p>
         * The block device mappings of the image recipe.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mappings of the image recipe.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mappings of the image recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceBlockDeviceMapping>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceBlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceBlockDeviceMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<InstanceBlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The tags of the image recipe.
         * </p>
         * 
         * @param tags
         *        The tags of the image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The working directory to be used during build and test workflows.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory to be used during build and test workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * The idempotency token used to make this request idempotent.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token used to make this request idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String semanticVersion;

        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();

        private String parentImage;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workingDirectory;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRecipeRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            semanticVersion(model.semanticVersion);
            components(model.components);
            parentImage(model.parentImage);
            blockDeviceMappings(model.blockDeviceMappings);
            tags(model.tags);
            workingDirectory(model.workingDirectory);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final Collection<ComponentConfiguration.Builder> getComponents() {
            return components != null ? components.stream().map(ComponentConfiguration::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ComponentConfiguration... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder>... components) {
            components(Stream.of(components).map(c -> ComponentConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        public final String getParentImage() {
            return parentImage;
        }

        @Override
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRecipeRequest build() {
            return new CreateImageRecipeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
