/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a container recipe
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerRecipeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerRecipeSummary.Builder, ContainerRecipeSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ContainerRecipeSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerType").getter(getter(ContainerRecipeSummary::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContainerRecipeSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ContainerRecipeSummary::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ContainerRecipeSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentImage").getter(getter(ContainerRecipeSummary::parentImage)).setter(setter(Builder::parentImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(ContainerRecipeSummary::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ContainerRecipeSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONTAINER_TYPE_FIELD, NAME_FIELD, PLATFORM_FIELD, OWNER_FIELD, PARENT_IMAGE_FIELD, DATE_CREATED_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String containerType;

    private final String name;

    private final String platform;

    private final String owner;

    private final String parentImage;

    private final String dateCreated;

    private final Map<String, String> tags;

    private ContainerRecipeSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.containerType = builder.containerType;
        this.name = builder.name;
        this.platform = builder.platform;
        this.owner = builder.owner;
        this.parentImage = builder.parentImage;
        this.dateCreated = builder.dateCreated;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container recipe.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the type of container, such as "Docker".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of container, such as "Docker".
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * Specifies the type of container, such as "Docker".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of container, such as "Docker".
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * The name of the container recipe.
     * </p>
     * 
     * @return The name of the container recipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The system platform for the container, such as Windows or Linux.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The system platform for the container, such as Windows or Linux.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The system platform for the container, such as Windows or Linux.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The system platform for the container, such as Windows or Linux.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The owner of the container recipe.
     * </p>
     * 
     * @return The owner of the container recipe.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The source image for the container recipe.
     * </p>
     * 
     * @return The source image for the container recipe.
     */
    public final String parentImage() {
        return parentImage;
    }

    /**
     * <p>
     * The date when this container recipe was created.
     * </p>
     * 
     * @return The date when this container recipe was created.
     */
    public final String dateCreated() {
        return dateCreated;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags that are attached to the container recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags that are attached to the container recipe.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRecipeSummary)) {
            return false;
        }
        ContainerRecipeSummary other = (ContainerRecipeSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(containerTypeAsString(), other.containerTypeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(owner(), other.owner()) && Objects.equals(parentImage(), other.parentImage())
                && Objects.equals(dateCreated(), other.dateCreated()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerRecipeSummary").add("Arn", arn()).add("ContainerType", containerTypeAsString())
                .add("Name", name()).add("Platform", platformAsString()).add("Owner", owner()).add("ParentImage", parentImage())
                .add("DateCreated", dateCreated()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "containerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "parentImage":
            return Optional.ofNullable(clazz.cast(parentImage()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerRecipeSummary, T> g) {
        return obj -> g.apply((ContainerRecipeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerRecipeSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container recipe.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the type of container, such as "Docker".
         * </p>
         * 
         * @param containerType
         *        Specifies the type of container, such as "Docker".
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * Specifies the type of container, such as "Docker".
         * </p>
         * 
         * @param containerType
         *        Specifies the type of container, such as "Docker".
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * The name of the container recipe.
         * </p>
         * 
         * @param name
         *        The name of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The system platform for the container, such as Windows or Linux.
         * </p>
         * 
         * @param platform
         *        The system platform for the container, such as Windows or Linux.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The system platform for the container, such as Windows or Linux.
         * </p>
         * 
         * @param platform
         *        The system platform for the container, such as Windows or Linux.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The owner of the container recipe.
         * </p>
         * 
         * @param owner
         *        The owner of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The source image for the container recipe.
         * </p>
         * 
         * @param parentImage
         *        The source image for the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentImage(String parentImage);

        /**
         * <p>
         * The date when this container recipe was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when this container recipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * Tags that are attached to the container recipe.
         * </p>
         * 
         * @param tags
         *        Tags that are attached to the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String containerType;

        private String name;

        private String platform;

        private String owner;

        private String parentImage;

        private String dateCreated;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRecipeSummary model) {
            arn(model.arn);
            containerType(model.containerType);
            name(model.name);
            platform(model.platform);
            owner(model.owner);
            parentImage(model.parentImage);
            dateCreated(model.dateCreated);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getContainerType() {
            return containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getParentImage() {
            return parentImage;
        }

        @Override
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public ContainerRecipeSummary build() {
            return new ContainerRecipeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
