/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an EC2 launch template to use for a specific account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateConfiguration.Builder, LaunchTemplateConfiguration> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchTemplateId").getter(getter(LaunchTemplateConfiguration::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(LaunchTemplateConfiguration::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Boolean> SET_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("setDefaultVersion").getter(getter(LaunchTemplateConfiguration::setDefaultVersion))
            .setter(setter(Builder::setDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setDefaultVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            ACCOUNT_ID_FIELD, SET_DEFAULT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String accountId;

    private final Boolean setDefaultVersion;

    private LaunchTemplateConfiguration(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.accountId = builder.accountId;
        this.setDefaultVersion = builder.setDefaultVersion;
    }

    /**
     * <p>
     * Identifies the EC2 launch template to use.
     * </p>
     * 
     * @return Identifies the EC2 launch template to use.
     */
    public final String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The account ID that this configuration applies to.
     * </p>
     * 
     * @return The account ID that this configuration applies to.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Set the specified EC2 launch template as the default launch template for the specified account.
     * </p>
     * 
     * @return Set the specified EC2 launch template as the default launch template for the specified account.
     */
    public final Boolean setDefaultVersion() {
        return setDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(setDefaultVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateConfiguration)) {
            return false;
        }
        LaunchTemplateConfiguration other = (LaunchTemplateConfiguration) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(setDefaultVersion(), other.setDefaultVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateConfiguration").add("LaunchTemplateId", launchTemplateId())
                .add("AccountId", accountId()).add("SetDefaultVersion", setDefaultVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "setDefaultVersion":
            return Optional.ofNullable(clazz.cast(setDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateConfiguration, T> g) {
        return obj -> g.apply((LaunchTemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateConfiguration> {
        /**
         * <p>
         * Identifies the EC2 launch template to use.
         * </p>
         * 
         * @param launchTemplateId
         *        Identifies the EC2 launch template to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The account ID that this configuration applies to.
         * </p>
         * 
         * @param accountId
         *        The account ID that this configuration applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Set the specified EC2 launch template as the default launch template for the specified account.
         * </p>
         * 
         * @param setDefaultVersion
         *        Set the specified EC2 launch template as the default launch template for the specified account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setDefaultVersion(Boolean setDefaultVersion);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String accountId;

        private Boolean setDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateConfiguration model) {
            launchTemplateId(model.launchTemplateId);
            accountId(model.accountId);
            setDefaultVersion(model.setDefaultVersion);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Boolean getSetDefaultVersion() {
            return setDefaultVersion;
        }

        @Override
        public final Builder setDefaultVersion(Boolean setDefaultVersion) {
            this.setDefaultVersion = setDefaultVersion;
            return this;
        }

        public final void setSetDefaultVersion(Boolean setDefaultVersion) {
            this.setDefaultVersion = setDefaultVersion;
        }

        @Override
        public LaunchTemplateConfiguration build() {
            return new LaunchTemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
