/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the settings for a specific Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Distribution implements SdkPojo, Serializable, ToCopyableBuilder<Distribution.Builder, Distribution> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Distribution::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<AmiDistributionConfiguration> AMI_DISTRIBUTION_CONFIGURATION_FIELD = SdkField
            .<AmiDistributionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("amiDistributionConfiguration")
            .getter(getter(Distribution::amiDistributionConfiguration))
            .setter(setter(Builder::amiDistributionConfiguration))
            .constructor(AmiDistributionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiDistributionConfiguration")
                    .build()).build();

    private static final SdkField<ContainerDistributionConfiguration> CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD = SdkField
            .<ContainerDistributionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("containerDistributionConfiguration")
            .getter(getter(Distribution::containerDistributionConfiguration))
            .setter(setter(Builder::containerDistributionConfiguration))
            .constructor(ContainerDistributionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDistributionConfiguration")
                    .build()).build();

    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("licenseConfigurationArns")
            .getter(getter(Distribution::licenseConfigurationArns))
            .setter(setter(Builder::licenseConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LaunchTemplateConfiguration>> LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD = SdkField
            .<List<LaunchTemplateConfiguration>> builder(MarshallingType.LIST)
            .memberName("launchTemplateConfigurations")
            .getter(getter(Distribution::launchTemplateConfigurations))
            .setter(setter(Builder::launchTemplateConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            AMI_DISTRIBUTION_CONFIGURATION_FIELD, CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD, LICENSE_CONFIGURATION_ARNS_FIELD,
            LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final AmiDistributionConfiguration amiDistributionConfiguration;

    private final ContainerDistributionConfiguration containerDistributionConfiguration;

    private final List<String> licenseConfigurationArns;

    private final List<LaunchTemplateConfiguration> launchTemplateConfigurations;

    private Distribution(BuilderImpl builder) {
        this.region = builder.region;
        this.amiDistributionConfiguration = builder.amiDistributionConfiguration;
        this.containerDistributionConfiguration = builder.containerDistributionConfiguration;
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
        this.launchTemplateConfigurations = builder.launchTemplateConfigurations;
    }

    /**
     * <p>
     * The target Region.
     * </p>
     * 
     * @return The target Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The specific AMI settings; for example, launch permissions or AMI tags.
     * </p>
     * 
     * @return The specific AMI settings; for example, launch permissions or AMI tags.
     */
    public final AmiDistributionConfiguration amiDistributionConfiguration() {
        return amiDistributionConfiguration;
    }

    /**
     * <p>
     * Container distribution settings for encryption, licensing, and sharing in a specific Region.
     * </p>
     * 
     * @return Container distribution settings for encryption, licensing, and sharing in a specific Region.
     */
    public final ContainerDistributionConfiguration containerDistributionConfiguration() {
        return containerDistributionConfiguration;
    }

    /**
     * Returns true if the LicenseConfigurationArns property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLicenseConfigurationArns() {
        return licenseConfigurationArns != null && !(licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The License Manager Configuration to associate with the AMI in the specified Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseConfigurationArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The License Manager Configuration to associate with the AMI in the specified Region.
     */
    public final List<String> licenseConfigurationArns() {
        return licenseConfigurationArns;
    }

    /**
     * Returns true if the LaunchTemplateConfigurations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasLaunchTemplateConfigurations() {
        return launchTemplateConfigurations != null && !(launchTemplateConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchTemplateConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
     */
    public final List<LaunchTemplateConfiguration> launchTemplateConfigurations() {
        return launchTemplateConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(amiDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(containerDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseConfigurationArns() ? licenseConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplateConfigurations() ? launchTemplateConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution) obj;
        return Objects.equals(region(), other.region())
                && Objects.equals(amiDistributionConfiguration(), other.amiDistributionConfiguration())
                && Objects.equals(containerDistributionConfiguration(), other.containerDistributionConfiguration())
                && hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns()
                && Objects.equals(licenseConfigurationArns(), other.licenseConfigurationArns())
                && hasLaunchTemplateConfigurations() == other.hasLaunchTemplateConfigurations()
                && Objects.equals(launchTemplateConfigurations(), other.launchTemplateConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Distribution").add("Region", region())
                .add("AmiDistributionConfiguration", amiDistributionConfiguration())
                .add("ContainerDistributionConfiguration", containerDistributionConfiguration())
                .add("LicenseConfigurationArns", hasLicenseConfigurationArns() ? licenseConfigurationArns() : null)
                .add("LaunchTemplateConfigurations", hasLaunchTemplateConfigurations() ? launchTemplateConfigurations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "amiDistributionConfiguration":
            return Optional.ofNullable(clazz.cast(amiDistributionConfiguration()));
        case "containerDistributionConfiguration":
            return Optional.ofNullable(clazz.cast(containerDistributionConfiguration()));
        case "licenseConfigurationArns":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArns()));
        case "launchTemplateConfigurations":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Distribution, T> g) {
        return obj -> g.apply((Distribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Distribution> {
        /**
         * <p>
         * The target Region.
         * </p>
         * 
         * @param region
         *        The target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The specific AMI settings; for example, launch permissions or AMI tags.
         * </p>
         * 
         * @param amiDistributionConfiguration
         *        The specific AMI settings; for example, launch permissions or AMI tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiDistributionConfiguration(AmiDistributionConfiguration amiDistributionConfiguration);

        /**
         * <p>
         * The specific AMI settings; for example, launch permissions or AMI tags.
         * </p>
         * This is a convenience that creates an instance of the {@link AmiDistributionConfiguration.Builder} avoiding
         * the need to create one manually via {@link AmiDistributionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AmiDistributionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #amiDistributionConfiguration(AmiDistributionConfiguration)}.
         * 
         * @param amiDistributionConfiguration
         *        a consumer that will call methods on {@link AmiDistributionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiDistributionConfiguration(AmiDistributionConfiguration)
         */
        default Builder amiDistributionConfiguration(Consumer<AmiDistributionConfiguration.Builder> amiDistributionConfiguration) {
            return amiDistributionConfiguration(AmiDistributionConfiguration.builder()
                    .applyMutation(amiDistributionConfiguration).build());
        }

        /**
         * <p>
         * Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * </p>
         * 
         * @param containerDistributionConfiguration
         *        Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDistributionConfiguration(ContainerDistributionConfiguration containerDistributionConfiguration);

        /**
         * <p>
         * Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerDistributionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ContainerDistributionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerDistributionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #containerDistributionConfiguration(ContainerDistributionConfiguration)}.
         * 
         * @param containerDistributionConfiguration
         *        a consumer that will call methods on {@link ContainerDistributionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerDistributionConfiguration(ContainerDistributionConfiguration)
         */
        default Builder containerDistributionConfiguration(
                Consumer<ContainerDistributionConfiguration.Builder> containerDistributionConfiguration) {
            return containerDistributionConfiguration(ContainerDistributionConfiguration.builder()
                    .applyMutation(containerDistributionConfiguration).build());
        }

        /**
         * <p>
         * The License Manager Configuration to associate with the AMI in the specified Region.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        The License Manager Configuration to associate with the AMI in the specified Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns);

        /**
         * <p>
         * The License Manager Configuration to associate with the AMI in the specified Region.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        The License Manager Configuration to associate with the AMI in the specified Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(String... licenseConfigurationArns);

        /**
         * <p>
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         * </p>
         * 
         * @param launchTemplateConfigurations
         *        A group of launchTemplateConfiguration settings that apply to image distribution for specified
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigurations(Collection<LaunchTemplateConfiguration> launchTemplateConfigurations);

        /**
         * <p>
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         * </p>
         * 
         * @param launchTemplateConfigurations
         *        A group of launchTemplateConfiguration settings that apply to image distribution for specified
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigurations(LaunchTemplateConfiguration... launchTemplateConfigurations);

        /**
         * <p>
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplateConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<LaunchTemplateConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #launchTemplateConfigurations(List<LaunchTemplateConfiguration>)}.
         * 
         * @param launchTemplateConfigurations
         *        a consumer that will call methods on {@link List<LaunchTemplateConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigurations(List<LaunchTemplateConfiguration>)
         */
        Builder launchTemplateConfigurations(Consumer<LaunchTemplateConfiguration.Builder>... launchTemplateConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private AmiDistributionConfiguration amiDistributionConfiguration;

        private ContainerDistributionConfiguration containerDistributionConfiguration;

        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateConfiguration> launchTemplateConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Distribution model) {
            region(model.region);
            amiDistributionConfiguration(model.amiDistributionConfiguration);
            containerDistributionConfiguration(model.containerDistributionConfiguration);
            licenseConfigurationArns(model.licenseConfigurationArns);
            launchTemplateConfigurations(model.launchTemplateConfigurations);
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final AmiDistributionConfiguration.Builder getAmiDistributionConfiguration() {
            return amiDistributionConfiguration != null ? amiDistributionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder amiDistributionConfiguration(AmiDistributionConfiguration amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration;
            return this;
        }

        public final void setAmiDistributionConfiguration(AmiDistributionConfiguration.BuilderImpl amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration != null ? amiDistributionConfiguration.build()
                    : null;
        }

        public final ContainerDistributionConfiguration.Builder getContainerDistributionConfiguration() {
            return containerDistributionConfiguration != null ? containerDistributionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder containerDistributionConfiguration(
                ContainerDistributionConfiguration containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration;
            return this;
        }

        public final void setContainerDistributionConfiguration(
                ContainerDistributionConfiguration.BuilderImpl containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration != null ? containerDistributionConfiguration
                    .build() : null;
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseConfigurationArns;
        }

        @Override
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationArns(String... licenseConfigurationArns) {
            licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
        }

        public final List<LaunchTemplateConfiguration.Builder> getLaunchTemplateConfigurations() {
            List<LaunchTemplateConfiguration.Builder> result = LaunchTemplateConfigurationListCopier
                    .copyToBuilder(this.launchTemplateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder launchTemplateConfigurations(Collection<LaunchTemplateConfiguration> launchTemplateConfigurations) {
            this.launchTemplateConfigurations = LaunchTemplateConfigurationListCopier.copy(launchTemplateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigurations(LaunchTemplateConfiguration... launchTemplateConfigurations) {
            launchTemplateConfigurations(Arrays.asList(launchTemplateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigurations(
                Consumer<LaunchTemplateConfiguration.Builder>... launchTemplateConfigurations) {
            launchTemplateConfigurations(Stream.of(launchTemplateConfigurations)
                    .map(c -> LaunchTemplateConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigurations(
                Collection<LaunchTemplateConfiguration.BuilderImpl> launchTemplateConfigurations) {
            this.launchTemplateConfigurations = LaunchTemplateConfigurationListCopier
                    .copyFromBuilder(launchTemplateConfigurations);
        }

        @Override
        public Distribution build() {
            return new Distribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
