/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImagePipelinesResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListImagePipelinesResponse.Builder, ListImagePipelinesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(ListImagePipelinesResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<ImagePipeline>> IMAGE_PIPELINE_LIST_FIELD = SdkField
            .<List<ImagePipeline>> builder(MarshallingType.LIST)
            .memberName("imagePipelineList")
            .getter(getter(ListImagePipelinesResponse::imagePipelineList))
            .setter(setter(Builder::imagePipelineList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImagePipeline> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImagePipeline::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImagePipelinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            IMAGE_PIPELINE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String requestIdValue;

    private final List<ImagePipeline> imagePipelineList;

    private final String nextToken;

    private ListImagePipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imagePipelineList = builder.imagePipelineList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * Returns true if the ImagePipelineList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasImagePipelineList() {
        return imagePipelineList != null && !(imagePipelineList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of image pipelines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImagePipelineList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of image pipelines.
     */
    public final List<ImagePipeline> imagePipelineList() {
        return imagePipelineList;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this is not empty, there are additional elements that the
     * service has not included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this is not empty, there are additional elements that
     *         the service has not included in this request. Use this token with the next request to retrieve additional
     *         objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImagePipelineList() ? imagePipelineList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagePipelinesResponse)) {
            return false;
        }
        ListImagePipelinesResponse other = (ListImagePipelinesResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && hasImagePipelineList() == other.hasImagePipelineList()
                && Objects.equals(imagePipelineList(), other.imagePipelineList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImagePipelinesResponse").add("RequestId", requestId())
                .add("ImagePipelineList", hasImagePipelineList() ? imagePipelineList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "imagePipelineList":
            return Optional.ofNullable(clazz.cast(imagePipelineList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagePipelinesResponse, T> g) {
        return obj -> g.apply((ListImagePipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImagePipelinesResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The list of image pipelines.
         * </p>
         * 
         * @param imagePipelineList
         *        The list of image pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineList(Collection<ImagePipeline> imagePipelineList);

        /**
         * <p>
         * The list of image pipelines.
         * </p>
         * 
         * @param imagePipelineList
         *        The list of image pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineList(ImagePipeline... imagePipelineList);

        /**
         * <p>
         * The list of image pipelines.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImagePipeline>.Builder} avoiding the need
         * to create one manually via {@link List<ImagePipeline>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImagePipeline>.Builder#build()} is called immediately and
         * its result is passed to {@link #imagePipelineList(List<ImagePipeline>)}.
         * 
         * @param imagePipelineList
         *        a consumer that will call methods on {@link List<ImagePipeline>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePipelineList(List<ImagePipeline>)
         */
        Builder imagePipelineList(Consumer<ImagePipeline.Builder>... imagePipelineList);

        /**
         * <p>
         * The next token used for paginated responses. When this is not empty, there are additional elements that the
         * service has not included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this is not empty, there are additional elements
         *        that the service has not included in this request. Use this token with the next request to retrieve
         *        additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<ImagePipeline> imagePipelineList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagePipelinesResponse model) {
            super(model);
            requestId(model.requestIdValue);
            imagePipelineList(model.imagePipelineList);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<ImagePipeline.Builder> getImagePipelineList() {
            if (imagePipelineList instanceof SdkAutoConstructList) {
                return null;
            }
            return imagePipelineList != null ? imagePipelineList.stream().map(ImagePipeline::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imagePipelineList(Collection<ImagePipeline> imagePipelineList) {
            this.imagePipelineList = ImagePipelineListCopier.copy(imagePipelineList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePipelineList(ImagePipeline... imagePipelineList) {
            imagePipelineList(Arrays.asList(imagePipelineList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePipelineList(Consumer<ImagePipeline.Builder>... imagePipelineList) {
            imagePipelineList(Stream.of(imagePipelineList).map(c -> ImagePipeline.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImagePipelineList(Collection<ImagePipeline.BuilderImpl> imagePipelineList) {
            this.imagePipelineList = ImagePipelineListCopier.copyFromBuilder(imagePipelineList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImagePipelinesResponse build() {
            return new ListImagePipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
