/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInfrastructureConfigurationRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<UpdateInfrastructureConfigurationRequest.Builder, UpdateInfrastructureConfigurationRequest> {
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("infrastructureConfigurationArn")
            .getter(getter(UpdateInfrastructureConfigurationRequest::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateInfrastructureConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceTypes")
            .getter(getter(UpdateInfrastructureConfigurationRequest::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceProfileName").getter(getter(UpdateInfrastructureConfigurationRequest::instanceProfileName))
            .setter(setter(Builder::instanceProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileName").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(UpdateInfrastructureConfigurationRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subnetId").getter(getter(UpdateInfrastructureConfigurationRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .memberName("logging").getter(getter(UpdateInfrastructureConfigurationRequest::logging))
            .setter(setter(Builder::logging)).constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPair").getter(getter(UpdateInfrastructureConfigurationRequest::keyPair))
            .setter(setter(Builder::keyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCE_ON_FAILURE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("terminateInstanceOnFailure")
            .getter(getter(UpdateInfrastructureConfigurationRequest::terminateInstanceOnFailure))
            .setter(setter(Builder::terminateInstanceOnFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateInstanceOnFailure").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snsTopicArn").getter(getter(UpdateInfrastructureConfigurationRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateInfrastructureConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resourceTags")
            .getter(getter(UpdateInfrastructureConfigurationRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, DESCRIPTION_FIELD, INSTANCE_TYPES_FIELD, INSTANCE_PROFILE_NAME_FIELD,
            SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, LOGGING_FIELD, KEY_PAIR_FIELD, TERMINATE_INSTANCE_ON_FAILURE_FIELD,
            SNS_TOPIC_ARN_FIELD, CLIENT_TOKEN_FIELD, RESOURCE_TAGS_FIELD));

    private final String infrastructureConfigurationArn;

    private final String description;

    private final List<String> instanceTypes;

    private final String instanceProfileName;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final Logging logging;

    private final String keyPair;

    private final Boolean terminateInstanceOnFailure;

    private final String snsTopicArn;

    private final String clientToken;

    private final Map<String, String> resourceTags;

    private UpdateInfrastructureConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.description = builder.description;
        this.instanceTypes = builder.instanceTypes;
        this.instanceProfileName = builder.instanceProfileName;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.logging = builder.logging;
        this.keyPair = builder.keyPair;
        this.terminateInstanceOnFailure = builder.terminateInstanceOnFailure;
        this.snsTopicArn = builder.snsTopicArn;
        this.clientToken = builder.clientToken;
        this.resourceTags = builder.resourceTags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The description of the infrastructure configuration.
     * </p>
     * 
     * @return The description of the infrastructure configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the InstanceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types of the infrastructure configuration. You can specify one or more instance types to use for
     * this build. The service will pick one of these instance types based on availability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance types of the infrastructure configuration. You can specify one or more instance types to use
     *         for this build. The service will pick one of these instance types based on availability.
     */
    public final List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * <p>
     * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
     * </p>
     * 
     * @return The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
     */
    public final String instanceProfileName() {
        return instanceProfileName;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
     * </p>
     * 
     * @return The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The logging configuration of the infrastructure configuration.
     * </p>
     * 
     * @return The logging configuration of the infrastructure configuration.
     */
    public final Logging logging() {
        return logging;
    }

    /**
     * <p>
     * The key pair of the infrastructure configuration. This can be used to log on to and debug the instance used to
     * create your image.
     * </p>
     * 
     * @return The key pair of the infrastructure configuration. This can be used to log on to and debug the instance
     *         used to create your image.
     */
    public final String keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image
     * Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
     * </p>
     * 
     * @return The terminate instance on failure setting of the infrastructure configuration. Set to false if you want
     *         Image Builder to retain the instance used to configure your AMI if the build or test phase of your
     *         workflow fails.
     */
    public final Boolean terminateInstanceOnFailure() {
        return terminateInstanceOnFailure;
    }

    /**
     * <p>
     * The SNS topic on which to send image build events.
     * </p>
     * 
     * @return The SNS topic on which to send image build events.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The idempotency token used to make this request idempotent.
     * </p>
     * 
     * @return The idempotency token used to make this request idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the ResourceTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags attached to the resource created by Image Builder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags attached to the resource created by Image Builder.
     */
    public final Map<String, String> resourceTags() {
        return resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstanceOnFailure());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInfrastructureConfigurationRequest)) {
            return false;
        }
        UpdateInfrastructureConfigurationRequest other = (UpdateInfrastructureConfigurationRequest) obj;
        return Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(description(), other.description()) && hasInstanceTypes() == other.hasInstanceTypes()
                && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(instanceProfileName(), other.instanceProfileName())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(logging(), other.logging()) && Objects.equals(keyPair(), other.keyPair())
                && Objects.equals(terminateInstanceOnFailure(), other.terminateInstanceOnFailure())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(clientToken(), other.clientToken())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInfrastructureConfigurationRequest")
                .add("InfrastructureConfigurationArn", infrastructureConfigurationArn()).add("Description", description())
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null)
                .add("InstanceProfileName", instanceProfileName())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("SubnetId", subnetId())
                .add("Logging", logging()).add("KeyPair", keyPair())
                .add("TerminateInstanceOnFailure", terminateInstanceOnFailure()).add("SnsTopicArn", snsTopicArn())
                .add("ClientToken", clientToken()).add("ResourceTags", hasResourceTags() ? resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "infrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "instanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "instanceProfileName":
            return Optional.ofNullable(clazz.cast(instanceProfileName()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "terminateInstanceOnFailure":
            return Optional.ofNullable(clazz.cast(terminateInstanceOnFailure()));
        case "snsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "resourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInfrastructureConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateInfrastructureConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInfrastructureConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The description of the infrastructure configuration.
         * </p>
         * 
         * @param description
         *        The description of the infrastructure configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The instance types of the infrastructure configuration. You can specify one or more instance types to use for
         * this build. The service will pick one of these instance types based on availability.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types of the infrastructure configuration. You can specify one or more instance types to
         *        use for this build. The service will pick one of these instance types based on availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * The instance types of the infrastructure configuration. You can specify one or more instance types to use for
         * this build. The service will pick one of these instance types based on availability.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types of the infrastructure configuration. You can specify one or more instance types to
         *        use for this build. The service will pick one of these instance types based on availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         * </p>
         * 
         * @param instanceProfileName
         *        The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileName(String instanceProfileName);

        /**
         * <p>
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The logging configuration of the infrastructure configuration.
         * </p>
         * 
         * @param logging
         *        The logging configuration of the infrastructure configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * The logging configuration of the infrastructure configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link Logging.Builder} avoiding the need to create one
         * manually via {@link Logging#builder()}.
         *
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * The key pair of the infrastructure configuration. This can be used to log on to and debug the instance used
         * to create your image.
         * </p>
         * 
         * @param keyPair
         *        The key pair of the infrastructure configuration. This can be used to log on to and debug the instance
         *        used to create your image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(String keyPair);

        /**
         * <p>
         * The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image
         * Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
         * </p>
         * 
         * @param terminateInstanceOnFailure
         *        The terminate instance on failure setting of the infrastructure configuration. Set to false if you
         *        want Image Builder to retain the instance used to configure your AMI if the build or test phase of
         *        your workflow fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure);

        /**
         * <p>
         * The SNS topic on which to send image build events.
         * </p>
         * 
         * @param snsTopicArn
         *        The SNS topic on which to send image build events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The idempotency token used to make this request idempotent.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token used to make this request idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags attached to the resource created by Image Builder.
         * </p>
         * 
         * @param resourceTags
         *        The tags attached to the resource created by Image Builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Map<String, String> resourceTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String infrastructureConfigurationArn;

        private String description;

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String instanceProfileName;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private Logging logging;

        private String keyPair;

        private Boolean terminateInstanceOnFailure;

        private String snsTopicArn;

        private String clientToken;

        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInfrastructureConfigurationRequest model) {
            super(model);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            description(model.description);
            instanceTypes(model.instanceTypes);
            instanceProfileName(model.instanceProfileName);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            logging(model.logging);
            keyPair(model.keyPair);
            terminateInstanceOnFailure(model.terminateInstanceOnFailure);
            snsTopicArn(model.snsTopicArn);
            clientToken(model.clientToken);
            resourceTags(model.resourceTags);
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getInstanceTypes() {
            if (instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        public final String getInstanceProfileName() {
            return instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final String getKeyPair() {
            return keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final Boolean getTerminateInstanceOnFailure() {
            return terminateInstanceOnFailure;
        }

        @Override
        public final Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
            return this;
        }

        public final void setTerminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, String> getResourceTags() {
            if (resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTags;
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = ResourceTagMapCopier.copy(resourceTags);
            return this;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = ResourceTagMapCopier.copy(resourceTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInfrastructureConfigurationRequest build() {
            return new UpdateInfrastructureConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
