/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerRecipeRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateContainerRecipeRequest.Builder, CreateContainerRecipeRequest> {
    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerType").getter(getter(CreateContainerRecipeRequest::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateContainerRecipeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateContainerRecipeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(CreateContainerRecipeRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField
            .<List<ComponentConfiguration>> builder(MarshallingType.LIST)
            .memberName("components")
            .getter(getter(CreateContainerRecipeRequest::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField
            .<InstanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("instanceConfiguration")
            .getter(getter(CreateContainerRecipeRequest::instanceConfiguration)).setter(setter(Builder::instanceConfiguration))
            .constructor(InstanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfiguration").build())
            .build();

    private static final SdkField<String> DOCKERFILE_TEMPLATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dockerfileTemplateData").getter(getter(CreateContainerRecipeRequest::dockerfileTemplateData))
            .setter(setter(Builder::dockerfileTemplateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerfileTemplateData").build())
            .build();

    private static final SdkField<String> DOCKERFILE_TEMPLATE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dockerfileTemplateUri").getter(getter(CreateContainerRecipeRequest::dockerfileTemplateUri))
            .setter(setter(Builder::dockerfileTemplateUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerfileTemplateUri").build())
            .build();

    private static final SdkField<String> PLATFORM_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformOverride").getter(getter(CreateContainerRecipeRequest::platformOverrideAsString))
            .setter(setter(Builder::platformOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformOverride").build()).build();

    private static final SdkField<String> IMAGE_OS_VERSION_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageOsVersionOverride").getter(getter(CreateContainerRecipeRequest::imageOsVersionOverride))
            .setter(setter(Builder::imageOsVersionOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageOsVersionOverride").build())
            .build();

    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentImage").getter(getter(CreateContainerRecipeRequest::parentImage))
            .setter(setter(Builder::parentImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateContainerRecipeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workingDirectory").getter(getter(CreateContainerRecipeRequest::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()).build();

    private static final SdkField<TargetContainerRepository> TARGET_REPOSITORY_FIELD = SdkField
            .<TargetContainerRepository> builder(MarshallingType.SDK_POJO).memberName("targetRepository")
            .getter(getter(CreateContainerRecipeRequest::targetRepository)).setter(setter(Builder::targetRepository))
            .constructor(TargetContainerRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRepository").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateContainerRecipeRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateContainerRecipeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_TYPE_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, SEMANTIC_VERSION_FIELD, COMPONENTS_FIELD, INSTANCE_CONFIGURATION_FIELD,
            DOCKERFILE_TEMPLATE_DATA_FIELD, DOCKERFILE_TEMPLATE_URI_FIELD, PLATFORM_OVERRIDE_FIELD,
            IMAGE_OS_VERSION_OVERRIDE_FIELD, PARENT_IMAGE_FIELD, TAGS_FIELD, WORKING_DIRECTORY_FIELD, TARGET_REPOSITORY_FIELD,
            KMS_KEY_ID_FIELD, CLIENT_TOKEN_FIELD));

    private final String containerType;

    private final String name;

    private final String description;

    private final String semanticVersion;

    private final List<ComponentConfiguration> components;

    private final InstanceConfiguration instanceConfiguration;

    private final String dockerfileTemplateData;

    private final String dockerfileTemplateUri;

    private final String platformOverride;

    private final String imageOsVersionOverride;

    private final String parentImage;

    private final Map<String, String> tags;

    private final String workingDirectory;

    private final TargetContainerRepository targetRepository;

    private final String kmsKeyId;

    private final String clientToken;

    private CreateContainerRecipeRequest(BuilderImpl builder) {
        super(builder);
        this.containerType = builder.containerType;
        this.name = builder.name;
        this.description = builder.description;
        this.semanticVersion = builder.semanticVersion;
        this.components = builder.components;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.dockerfileTemplateData = builder.dockerfileTemplateData;
        this.dockerfileTemplateUri = builder.dockerfileTemplateUri;
        this.platformOverride = builder.platformOverride;
        this.imageOsVersionOverride = builder.imageOsVersionOverride;
        this.parentImage = builder.parentImage;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
        this.targetRepository = builder.targetRepository;
        this.kmsKeyId = builder.kmsKeyId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The type of container to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container to create.
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * The type of container to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container to create.
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * The name of the container recipe.
     * </p>
     * 
     * @return The name of the container recipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the container recipe.
     * </p>
     * 
     * @return The description of the container recipe.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The semantic version of the container recipe. This version follows the semantic version syntax.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an
     * upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number, and
     * that is not open for updates.
     * </p>
     * <p>
     * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that
     * you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as
     * 2021.01.01.
     * </p>
     * </note>
     * 
     * @return The semantic version of the container recipe. This version follows the semantic version syntax.</p>
     *         <note>
     *         <p>
     *         The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
     *         assign values for the first three, and can filter on all of them.
     *         </p>
     *         <p>
     *         <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero,
     *         with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build
     *         number, and that is not open for updates.
     *         </p>
     *         <p>
     *         <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
     *         nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a
     *         date, such as 2021.01.01.
     *         </p>
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * Returns true if the Components property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Components for build and test that are included in the container recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Components for build and test that are included in the container recipe.
     */
    public final List<ComponentConfiguration> components() {
        return components;
    }

    /**
     * <p>
     * A group of options that can be used to configure an instance for building and testing container images.
     * </p>
     * 
     * @return A group of options that can be used to configure an instance for building and testing container images.
     */
    public final InstanceConfiguration instanceConfiguration() {
        return instanceConfiguration;
    }

    /**
     * <p>
     * The Dockerfile template used to build your image as an inline data blob.
     * </p>
     * 
     * @return The Dockerfile template used to build your image as an inline data blob.
     */
    public final String dockerfileTemplateData() {
        return dockerfileTemplateData;
    }

    /**
     * <p>
     * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
     * </p>
     * 
     * @return The Amazon S3 URI for the Dockerfile that will be used to build your container image.
     */
    public final String dockerfileTemplateUri() {
        return dockerfileTemplateUri;
    }

    /**
     * <p>
     * Specifies the operating system platform when you use a custom source image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformOverride}
     * will return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformOverrideAsString}.
     * </p>
     * 
     * @return Specifies the operating system platform when you use a custom source image.
     * @see Platform
     */
    public final Platform platformOverride() {
        return Platform.fromValue(platformOverride);
    }

    /**
     * <p>
     * Specifies the operating system platform when you use a custom source image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformOverride}
     * will return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformOverrideAsString}.
     * </p>
     * 
     * @return Specifies the operating system platform when you use a custom source image.
     * @see Platform
     */
    public final String platformOverrideAsString() {
        return platformOverride;
    }

    /**
     * <p>
     * Specifies the operating system version for the source image.
     * </p>
     * 
     * @return Specifies the operating system version for the source image.
     */
    public final String imageOsVersionOverride() {
        return imageOsVersionOverride;
    }

    /**
     * <p>
     * The source image for the container recipe.
     * </p>
     * 
     * @return The source image for the container recipe.
     */
    public final String parentImage() {
        return parentImage;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags that are attached to the container recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags that are attached to the container recipe.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The working directory for use during build and test workflows.
     * </p>
     * 
     * @return The working directory for use during build and test workflows.
     */
    public final String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * The destination repository for the container image.
     * </p>
     * 
     * @return The destination repository for the container image.
     */
    public final TargetContainerRepository targetRepository() {
        return targetRepository;
    }

    /**
     * <p>
     * Identifies which KMS key is used to encrypt the container image.
     * </p>
     * 
     * @return Identifies which KMS key is used to encrypt the container image.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The client token used to make this request idempotent.
     * </p>
     * 
     * @return The client token used to make this request idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dockerfileTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(dockerfileTemplateUri());
        hashCode = 31 * hashCode + Objects.hashCode(platformOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageOsVersionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(targetRepository());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerRecipeRequest)) {
            return false;
        }
        CreateContainerRecipeRequest other = (CreateContainerRecipeRequest) obj;
        return Objects.equals(containerTypeAsString(), other.containerTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(semanticVersion(), other.semanticVersion()) && hasComponents() == other.hasComponents()
                && Objects.equals(components(), other.components())
                && Objects.equals(instanceConfiguration(), other.instanceConfiguration())
                && Objects.equals(dockerfileTemplateData(), other.dockerfileTemplateData())
                && Objects.equals(dockerfileTemplateUri(), other.dockerfileTemplateUri())
                && Objects.equals(platformOverrideAsString(), other.platformOverrideAsString())
                && Objects.equals(imageOsVersionOverride(), other.imageOsVersionOverride())
                && Objects.equals(parentImage(), other.parentImage()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(workingDirectory(), other.workingDirectory())
                && Objects.equals(targetRepository(), other.targetRepository()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerRecipeRequest").add("ContainerType", containerTypeAsString()).add("Name", name())
                .add("Description", description()).add("SemanticVersion", semanticVersion())
                .add("Components", hasComponents() ? components() : null).add("InstanceConfiguration", instanceConfiguration())
                .add("DockerfileTemplateData", dockerfileTemplateData()).add("DockerfileTemplateUri", dockerfileTemplateUri())
                .add("PlatformOverride", platformOverrideAsString()).add("ImageOsVersionOverride", imageOsVersionOverride())
                .add("ParentImage", parentImage()).add("Tags", hasTags() ? tags() : null)
                .add("WorkingDirectory", workingDirectory()).add("TargetRepository", targetRepository())
                .add("KmsKeyId", kmsKeyId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "instanceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceConfiguration()));
        case "dockerfileTemplateData":
            return Optional.ofNullable(clazz.cast(dockerfileTemplateData()));
        case "dockerfileTemplateUri":
            return Optional.ofNullable(clazz.cast(dockerfileTemplateUri()));
        case "platformOverride":
            return Optional.ofNullable(clazz.cast(platformOverrideAsString()));
        case "imageOsVersionOverride":
            return Optional.ofNullable(clazz.cast(imageOsVersionOverride()));
        case "parentImage":
            return Optional.ofNullable(clazz.cast(parentImage()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "targetRepository":
            return Optional.ofNullable(clazz.cast(targetRepository()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerRecipeRequest, T> g) {
        return obj -> g.apply((CreateContainerRecipeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContainerRecipeRequest> {
        /**
         * <p>
         * The type of container to create.
         * </p>
         * 
         * @param containerType
         *        The type of container to create.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * The type of container to create.
         * </p>
         * 
         * @param containerType
         *        The type of container to create.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * The name of the container recipe.
         * </p>
         * 
         * @param name
         *        The name of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the container recipe.
         * </p>
         * 
         * @param description
         *        The description of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The semantic version of the container recipe. This version follows the semantic version syntax.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with
         * an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number,
         * and that is not open for updates.
         * </p>
         * <p>
         * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes
         * that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such
         * as 2021.01.01.
         * </p>
         * </note>
         * 
         * @param semanticVersion
         *        The semantic version of the container recipe. This version follows the semantic version syntax.</p>
         *        <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
         *        zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns
         *        the build number, and that is not open for updates.
         *        </p>
         *        <p>
         *        <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
         *        nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         *        a date, such as 2021.01.01.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * Components for build and test that are included in the container recipe.
         * </p>
         * 
         * @param components
         *        Components for build and test that are included in the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ComponentConfiguration> components);

        /**
         * <p>
         * Components for build and test that are included in the container recipe.
         * </p>
         * 
         * @param components
         *        Components for build and test that are included in the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ComponentConfiguration... components);

        /**
         * <p>
         * Components for build and test that are included in the container recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<ComponentConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<ComponentConfiguration>)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link List<ComponentConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(List<ComponentConfiguration>)
         */
        Builder components(Consumer<ComponentConfiguration.Builder>... components);

        /**
         * <p>
         * A group of options that can be used to configure an instance for building and testing container images.
         * </p>
         * 
         * @param instanceConfiguration
         *        A group of options that can be used to configure an instance for building and testing container
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfiguration(InstanceConfiguration instanceConfiguration);

        /**
         * <p>
         * A group of options that can be used to configure an instance for building and testing container images.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceConfiguration.Builder} avoiding the need
         * to create one manually via {@link InstanceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConfiguration(InstanceConfiguration)}.
         * 
         * @param instanceConfiguration
         *        a consumer that will call methods on {@link InstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfiguration(InstanceConfiguration)
         */
        default Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return instanceConfiguration(InstanceConfiguration.builder().applyMutation(instanceConfiguration).build());
        }

        /**
         * <p>
         * The Dockerfile template used to build your image as an inline data blob.
         * </p>
         * 
         * @param dockerfileTemplateData
         *        The Dockerfile template used to build your image as an inline data blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerfileTemplateData(String dockerfileTemplateData);

        /**
         * <p>
         * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
         * </p>
         * 
         * @param dockerfileTemplateUri
         *        The Amazon S3 URI for the Dockerfile that will be used to build your container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerfileTemplateUri(String dockerfileTemplateUri);

        /**
         * <p>
         * Specifies the operating system platform when you use a custom source image.
         * </p>
         * 
         * @param platformOverride
         *        Specifies the operating system platform when you use a custom source image.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platformOverride(String platformOverride);

        /**
         * <p>
         * Specifies the operating system platform when you use a custom source image.
         * </p>
         * 
         * @param platformOverride
         *        Specifies the operating system platform when you use a custom source image.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platformOverride(Platform platformOverride);

        /**
         * <p>
         * Specifies the operating system version for the source image.
         * </p>
         * 
         * @param imageOsVersionOverride
         *        Specifies the operating system version for the source image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOsVersionOverride(String imageOsVersionOverride);

        /**
         * <p>
         * The source image for the container recipe.
         * </p>
         * 
         * @param parentImage
         *        The source image for the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentImage(String parentImage);

        /**
         * <p>
         * Tags that are attached to the container recipe.
         * </p>
         * 
         * @param tags
         *        Tags that are attached to the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The working directory for use during build and test workflows.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory for use during build and test workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * The destination repository for the container image.
         * </p>
         * 
         * @param targetRepository
         *        The destination repository for the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRepository(TargetContainerRepository targetRepository);

        /**
         * <p>
         * The destination repository for the container image.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetContainerRepository.Builder} avoiding the
         * need to create one manually via {@link TargetContainerRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetContainerRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #targetRepository(TargetContainerRepository)}.
         * 
         * @param targetRepository
         *        a consumer that will call methods on {@link TargetContainerRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRepository(TargetContainerRepository)
         */
        default Builder targetRepository(Consumer<TargetContainerRepository.Builder> targetRepository) {
            return targetRepository(TargetContainerRepository.builder().applyMutation(targetRepository).build());
        }

        /**
         * <p>
         * Identifies which KMS key is used to encrypt the container image.
         * </p>
         * 
         * @param kmsKeyId
         *        Identifies which KMS key is used to encrypt the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The client token used to make this request idempotent.
         * </p>
         * 
         * @param clientToken
         *        The client token used to make this request idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String containerType;

        private String name;

        private String description;

        private String semanticVersion;

        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();

        private InstanceConfiguration instanceConfiguration;

        private String dockerfileTemplateData;

        private String dockerfileTemplateUri;

        private String platformOverride;

        private String imageOsVersionOverride;

        private String parentImage;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workingDirectory;

        private TargetContainerRepository targetRepository;

        private String kmsKeyId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerRecipeRequest model) {
            super(model);
            containerType(model.containerType);
            name(model.name);
            description(model.description);
            semanticVersion(model.semanticVersion);
            components(model.components);
            instanceConfiguration(model.instanceConfiguration);
            dockerfileTemplateData(model.dockerfileTemplateData);
            dockerfileTemplateUri(model.dockerfileTemplateUri);
            platformOverride(model.platformOverride);
            imageOsVersionOverride(model.imageOsVersionOverride);
            parentImage(model.parentImage);
            tags(model.tags);
            workingDirectory(model.workingDirectory);
            targetRepository(model.targetRepository);
            kmsKeyId(model.kmsKeyId);
            clientToken(model.clientToken);
        }

        public final String getContainerType() {
            return containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        @Transient
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        @Transient
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        @Transient
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final List<ComponentConfiguration.Builder> getComponents() {
            List<ComponentConfiguration.Builder> result = ComponentConfigurationListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        @Override
        @Transient
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(ComponentConfiguration... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder>... components) {
            components(Stream.of(components).map(c -> ComponentConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return instanceConfiguration != null ? instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final String getDockerfileTemplateData() {
            return dockerfileTemplateData;
        }

        public final void setDockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
        }

        @Override
        @Transient
        public final Builder dockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
            return this;
        }

        public final String getDockerfileTemplateUri() {
            return dockerfileTemplateUri;
        }

        public final void setDockerfileTemplateUri(String dockerfileTemplateUri) {
            this.dockerfileTemplateUri = dockerfileTemplateUri;
        }

        @Override
        @Transient
        public final Builder dockerfileTemplateUri(String dockerfileTemplateUri) {
            this.dockerfileTemplateUri = dockerfileTemplateUri;
            return this;
        }

        public final String getPlatformOverride() {
            return platformOverride;
        }

        public final void setPlatformOverride(String platformOverride) {
            this.platformOverride = platformOverride;
        }

        @Override
        @Transient
        public final Builder platformOverride(String platformOverride) {
            this.platformOverride = platformOverride;
            return this;
        }

        @Override
        @Transient
        public final Builder platformOverride(Platform platformOverride) {
            this.platformOverride(platformOverride == null ? null : platformOverride.toString());
            return this;
        }

        public final String getImageOsVersionOverride() {
            return imageOsVersionOverride;
        }

        public final void setImageOsVersionOverride(String imageOsVersionOverride) {
            this.imageOsVersionOverride = imageOsVersionOverride;
        }

        @Override
        @Transient
        public final Builder imageOsVersionOverride(String imageOsVersionOverride) {
            this.imageOsVersionOverride = imageOsVersionOverride;
            return this;
        }

        public final String getParentImage() {
            return parentImage;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        @Override
        @Transient
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        @Transient
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final TargetContainerRepository.Builder getTargetRepository() {
            return targetRepository != null ? targetRepository.toBuilder() : null;
        }

        public final void setTargetRepository(TargetContainerRepository.BuilderImpl targetRepository) {
            this.targetRepository = targetRepository != null ? targetRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder targetRepository(TargetContainerRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerRecipeRequest build() {
            return new CreateContainerRecipeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
