/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container recipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerRecipe implements SdkPojo, Serializable, ToCopyableBuilder<ContainerRecipe.Builder, ContainerRecipe> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ContainerRecipe::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerType").getter(getter(ContainerRecipe::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContainerRecipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ContainerRecipe::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ContainerRecipe::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ContainerRecipe::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ContainerRecipe::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField
            .<List<ComponentConfiguration>> builder(MarshallingType.LIST)
            .memberName("components")
            .getter(getter(ContainerRecipe::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField
            .<InstanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("instanceConfiguration")
            .getter(getter(ContainerRecipe::instanceConfiguration)).setter(setter(Builder::instanceConfiguration))
            .constructor(InstanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfiguration").build())
            .build();

    private static final SdkField<String> DOCKERFILE_TEMPLATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dockerfileTemplateData").getter(getter(ContainerRecipe::dockerfileTemplateData))
            .setter(setter(Builder::dockerfileTemplateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerfileTemplateData").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ContainerRecipe::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("encrypted").getter(getter(ContainerRecipe::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()).build();

    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentImage").getter(getter(ContainerRecipe::parentImage)).setter(setter(Builder::parentImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(ContainerRecipe::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ContainerRecipe::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workingDirectory").getter(getter(ContainerRecipe::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()).build();

    private static final SdkField<TargetContainerRepository> TARGET_REPOSITORY_FIELD = SdkField
            .<TargetContainerRepository> builder(MarshallingType.SDK_POJO).memberName("targetRepository")
            .getter(getter(ContainerRecipe::targetRepository)).setter(setter(Builder::targetRepository))
            .constructor(TargetContainerRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRepository").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONTAINER_TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, OWNER_FIELD, VERSION_FIELD, COMPONENTS_FIELD,
            INSTANCE_CONFIGURATION_FIELD, DOCKERFILE_TEMPLATE_DATA_FIELD, KMS_KEY_ID_FIELD, ENCRYPTED_FIELD, PARENT_IMAGE_FIELD,
            DATE_CREATED_FIELD, TAGS_FIELD, WORKING_DIRECTORY_FIELD, TARGET_REPOSITORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String containerType;

    private final String name;

    private final String description;

    private final String platform;

    private final String owner;

    private final String version;

    private final List<ComponentConfiguration> components;

    private final InstanceConfiguration instanceConfiguration;

    private final String dockerfileTemplateData;

    private final String kmsKeyId;

    private final Boolean encrypted;

    private final String parentImage;

    private final String dateCreated;

    private final Map<String, String> tags;

    private final String workingDirectory;

    private final TargetContainerRepository targetRepository;

    private ContainerRecipe(BuilderImpl builder) {
        this.arn = builder.arn;
        this.containerType = builder.containerType;
        this.name = builder.name;
        this.description = builder.description;
        this.platform = builder.platform;
        this.owner = builder.owner;
        this.version = builder.version;
        this.components = builder.components;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.dockerfileTemplateData = builder.dockerfileTemplateData;
        this.kmsKeyId = builder.kmsKeyId;
        this.encrypted = builder.encrypted;
        this.parentImage = builder.parentImage;
        this.dateCreated = builder.dateCreated;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
        this.targetRepository = builder.targetRepository;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container recipe.
     * </p>
     * <note>
     * <p>
     * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that
     * object as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off
     * entirely, or they are specified as wildcards, for example: x.x.x.
     * </p>
     * </li>
     * <li>
     * <p>
     * Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
     * </p>
     * </li>
     * <li>
     * <p>
     * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     * </p>
     * </li>
     * </ol>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the container recipe.</p> <note>
     *         <p>
     *         Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to
     *         that object as follows:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either
     *         left off entirely, or they are specified as wildcards, for example: x.x.x.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Build version ARNs have all four nodes, and point to a specific build for a specific version of an
     *         object.
     *         </p>
     *         </li>
     *         </ol>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the type of container, such as Docker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of container, such as Docker.
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * Specifies the type of container, such as Docker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of container, such as Docker.
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * The name of the container recipe.
     * </p>
     * 
     * @return The name of the container recipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the container recipe.
     * </p>
     * 
     * @return The description of the container recipe.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The system platform for the container, such as Windows or Linux.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The system platform for the container, such as Windows or Linux.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The system platform for the container, such as Windows or Linux.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The system platform for the container, such as Windows or Linux.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The owner of the container recipe.
     * </p>
     * 
     * @return The owner of the container recipe.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The semantic version of the container recipe.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an
     * upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number, and
     * that is not open for updates.
     * </p>
     * <p>
     * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that
     * you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as
     * 2021.01.01.
     * </p>
     * <p>
     * <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use wildcards (x) to
     * filter your results. When you use a wildcard in any node, all nodes to the right of the first wildcard must also
     * be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list results, but neither "1.x.2", nor
     * "x.2.x" will work. You do not have to specify the build - Image Builder automatically uses a wildcard for that,
     * if applicable.
     * </p>
     * </note>
     * 
     * @return The semantic version of the container recipe.</p> <note>
     *         <p>
     *         The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
     *         assign values for the first three, and can filter on all of them.
     *         </p>
     *         <p>
     *         <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero,
     *         with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build
     *         number, and that is not open for updates.
     *         </p>
     *         <p>
     *         <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
     *         nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a
     *         date, such as 2021.01.01.
     *         </p>
     *         <p>
     *         <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use
     *         wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     *         first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     *         results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     *         automatically uses a wildcard for that, if applicable.
     *         </p>
     */
    public final String version() {
        return version;
    }

    /**
     * Returns true if the Components property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Components for build and test that are included in the container recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Components for build and test that are included in the container recipe.
     */
    public final List<ComponentConfiguration> components() {
        return components;
    }

    /**
     * <p>
     * A group of options that can be used to configure an instance for building and testing container images.
     * </p>
     * 
     * @return A group of options that can be used to configure an instance for building and testing container images.
     */
    public final InstanceConfiguration instanceConfiguration() {
        return instanceConfiguration;
    }

    /**
     * <p>
     * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the
     * elements required by the application running inside. The template data consists of contextual variables where
     * Image Builder places build information or scripts, based on your container image recipe.
     * </p>
     * 
     * @return Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all
     *         of the elements required by the application running inside. The template data consists of contextual
     *         variables where Image Builder places build information or scripts, based on your container image recipe.
     */
    public final String dockerfileTemplateData() {
        return dockerfileTemplateData;
    }

    /**
     * <p>
     * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     * </p>
     * 
     * @return Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A flag that indicates if the target container is encrypted.
     * </p>
     * 
     * @return A flag that indicates if the target container is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The source image for the container recipe.
     * </p>
     * 
     * @return The source image for the container recipe.
     */
    public final String parentImage() {
        return parentImage;
    }

    /**
     * <p>
     * The date when this container recipe was created.
     * </p>
     * 
     * @return The date when this container recipe was created.
     */
    public final String dateCreated() {
        return dateCreated;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags that are attached to the container recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags that are attached to the container recipe.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The working directory for use during build and test workflows.
     * </p>
     * 
     * @return The working directory for use during build and test workflows.
     */
    public final String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * The destination repository for the container image.
     * </p>
     * 
     * @return The destination repository for the container image.
     */
    public final TargetContainerRepository targetRepository() {
        return targetRepository;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dockerfileTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(targetRepository());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRecipe)) {
            return false;
        }
        ContainerRecipe other = (ContainerRecipe) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(containerTypeAsString(), other.containerTypeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(owner(), other.owner())
                && Objects.equals(version(), other.version()) && hasComponents() == other.hasComponents()
                && Objects.equals(components(), other.components())
                && Objects.equals(instanceConfiguration(), other.instanceConfiguration())
                && Objects.equals(dockerfileTemplateData(), other.dockerfileTemplateData())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(parentImage(), other.parentImage()) && Objects.equals(dateCreated(), other.dateCreated())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(workingDirectory(), other.workingDirectory())
                && Objects.equals(targetRepository(), other.targetRepository());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerRecipe").add("Arn", arn()).add("ContainerType", containerTypeAsString())
                .add("Name", name()).add("Description", description()).add("Platform", platformAsString()).add("Owner", owner())
                .add("Version", version()).add("Components", hasComponents() ? components() : null)
                .add("InstanceConfiguration", instanceConfiguration()).add("DockerfileTemplateData", dockerfileTemplateData())
                .add("KmsKeyId", kmsKeyId()).add("Encrypted", encrypted()).add("ParentImage", parentImage())
                .add("DateCreated", dateCreated()).add("Tags", hasTags() ? tags() : null)
                .add("WorkingDirectory", workingDirectory()).add("TargetRepository", targetRepository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "containerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "instanceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceConfiguration()));
        case "dockerfileTemplateData":
            return Optional.ofNullable(clazz.cast(dockerfileTemplateData()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "parentImage":
            return Optional.ofNullable(clazz.cast(parentImage()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "targetRepository":
            return Optional.ofNullable(clazz.cast(targetRepository()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerRecipe, T> g) {
        return obj -> g.apply((ContainerRecipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerRecipe> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container recipe.
         * </p>
         * <note>
         * <p>
         * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to
         * that object as follows:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left
         * off entirely, or they are specified as wildcards, for example: x.x.x.
         * </p>
         * </li>
         * <li>
         * <p>
         * Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
         * </p>
         * </li>
         * <li>
         * <p>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </p>
         * </li>
         * </ol>
         * </note>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the container recipe.</p> <note>
         *        <p>
         *        Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies
         *        to that object as follows:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         *        either left off entirely, or they are specified as wildcards, for example: x.x.x.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Build version ARNs have all four nodes, and point to a specific build for a specific version of an
         *        object.
         *        </p>
         *        </li>
         *        </ol>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the type of container, such as Docker.
         * </p>
         * 
         * @param containerType
         *        Specifies the type of container, such as Docker.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * Specifies the type of container, such as Docker.
         * </p>
         * 
         * @param containerType
         *        Specifies the type of container, such as Docker.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * The name of the container recipe.
         * </p>
         * 
         * @param name
         *        The name of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the container recipe.
         * </p>
         * 
         * @param description
         *        The description of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The system platform for the container, such as Windows or Linux.
         * </p>
         * 
         * @param platform
         *        The system platform for the container, such as Windows or Linux.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The system platform for the container, such as Windows or Linux.
         * </p>
         * 
         * @param platform
         *        The system platform for the container, such as Windows or Linux.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The owner of the container recipe.
         * </p>
         * 
         * @param owner
         *        The owner of the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The semantic version of the container recipe.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with
         * an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number,
         * and that is not open for updates.
         * </p>
         * <p>
         * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes
         * that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such
         * as 2021.01.01.
         * </p>
         * <p>
         * <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use wildcards
         * (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the first wildcard
         * must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list results, but neither
         * "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder automatically uses a
         * wildcard for that, if applicable.
         * </p>
         * </note>
         * 
         * @param version
         *        The semantic version of the container recipe.</p> <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
         *        zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns
         *        the build number, and that is not open for updates.
         *        </p>
         *        <p>
         *        <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
         *        nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         *        a date, such as 2021.01.01.
         *        </p>
         *        <p>
         *        <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use
         *        wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of
         *        the first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter
         *        list results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image
         *        Builder automatically uses a wildcard for that, if applicable.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Components for build and test that are included in the container recipe.
         * </p>
         * 
         * @param components
         *        Components for build and test that are included in the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ComponentConfiguration> components);

        /**
         * <p>
         * Components for build and test that are included in the container recipe.
         * </p>
         * 
         * @param components
         *        Components for build and test that are included in the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ComponentConfiguration... components);

        /**
         * <p>
         * Components for build and test that are included in the container recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<ComponentConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<ComponentConfiguration>)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link List<ComponentConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(List<ComponentConfiguration>)
         */
        Builder components(Consumer<ComponentConfiguration.Builder>... components);

        /**
         * <p>
         * A group of options that can be used to configure an instance for building and testing container images.
         * </p>
         * 
         * @param instanceConfiguration
         *        A group of options that can be used to configure an instance for building and testing container
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfiguration(InstanceConfiguration instanceConfiguration);

        /**
         * <p>
         * A group of options that can be used to configure an instance for building and testing container images.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceConfiguration.Builder} avoiding the need
         * to create one manually via {@link InstanceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConfiguration(InstanceConfiguration)}.
         * 
         * @param instanceConfiguration
         *        a consumer that will call methods on {@link InstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfiguration(InstanceConfiguration)
         */
        default Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return instanceConfiguration(InstanceConfiguration.builder().applyMutation(instanceConfiguration).build());
        }

        /**
         * <p>
         * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of
         * the elements required by the application running inside. The template data consists of contextual variables
         * where Image Builder places build information or scripts, based on your container image recipe.
         * </p>
         * 
         * @param dockerfileTemplateData
         *        Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain
         *        all of the elements required by the application running inside. The template data consists of
         *        contextual variables where Image Builder places build information or scripts, based on your container
         *        image recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerfileTemplateData(String dockerfileTemplateData);

        /**
         * <p>
         * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         * </p>
         * 
         * @param kmsKeyId
         *        Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A flag that indicates if the target container is encrypted.
         * </p>
         * 
         * @param encrypted
         *        A flag that indicates if the target container is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The source image for the container recipe.
         * </p>
         * 
         * @param parentImage
         *        The source image for the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentImage(String parentImage);

        /**
         * <p>
         * The date when this container recipe was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when this container recipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * Tags that are attached to the container recipe.
         * </p>
         * 
         * @param tags
         *        Tags that are attached to the container recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The working directory for use during build and test workflows.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory for use during build and test workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * The destination repository for the container image.
         * </p>
         * 
         * @param targetRepository
         *        The destination repository for the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRepository(TargetContainerRepository targetRepository);

        /**
         * <p>
         * The destination repository for the container image.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetContainerRepository.Builder} avoiding the
         * need to create one manually via {@link TargetContainerRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetContainerRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #targetRepository(TargetContainerRepository)}.
         * 
         * @param targetRepository
         *        a consumer that will call methods on {@link TargetContainerRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRepository(TargetContainerRepository)
         */
        default Builder targetRepository(Consumer<TargetContainerRepository.Builder> targetRepository) {
            return targetRepository(TargetContainerRepository.builder().applyMutation(targetRepository).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String containerType;

        private String name;

        private String description;

        private String platform;

        private String owner;

        private String version;

        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();

        private InstanceConfiguration instanceConfiguration;

        private String dockerfileTemplateData;

        private String kmsKeyId;

        private Boolean encrypted;

        private String parentImage;

        private String dateCreated;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workingDirectory;

        private TargetContainerRepository targetRepository;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRecipe model) {
            arn(model.arn);
            containerType(model.containerType);
            name(model.name);
            description(model.description);
            platform(model.platform);
            owner(model.owner);
            version(model.version);
            components(model.components);
            instanceConfiguration(model.instanceConfiguration);
            dockerfileTemplateData(model.dockerfileTemplateData);
            kmsKeyId(model.kmsKeyId);
            encrypted(model.encrypted);
            parentImage(model.parentImage);
            dateCreated(model.dateCreated);
            tags(model.tags);
            workingDirectory(model.workingDirectory);
            targetRepository(model.targetRepository);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getContainerType() {
            return containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        @Transient
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        @Transient
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<ComponentConfiguration.Builder> getComponents() {
            List<ComponentConfiguration.Builder> result = ComponentConfigurationListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        @Override
        @Transient
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(ComponentConfiguration... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder>... components) {
            components(Stream.of(components).map(c -> ComponentConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return instanceConfiguration != null ? instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final String getDockerfileTemplateData() {
            return dockerfileTemplateData;
        }

        public final void setDockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
        }

        @Override
        @Transient
        public final Builder dockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getParentImage() {
            return parentImage;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        @Override
        @Transient
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        @Transient
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final TargetContainerRepository.Builder getTargetRepository() {
            return targetRepository != null ? targetRepository.toBuilder() : null;
        }

        public final void setTargetRepository(TargetContainerRepository.BuilderImpl targetRepository) {
            this.targetRepository = targetRepository != null ? targetRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder targetRepository(TargetContainerRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        @Override
        public ContainerRecipe build() {
            return new ContainerRecipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
