/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An image summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSummary implements SdkPojo, Serializable, ToCopyableBuilder<ImageSummary.Builder, ImageSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ImageSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImageSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ImageSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ImageSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ImageSummary::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osVersion").getter(getter(ImageSummary::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()).build();

    private static final SdkField<ImageState> STATE_FIELD = SdkField.<ImageState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(ImageSummary::state)).setter(setter(Builder::state))
            .constructor(ImageState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ImageSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(ImageSummary::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<OutputResources> OUTPUT_RESOURCES_FIELD = SdkField
            .<OutputResources> builder(MarshallingType.SDK_POJO).memberName("outputResources")
            .getter(getter(ImageSummary::outputResources)).setter(setter(Builder::outputResources))
            .constructor(OutputResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputResources").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ImageSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, VERSION_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, STATE_FIELD, OWNER_FIELD, DATE_CREATED_FIELD,
            OUTPUT_RESOURCES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final String version;

    private final String platform;

    private final String osVersion;

    private final ImageState state;

    private final String owner;

    private final String dateCreated;

    private final OutputResources outputResources;

    private final Map<String, String> tags;

    private ImageSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.state = builder.state;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
        this.outputResources = builder.outputResources;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the image.
     * </p>
     * 
     * @return The name of the image.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this is an AMI or container image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether this is an AMI or container image.
     * @see ImageType
     */
    public final ImageType type() {
        return ImageType.fromValue(type);
    }

    /**
     * <p>
     * Specifies whether this is an AMI or container image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether this is an AMI or container image.
     * @see ImageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The version of the image.
     * </p>
     * 
     * @return The version of the image.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The platform of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server
     * 2019.
     * </p>
     * 
     * @return The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft
     *         Windows Server 2019.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * <p>
     * The state of the image.
     * </p>
     * 
     * @return The state of the image.
     */
    public final ImageState state() {
        return state;
    }

    /**
     * <p>
     * The owner of the image.
     * </p>
     * 
     * @return The owner of the image.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The date on which this image was created.
     * </p>
     * 
     * @return The date on which this image was created.
     */
    public final String dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The output resources produced when creating this image.
     * </p>
     * 
     * @return The output resources produced when creating this image.
     */
    public final OutputResources outputResources() {
        return outputResources;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the image.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(outputResources());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSummary)) {
            return false;
        }
        ImageSummary other = (ImageSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(version(), other.version())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(osVersion(), other.osVersion())
                && Objects.equals(state(), other.state()) && Objects.equals(owner(), other.owner())
                && Objects.equals(dateCreated(), other.dateCreated())
                && Objects.equals(outputResources(), other.outputResources()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSummary").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Version", version()).add("Platform", platformAsString()).add("OsVersion", osVersion())
                .add("State", state()).add("Owner", owner()).add("DateCreated", dateCreated())
                .add("OutputResources", outputResources()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "osVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "outputResources":
            return Optional.ofNullable(clazz.cast(outputResources()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageSummary, T> g) {
        return obj -> g.apply((ImageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the image.
         * </p>
         * 
         * @param name
         *        The name of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this is an AMI or container image.
         * </p>
         * 
         * @param type
         *        Specifies whether this is an AMI or container image.
         * @see ImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies whether this is an AMI or container image.
         * </p>
         * 
         * @param type
         *        Specifies whether this is an AMI or container image.
         * @see ImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageType
         */
        Builder type(ImageType type);

        /**
         * <p>
         * The version of the image.
         * </p>
         * 
         * @param version
         *        The version of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The platform of the image.
         * </p>
         * 
         * @param platform
         *        The platform of the image.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the image.
         * </p>
         * 
         * @param platform
         *        The platform of the image.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows
         * Server 2019.
         * </p>
         * 
         * @param osVersion
         *        The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft
         *        Windows Server 2019.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The state of the image.
         * </p>
         * 
         * @param state
         *        The state of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ImageState state);

        /**
         * <p>
         * The state of the image.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageState.Builder} avoiding the need to create
         * one manually via {@link ImageState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageState.Builder#build()} is called immediately and its result
         * is passed to {@link #state(ImageState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ImageState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ImageState)
         */
        default Builder state(Consumer<ImageState.Builder> state) {
            return state(ImageState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The owner of the image.
         * </p>
         * 
         * @param owner
         *        The owner of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The date on which this image was created.
         * </p>
         * 
         * @param dateCreated
         *        The date on which this image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * The output resources produced when creating this image.
         * </p>
         * 
         * @param outputResources
         *        The output resources produced when creating this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputResources(OutputResources outputResources);

        /**
         * <p>
         * The output resources produced when creating this image.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputResources.Builder} avoiding the need to
         * create one manually via {@link OutputResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputResources.Builder#build()} is called immediately and its
         * result is passed to {@link #outputResources(OutputResources)}.
         * 
         * @param outputResources
         *        a consumer that will call methods on {@link OutputResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputResources(OutputResources)
         */
        default Builder outputResources(Consumer<OutputResources.Builder> outputResources) {
            return outputResources(OutputResources.builder().applyMutation(outputResources).build());
        }

        /**
         * <p>
         * The tags of the image.
         * </p>
         * 
         * @param tags
         *        The tags of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String version;

        private String platform;

        private String osVersion;

        private ImageState state;

        private String owner;

        private String dateCreated;

        private OutputResources outputResources;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSummary model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            version(model.version);
            platform(model.platform);
            osVersion(model.osVersion);
            state(model.state);
            owner(model.owner);
            dateCreated(model.dateCreated);
            outputResources(model.outputResources);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ImageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        @Transient
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final ImageState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        @Transient
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final OutputResources.Builder getOutputResources() {
            return outputResources != null ? outputResources.toBuilder() : null;
        }

        public final void setOutputResources(OutputResources.BuilderImpl outputResources) {
            this.outputResources = outputResources != null ? outputResources.build() : null;
        }

        @Override
        @Transient
        public final Builder outputResources(OutputResources outputResources) {
            this.outputResources = outputResources;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public ImageSummary build() {
            return new ImageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
