/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties that configure export from your build instance to a compatible file format for your VM.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ExportConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ExportConfiguration.Builder, S3ExportConfiguration> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(S3ExportConfiguration::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskImageFormat").getter(getter(S3ExportConfiguration::diskImageFormatAsString))
            .setter(setter(Builder::diskImageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskImageFormat").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(S3ExportConfiguration::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Prefix").getter(getter(S3ExportConfiguration::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD,
            DISK_IMAGE_FORMAT_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleName;

    private final String diskImageFormat;

    private final String s3Bucket;

    private final String s3Prefix;

    private S3ExportConfiguration(BuilderImpl builder) {
        this.roleName = builder.roleName;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
    }

    /**
     * <p>
     * The name of the role that grants VM Import/Export permission to export images to your S3 bucket.
     * </p>
     * 
     * @return The name of the role that grants VM Import/Export permission to export images to your S3 bucket.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * Export the updated image to one of the following supported disk image formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere versions
     * 4, 5, and 6.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – Raw format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return Export the updated image to one of the following supported disk image formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization
     *         products.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere
     *         versions 4, 5, and 6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Raw</b> – Raw format.
     *         </p>
     *         </li>
     * @see DiskImageFormat
     */
    public final DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(diskImageFormat);
    }

    /**
     * <p>
     * Export the updated image to one of the following supported disk image formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere versions
     * 4, 5, and 6.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – Raw format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return Export the updated image to one of the following supported disk image formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization
     *         products.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere
     *         versions 4, 5, and 6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Raw</b> – Raw format.
     *         </p>
     *         </li>
     * @see DiskImageFormat
     */
    public final String diskImageFormatAsString() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The S3 bucket in which to store the output disk images for your VM.
     * </p>
     * 
     * @return The S3 bucket in which to store the output disk images for your VM.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 path for the bucket where the output disk images for your VM are stored.
     * </p>
     * 
     * @return The Amazon S3 path for the bucket where the output disk images for your VM are stored.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportConfiguration)) {
            return false;
        }
        S3ExportConfiguration other = (S3ExportConfiguration) obj;
        return Objects.equals(roleName(), other.roleName())
                && Objects.equals(diskImageFormatAsString(), other.diskImageFormatAsString())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Prefix(), other.s3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ExportConfiguration").add("RoleName", roleName())
                .add("DiskImageFormat", diskImageFormatAsString()).add("S3Bucket", s3Bucket()).add("S3Prefix", s3Prefix())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "diskImageFormat":
            return Optional.ofNullable(clazz.cast(diskImageFormatAsString()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ExportConfiguration, T> g) {
        return obj -> g.apply((S3ExportConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ExportConfiguration> {
        /**
         * <p>
         * The name of the role that grants VM Import/Export permission to export images to your S3 bucket.
         * </p>
         * 
         * @param roleName
         *        The name of the role that grants VM Import/Export permission to export images to your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * Export the updated image to one of the following supported disk image formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere
         * versions 4, 5, and 6.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Raw</b> – Raw format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param diskImageFormat
         *        Export the updated image to one of the following supported disk image formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization
         *        products.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware
         *        vSphere versions 4, 5, and 6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Raw</b> – Raw format.
         *        </p>
         *        </li>
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * Export the updated image to one of the following supported disk image formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere
         * versions 4, 5, and 6.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Raw</b> – Raw format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param diskImageFormat
         *        Export the updated image to one of the following supported disk image formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization
         *        products.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware
         *        vSphere versions 4, 5, and 6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Raw</b> – Raw format.
         *        </p>
         *        </li>
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The S3 bucket in which to store the output disk images for your VM.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket in which to store the output disk images for your VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon S3 path for the bucket where the output disk images for your VM are stored.
         * </p>
         * 
         * @param s3Prefix
         *        The Amazon S3 path for the bucket where the output disk images for your VM are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String roleName;

        private String diskImageFormat;

        private String s3Bucket;

        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExportConfiguration model) {
            roleName(model.roleName);
            diskImageFormat(model.diskImageFormat);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getDiskImageFormat() {
            return diskImageFormat;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        @Override
        @Transient
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        @Transient
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        @Transient
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        @Override
        public S3ExportConfiguration build() {
            return new S3ExportConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
