/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container distribution settings for encryption, licensing, and sharing in a specific Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerDistributionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerDistributionConfiguration.Builder, ContainerDistributionConfiguration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ContainerDistributionConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> CONTAINER_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("containerTags")
            .getter(getter(ContainerDistributionConfiguration::containerTags))
            .setter(setter(Builder::containerTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TargetContainerRepository> TARGET_REPOSITORY_FIELD = SdkField
            .<TargetContainerRepository> builder(MarshallingType.SDK_POJO).memberName("targetRepository")
            .getter(getter(ContainerDistributionConfiguration::targetRepository)).setter(setter(Builder::targetRepository))
            .constructor(TargetContainerRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRepository").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            CONTAINER_TAGS_FIELD, TARGET_REPOSITORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<String> containerTags;

    private final TargetContainerRepository targetRepository;

    private ContainerDistributionConfiguration(BuilderImpl builder) {
        this.description = builder.description;
        this.containerTags = builder.containerTags;
        this.targetRepository = builder.targetRepository;
    }

    /**
     * <p>
     * The description of the container distribution configuration.
     * </p>
     * 
     * @return The description of the container distribution configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the ContainerTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasContainerTags() {
        return containerTags != null && !(containerTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags that are attached to the container distribution configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainerTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags that are attached to the container distribution configuration.
     */
    public final List<String> containerTags() {
        return containerTags;
    }

    /**
     * <p>
     * The destination repository for the container distribution configuration.
     * </p>
     * 
     * @return The destination repository for the container distribution configuration.
     */
    public final TargetContainerRepository targetRepository() {
        return targetRepository;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerTags() ? containerTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetRepository());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDistributionConfiguration)) {
            return false;
        }
        ContainerDistributionConfiguration other = (ContainerDistributionConfiguration) obj;
        return Objects.equals(description(), other.description()) && hasContainerTags() == other.hasContainerTags()
                && Objects.equals(containerTags(), other.containerTags())
                && Objects.equals(targetRepository(), other.targetRepository());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerDistributionConfiguration").add("Description", description())
                .add("ContainerTags", hasContainerTags() ? containerTags() : null).add("TargetRepository", targetRepository())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "containerTags":
            return Optional.ofNullable(clazz.cast(containerTags()));
        case "targetRepository":
            return Optional.ofNullable(clazz.cast(targetRepository()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDistributionConfiguration, T> g) {
        return obj -> g.apply((ContainerDistributionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerDistributionConfiguration> {
        /**
         * <p>
         * The description of the container distribution configuration.
         * </p>
         * 
         * @param description
         *        The description of the container distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags that are attached to the container distribution configuration.
         * </p>
         * 
         * @param containerTags
         *        Tags that are attached to the container distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerTags(Collection<String> containerTags);

        /**
         * <p>
         * Tags that are attached to the container distribution configuration.
         * </p>
         * 
         * @param containerTags
         *        Tags that are attached to the container distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerTags(String... containerTags);

        /**
         * <p>
         * The destination repository for the container distribution configuration.
         * </p>
         * 
         * @param targetRepository
         *        The destination repository for the container distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRepository(TargetContainerRepository targetRepository);

        /**
         * <p>
         * The destination repository for the container distribution configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetContainerRepository.Builder} avoiding the
         * need to create one manually via {@link TargetContainerRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetContainerRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #targetRepository(TargetContainerRepository)}.
         * 
         * @param targetRepository
         *        a consumer that will call methods on {@link TargetContainerRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRepository(TargetContainerRepository)
         */
        default Builder targetRepository(Consumer<TargetContainerRepository.Builder> targetRepository) {
            return targetRepository(TargetContainerRepository.builder().applyMutation(targetRepository).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<String> containerTags = DefaultSdkAutoConstructList.getInstance();

        private TargetContainerRepository targetRepository;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDistributionConfiguration model) {
            description(model.description);
            containerTags(model.containerTags);
            targetRepository(model.targetRepository);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getContainerTags() {
            if (containerTags instanceof SdkAutoConstructList) {
                return null;
            }
            return containerTags;
        }

        public final void setContainerTags(Collection<String> containerTags) {
            this.containerTags = StringListCopier.copy(containerTags);
        }

        @Override
        @Transient
        public final Builder containerTags(Collection<String> containerTags) {
            this.containerTags = StringListCopier.copy(containerTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containerTags(String... containerTags) {
            containerTags(Arrays.asList(containerTags));
            return this;
        }

        public final TargetContainerRepository.Builder getTargetRepository() {
            return targetRepository != null ? targetRepository.toBuilder() : null;
        }

        public final void setTargetRepository(TargetContainerRepository.BuilderImpl targetRepository) {
            this.targetRepository = targetRepository != null ? targetRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder targetRepository(TargetContainerRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        @Override
        public ContainerDistributionConfiguration build() {
            return new ContainerDistributionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
