/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportComponentRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<ImportComponentRequest.Builder, ImportComponentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImportComponentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(ImportComponentRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ImportComponentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CHANGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeDescription").getter(getter(ImportComponentRequest::changeDescription))
            .setter(setter(Builder::changeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeDescription").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ImportComponentRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ImportComponentRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ImportComponentRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("data")
            .getter(getter(ImportComponentRequest::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(ImportComponentRequest::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ImportComponentRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ImportComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(ImportComponentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEMANTIC_VERSION_FIELD, DESCRIPTION_FIELD, CHANGE_DESCRIPTION_FIELD, TYPE_FIELD, FORMAT_FIELD, PLATFORM_FIELD,
            DATA_FIELD, URI_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String semanticVersion;

    private final String description;

    private final String changeDescription;

    private final String type;

    private final String format;

    private final String platform;

    private final String data;

    private final String uri;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final String clientToken;

    private ImportComponentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
        this.description = builder.description;
        this.changeDescription = builder.changeDescription;
        this.type = builder.type;
        this.format = builder.format;
        this.platform = builder.platform;
        this.data = builder.data;
        this.uri = builder.uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The semantic version of the component. This version follows the semantic version syntax.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use wildcards (x) to
     * filter your results. When you use a wildcard in any node, all nodes to the right of the first wildcard must also
     * be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list results, but neither "1.x.2", nor
     * "x.2.x" will work. You do not have to specify the build - Image Builder automatically uses a wildcard for that,
     * if applicable.
     * </p>
     * </note>
     * 
     * @return The semantic version of the component. This version follows the semantic version syntax.</p> <note>
     *         <p>
     *         The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
     *         assign values for the first three, and can filter on all of them.
     *         </p>
     *         <p>
     *         <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use
     *         wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     *         first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     *         results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     *         automatically uses a wildcard for that, if applicable.
     *         </p>
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * The description of the component. Describes the contents of the component.
     * </p>
     * 
     * @return The description of the component. Describes the contents of the component.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The change description of the component. Describes what change has been made in this version, or what makes this
     * version different from other versions of this component.
     * </p>
     * 
     * @return The change description of the component. Describes what change has been made in this version, or what
     *         makes this version different from other versions of this component.
     */
    public final String changeDescription() {
        return changeDescription;
    }

    /**
     * <p>
     * The type of the component denotes whether the component is used to build the image, or only to test it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the component denotes whether the component is used to build the image, or only to test it.
     * @see ComponentType
     */
    public final ComponentType type() {
        return ComponentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the component denotes whether the component is used to build the image, or only to test it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the component denotes whether the component is used to build the image, or only to test it.
     * @see ComponentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The format of the resource that you want to import as a component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ComponentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the resource that you want to import as a component.
     * @see ComponentFormat
     */
    public final ComponentFormat format() {
        return ComponentFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the resource that you want to import as a component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ComponentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the resource that you want to import as a component.
     * @see ComponentFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The platform of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the component.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the component.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be
     * used to specify the data within the component.
     * </p>
     * 
     * @return The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code>
     *         can be used to specify the data within the component.
     */
    public final String data() {
        return data;
    }

    /**
     * <p>
     * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3
     * bucket. If you use Amazon S3, you can specify component content up to your service quota. Either
     * <code>data</code> or <code>uri</code> can be used to specify the data within the component.
     * </p>
     * 
     * @return The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the
     *         Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota.
     *         Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The ID of the KMS key that should be used to encrypt this component.
     * </p>
     * 
     * @return The ID of the KMS key that should be used to encrypt this component.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the component.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The idempotency token of the component.
     * </p>
     * 
     * @return The idempotency token of the component.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(changeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportComponentRequest)) {
            return false;
        }
        ImportComponentRequest other = (ImportComponentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(changeDescription(), other.changeDescription())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(data(), other.data())
                && Objects.equals(uri(), other.uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportComponentRequest").add("Name", name()).add("SemanticVersion", semanticVersion())
                .add("Description", description()).add("ChangeDescription", changeDescription()).add("Type", typeAsString())
                .add("Format", formatAsString()).add("Platform", platformAsString()).add("Data", data()).add("Uri", uri())
                .add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "changeDescription":
            return Optional.ofNullable(clazz.cast(changeDescription()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportComponentRequest, T> g) {
        return obj -> g.apply((ImportComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportComponentRequest> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param name
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The semantic version of the component. This version follows the semantic version syntax.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use wildcards
         * (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the first wildcard
         * must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list results, but neither
         * "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder automatically uses a
         * wildcard for that, if applicable.
         * </p>
         * </note>
         * 
         * @param semanticVersion
         *        The semantic version of the component. This version follows the semantic version syntax.</p> <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Filtering:</b> When you retrieve or reference a resource with a semantic version, you can use
         *        wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of
         *        the first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter
         *        list results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image
         *        Builder automatically uses a wildcard for that, if applicable.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The description of the component. Describes the contents of the component.
         * </p>
         * 
         * @param description
         *        The description of the component. Describes the contents of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The change description of the component. Describes what change has been made in this version, or what makes
         * this version different from other versions of this component.
         * </p>
         * 
         * @param changeDescription
         *        The change description of the component. Describes what change has been made in this version, or what
         *        makes this version different from other versions of this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeDescription(String changeDescription);

        /**
         * <p>
         * The type of the component denotes whether the component is used to build the image, or only to test it.
         * </p>
         * 
         * @param type
         *        The type of the component denotes whether the component is used to build the image, or only to test
         *        it.
         * @see ComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the component denotes whether the component is used to build the image, or only to test it.
         * </p>
         * 
         * @param type
         *        The type of the component denotes whether the component is used to build the image, or only to test
         *        it.
         * @see ComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentType
         */
        Builder type(ComponentType type);

        /**
         * <p>
         * The format of the resource that you want to import as a component.
         * </p>
         * 
         * @param format
         *        The format of the resource that you want to import as a component.
         * @see ComponentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the resource that you want to import as a component.
         * </p>
         * 
         * @param format
         *        The format of the resource that you want to import as a component.
         * @see ComponentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentFormat
         */
        Builder format(ComponentFormat format);

        /**
         * <p>
         * The platform of the component.
         * </p>
         * 
         * @param platform
         *        The platform of the component.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the component.
         * </p>
         * 
         * @param platform
         *        The platform of the component.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can
         * be used to specify the data within the component.
         * </p>
         * 
         * @param data
         *        The data of the component. Used to specify the data inline. Either <code>data</code> or
         *        <code>uri</code> can be used to specify the data within the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the
         * Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either
         * <code>data</code> or <code>uri</code> can be used to specify the data within the component.
         * </p>
         * 
         * @param uri
         *        The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access
         *        the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
         *        quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the
         *        component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The ID of the KMS key that should be used to encrypt this component.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key that should be used to encrypt this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The tags of the component.
         * </p>
         * 
         * @param tags
         *        The tags of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The idempotency token of the component.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String semanticVersion;

        private String description;

        private String changeDescription;

        private String type;

        private String format;

        private String platform;

        private String data;

        private String uri;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportComponentRequest model) {
            super(model);
            name(model.name);
            semanticVersion(model.semanticVersion);
            description(model.description);
            changeDescription(model.changeDescription);
            type(model.type);
            format(model.format);
            platform(model.platform);
            data(model.data);
            uri(model.uri);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        @Transient
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChangeDescription() {
            return changeDescription;
        }

        public final void setChangeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
        }

        @Override
        @Transient
        public final Builder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(ComponentFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        @Transient
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        @Transient
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportComponentRequest build() {
            return new ImportComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
