/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resources produced by this image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputResources implements SdkPojo, Serializable, ToCopyableBuilder<OutputResources.Builder, OutputResources> {
    private static final SdkField<List<Ami>> AMIS_FIELD = SdkField
            .<List<Ami>> builder(MarshallingType.LIST)
            .memberName("amis")
            .getter(getter(OutputResources::amis))
            .setter(setter(Builder::amis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ami> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ami::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField
            .<List<Container>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(OutputResources::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Container> builder(MarshallingType.SDK_POJO)
                                            .constructor(Container::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD, CONTAINERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Ami> amis;

    private final List<Container> containers;

    private OutputResources(BuilderImpl builder) {
        this.amis = builder.amis;
        this.containers = builder.containers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAmis() {
        return amis != null && !(amis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 AMIs created by this image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmis} method.
     * </p>
     * 
     * @return The Amazon EC2 AMIs created by this image.
     */
    public final List<Ami> amis() {
        return amis;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Container images that the pipeline has generated and stored in the output repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return Container images that the pipeline has generated and stored in the output repository.
     */
    public final List<Container> containers() {
        return containers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAmis() ? amis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputResources)) {
            return false;
        }
        OutputResources other = (OutputResources) obj;
        return hasAmis() == other.hasAmis() && Objects.equals(amis(), other.amis()) && hasContainers() == other.hasContainers()
                && Objects.equals(containers(), other.containers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputResources").add("Amis", hasAmis() ? amis() : null)
                .add("Containers", hasContainers() ? containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amis":
            return Optional.ofNullable(clazz.cast(amis()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputResources, T> g) {
        return obj -> g.apply((OutputResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputResources> {
        /**
         * <p>
         * The Amazon EC2 AMIs created by this image.
         * </p>
         * 
         * @param amis
         *        The Amazon EC2 AMIs created by this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Collection<Ami> amis);

        /**
         * <p>
         * The Amazon EC2 AMIs created by this image.
         * </p>
         * 
         * @param amis
         *        The Amazon EC2 AMIs created by this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Ami... amis);

        /**
         * <p>
         * The Amazon EC2 AMIs created by this image.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Ami>.Builder} avoiding the need to
         * create one manually via {@link List<Ami>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ami>.Builder#build()} is called immediately and its result
         * is passed to {@link #amis(List<Ami>)}.
         * 
         * @param amis
         *        a consumer that will call methods on {@link List<Ami>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amis(List<Ami>)
         */
        Builder amis(Consumer<Ami.Builder>... amis);

        /**
         * <p>
         * Container images that the pipeline has generated and stored in the output repository.
         * </p>
         * 
         * @param containers
         *        Container images that the pipeline has generated and stored in the output repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<Container> containers);

        /**
         * <p>
         * Container images that the pipeline has generated and stored in the output repository.
         * </p>
         * 
         * @param containers
         *        Container images that the pipeline has generated and stored in the output repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Container... containers);

        /**
         * <p>
         * Container images that the pipeline has generated and stored in the output repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Container>.Builder} avoiding the
         * need to create one manually via {@link List<Container>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Container>.Builder#build()} is called immediately and its
         * result is passed to {@link #containers(List<Container>)}.
         * 
         * @param containers
         *        a consumer that will call methods on {@link List<Container>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(List<Container>)
         */
        Builder containers(Consumer<Container.Builder>... containers);
    }

    static final class BuilderImpl implements Builder {
        private List<Ami> amis = DefaultSdkAutoConstructList.getInstance();

        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputResources model) {
            amis(model.amis);
            containers(model.containers);
        }

        public final List<Ami.Builder> getAmis() {
            List<Ami.Builder> result = AmiListCopier.copyToBuilder(this.amis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmis(Collection<Ami.BuilderImpl> amis) {
            this.amis = AmiListCopier.copyFromBuilder(amis);
        }

        @Override
        public final Builder amis(Collection<Ami> amis) {
            this.amis = AmiListCopier.copy(amis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Ami... amis) {
            amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Consumer<Ami.Builder>... amis) {
            amis(Stream.of(amis).map(c -> Ami.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainerListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainerListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainerListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder>... containers) {
            containers(Stream.of(containers).map(c -> Container.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OutputResources build() {
            return new OutputResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
