/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details of the component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentConfiguration.Builder, ComponentConfiguration> {
    private static final SdkField<String> COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentArn").getter(getter(ComponentConfiguration::componentArn))
            .setter(setter(Builder::componentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentArn").build()).build();

    private static final SdkField<List<ComponentParameter>> PARAMETERS_FIELD = SdkField
            .<List<ComponentParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(ComponentConfiguration::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ARN_FIELD,
            PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentArn;

    private final List<ComponentParameter> parameters;

    private ComponentConfiguration(BuilderImpl builder) {
        this.componentArn = builder.componentArn;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component.
     */
    public final String componentArn() {
        return componentArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A group of parameter settings that are used to configure the component for a specific recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A group of parameter settings that are used to configure the component for a specific recipe.
     */
    public final List<ComponentParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        ComponentConfiguration other = (ComponentConfiguration) obj;
        return Objects.equals(componentArn(), other.componentArn()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentConfiguration").add("ComponentArn", componentArn())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentArn":
            return Optional.ofNullable(clazz.cast(componentArn()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentConfiguration, T> g) {
        return obj -> g.apply((ComponentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component.
         * </p>
         * 
         * @param componentArn
         *        The Amazon Resource Name (ARN) of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentArn(String componentArn);

        /**
         * <p>
         * A group of parameter settings that are used to configure the component for a specific recipe.
         * </p>
         * 
         * @param parameters
         *        A group of parameter settings that are used to configure the component for a specific recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ComponentParameter> parameters);

        /**
         * <p>
         * A group of parameter settings that are used to configure the component for a specific recipe.
         * </p>
         * 
         * @param parameters
         *        A group of parameter settings that are used to configure the component for a specific recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ComponentParameter... parameters);

        /**
         * <p>
         * A group of parameter settings that are used to configure the component for a specific recipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ComponentParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ComponentParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<ComponentParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<ComponentParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<ComponentParameter>)
         */
        Builder parameters(Consumer<ComponentParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String componentArn;

        private List<ComponentParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentConfiguration model) {
            componentArn(model.componentArn);
            parameters(model.parameters);
        }

        public final String getComponentArn() {
            return componentArn;
        }

        public final void setComponentArn(String componentArn) {
            this.componentArn = componentArn;
        }

        @Override
        public final Builder componentArn(String componentArn) {
            this.componentArn = componentArn;
            return this;
        }

        public final List<ComponentParameter.Builder> getParameters() {
            List<ComponentParameter.Builder> result = ComponentParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ComponentParameter.BuilderImpl> parameters) {
            this.parameters = ComponentParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ComponentParameter> parameters) {
            this.parameters = ComponentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ComponentParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ComponentParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ComponentParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ComponentConfiguration build() {
            return new ComponentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
