/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateImageRequest.Builder, CreateImageRequest> {
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageRecipeArn").getter(getter(CreateImageRequest::imageRecipeArn))
            .setter(setter(Builder::imageRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()).build();

    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerRecipeArn").getter(getter(CreateImageRequest::containerRecipeArn))
            .setter(setter(Builder::containerRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build())
            .build();

    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("distributionConfigurationArn")
            .getter(getter(CreateImageRequest::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("infrastructureConfigurationArn")
            .getter(getter(CreateImageRequest::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField
            .<ImageTestsConfiguration> builder(MarshallingType.SDK_POJO).memberName("imageTestsConfiguration")
            .getter(getter(CreateImageRequest::imageTestsConfiguration)).setter(setter(Builder::imageTestsConfiguration))
            .constructor(ImageTestsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build())
            .build();

    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enhancedImageMetadataEnabled")
            .getter(getter(CreateImageRequest::enhancedImageMetadataEnabled))
            .setter(setter(Builder::enhancedImageMetadataEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateImageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_RECIPE_ARN_FIELD,
            CONTAINER_RECIPE_ARN_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD,
            IMAGE_TESTS_CONFIGURATION_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String imageRecipeArn;

    private final String containerRecipeArn;

    private final String distributionConfigurationArn;

    private final String infrastructureConfigurationArn;

    private final ImageTestsConfiguration imageTestsConfiguration;

    private final Boolean enhancedImageMetadataEnabled;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageRecipeArn = builder.imageRecipeArn;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and
     *         assessed.
     */
    public final String imageRecipeArn() {
        return imageRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
     */
    public final String containerRecipeArn() {
        return containerRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your
     * pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs
     *         of your pipeline.
     */
    public final String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your
     * image will be built and tested.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which
     *         your image will be built and tested.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The image tests configuration of the image.
     * </p>
     * 
     * @return The image tests configuration of the image.
     */
    public final ImageTestsConfiguration imageTestsConfiguration() {
        return imageTestsConfiguration;
    }

    /**
     * <p>
     * Collects additional information about the image being created, including the operating system (OS) version and
     * package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by
     * default.
     * </p>
     * 
     * @return Collects additional information about the image being created, including the operating system (OS)
     *         version and package list. This information is used to enhance the overall experience of using EC2 Image
     *         Builder. Enabled by default.
     */
    public final Boolean enhancedImageMetadataEnabled() {
        return enhancedImageMetadataEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the image.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The idempotency token used to make this request idempotent.
     * </p>
     * 
     * @return The idempotency token used to make this request idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest) obj;
        return Objects.equals(imageRecipeArn(), other.imageRecipeArn())
                && Objects.equals(containerRecipeArn(), other.containerRecipeArn())
                && Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(imageTestsConfiguration(), other.imageTestsConfiguration())
                && Objects.equals(enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImageRequest").add("ImageRecipeArn", imageRecipeArn())
                .add("ContainerRecipeArn", containerRecipeArn())
                .add("DistributionConfigurationArn", distributionConfigurationArn())
                .add("InfrastructureConfigurationArn", infrastructureConfigurationArn())
                .add("ImageTestsConfiguration", imageTestsConfiguration())
                .add("EnhancedImageMetadataEnabled", enhancedImageMetadataEnabled()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageRecipeArn":
            return Optional.ofNullable(clazz.cast(imageRecipeArn()));
        case "containerRecipeArn":
            return Optional.ofNullable(clazz.cast(containerRecipeArn()));
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        case "infrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "imageTestsConfiguration":
            return Optional.ofNullable(clazz.cast(imageTestsConfiguration()));
        case "enhancedImageMetadataEnabled":
            return Optional.ofNullable(clazz.cast(enhancedImageMetadataEnabled()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRequest, T> g) {
        return obj -> g.apply((CreateImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and
         * assessed.
         * </p>
         * 
         * @param imageRecipeArn
         *        The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and
         *        assessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageRecipeArn(String imageRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
         * </p>
         * 
         * @param containerRecipeArn
         *        The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and
         *        tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRecipeArn(String containerRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of
         * your pipeline.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the
         *        outputs of your pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your
         * image will be built and tested.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in
         *        which your image will be built and tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The image tests configuration of the image.
         * </p>
         * 
         * @param imageTestsConfiguration
         *        The image tests configuration of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration);

        /**
         * <p>
         * The image tests configuration of the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageTestsConfiguration.Builder} avoiding
         * the need to create one manually via {@link ImageTestsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageTestsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageTestsConfiguration(ImageTestsConfiguration)}.
         * 
         * @param imageTestsConfiguration
         *        a consumer that will call methods on {@link ImageTestsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTestsConfiguration(ImageTestsConfiguration)
         */
        default Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return imageTestsConfiguration(ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration).build());
        }

        /**
         * <p>
         * Collects additional information about the image being created, including the operating system (OS) version
         * and package list. This information is used to enhance the overall experience of using EC2 Image Builder.
         * Enabled by default.
         * </p>
         * 
         * @param enhancedImageMetadataEnabled
         *        Collects additional information about the image being created, including the operating system (OS)
         *        version and package list. This information is used to enhance the overall experience of using EC2
         *        Image Builder. Enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled);

        /**
         * <p>
         * The tags of the image.
         * </p>
         * 
         * @param tags
         *        The tags of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The idempotency token used to make this request idempotent.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token used to make this request idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String imageRecipeArn;

        private String containerRecipeArn;

        private String distributionConfigurationArn;

        private String infrastructureConfigurationArn;

        private ImageTestsConfiguration imageTestsConfiguration;

        private Boolean enhancedImageMetadataEnabled;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            super(model);
            imageRecipeArn(model.imageRecipeArn);
            containerRecipeArn(model.containerRecipeArn);
            distributionConfigurationArn(model.distributionConfigurationArn);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            imageTestsConfiguration(model.imageTestsConfiguration);
            enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getImageRecipeArn() {
            return imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final String getContainerRecipeArn() {
            return containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return imageTestsConfiguration != null ? imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
