/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Define and configure the output AMIs of the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmiDistributionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AmiDistributionConfiguration.Builder, AmiDistributionConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AmiDistributionConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AmiDistributionConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> TARGET_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetAccountIds")
            .getter(getter(AmiDistributionConfiguration::targetAccountIds))
            .setter(setter(Builder::targetAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> AMI_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("amiTags")
            .getter(getter(AmiDistributionConfiguration::amiTags))
            .setter(setter(Builder::amiTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(AmiDistributionConfiguration::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<LaunchPermissionConfiguration> LAUNCH_PERMISSION_FIELD = SdkField
            .<LaunchPermissionConfiguration> builder(MarshallingType.SDK_POJO).memberName("launchPermission")
            .getter(getter(AmiDistributionConfiguration::launchPermission)).setter(setter(Builder::launchPermission))
            .constructor(LaunchPermissionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchPermission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TARGET_ACCOUNT_IDS_FIELD, AMI_TAGS_FIELD, KMS_KEY_ID_FIELD, LAUNCH_PERMISSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final List<String> targetAccountIds;

    private final Map<String, String> amiTags;

    private final String kmsKeyId;

    private final LaunchPermissionConfiguration launchPermission;

    private AmiDistributionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.targetAccountIds = builder.targetAccountIds;
        this.amiTags = builder.amiTags;
        this.kmsKeyId = builder.kmsKeyId;
        this.launchPermission = builder.launchPermission;
    }

    /**
     * <p>
     * The name of the output AMI.
     * </p>
     * 
     * @return The name of the output AMI.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the AMI distribution configuration. Minimum and maximum length are in characters.
     * </p>
     * 
     * @return The description of the AMI distribution configuration. Minimum and maximum length are in characters.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetAccountIds() {
        return targetAccountIds != null && !(targetAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of an account to which you want to distribute an image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetAccountIds} method.
     * </p>
     * 
     * @return The ID of an account to which you want to distribute an image.
     */
    public final List<String> targetAccountIds() {
        return targetAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AmiTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmiTags() {
        return amiTags != null && !(amiTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to AMIs distributed to this Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmiTags} method.
     * </p>
     * 
     * @return The tags to apply to AMIs distributed to this Region.
     */
    public final Map<String, String> amiTags() {
        return amiTags;
    }

    /**
     * <p>
     * The KMS key identifier used to encrypt the distributed image.
     * </p>
     * 
     * @return The KMS key identifier used to encrypt the distributed image.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
     * instances.
     * </p>
     * 
     * @return Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
     *         instances.
     */
    public final LaunchPermissionConfiguration launchPermission() {
        return launchPermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetAccountIds() ? targetAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAmiTags() ? amiTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(launchPermission());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiDistributionConfiguration)) {
            return false;
        }
        AmiDistributionConfiguration other = (AmiDistributionConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTargetAccountIds() == other.hasTargetAccountIds()
                && Objects.equals(targetAccountIds(), other.targetAccountIds()) && hasAmiTags() == other.hasAmiTags()
                && Objects.equals(amiTags(), other.amiTags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(launchPermission(), other.launchPermission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmiDistributionConfiguration").add("Name", name()).add("Description", description())
                .add("TargetAccountIds", hasTargetAccountIds() ? targetAccountIds() : null)
                .add("AmiTags", hasAmiTags() ? amiTags() : null).add("KmsKeyId", kmsKeyId())
                .add("LaunchPermission", launchPermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targetAccountIds":
            return Optional.ofNullable(clazz.cast(targetAccountIds()));
        case "amiTags":
            return Optional.ofNullable(clazz.cast(amiTags()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "launchPermission":
            return Optional.ofNullable(clazz.cast(launchPermission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmiDistributionConfiguration, T> g) {
        return obj -> g.apply((AmiDistributionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmiDistributionConfiguration> {
        /**
         * <p>
         * The name of the output AMI.
         * </p>
         * 
         * @param name
         *        The name of the output AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the AMI distribution configuration. Minimum and maximum length are in characters.
         * </p>
         * 
         * @param description
         *        The description of the AMI distribution configuration. Minimum and maximum length are in characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of an account to which you want to distribute an image.
         * </p>
         * 
         * @param targetAccountIds
         *        The ID of an account to which you want to distribute an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountIds(Collection<String> targetAccountIds);

        /**
         * <p>
         * The ID of an account to which you want to distribute an image.
         * </p>
         * 
         * @param targetAccountIds
         *        The ID of an account to which you want to distribute an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountIds(String... targetAccountIds);

        /**
         * <p>
         * The tags to apply to AMIs distributed to this Region.
         * </p>
         * 
         * @param amiTags
         *        The tags to apply to AMIs distributed to this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiTags(Map<String, String> amiTags);

        /**
         * <p>
         * The KMS key identifier used to encrypt the distributed image.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier used to encrypt the distributed image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
         * instances.
         * </p>
         * 
         * @param launchPermission
         *        Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to
         *        launch instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermission(LaunchPermissionConfiguration launchPermission);

        /**
         * <p>
         * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
         * instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchPermissionConfiguration.Builder}
         * avoiding the need to create one manually via {@link LaunchPermissionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchPermissionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #launchPermission(LaunchPermissionConfiguration)}.
         * 
         * @param launchPermission
         *        a consumer that will call methods on {@link LaunchPermissionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchPermission(LaunchPermissionConfiguration)
         */
        default Builder launchPermission(Consumer<LaunchPermissionConfiguration.Builder> launchPermission) {
            return launchPermission(LaunchPermissionConfiguration.builder().applyMutation(launchPermission).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> targetAccountIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> amiTags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyId;

        private LaunchPermissionConfiguration launchPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiDistributionConfiguration model) {
            name(model.name);
            description(model.description);
            targetAccountIds(model.targetAccountIds);
            amiTags(model.amiTags);
            kmsKeyId(model.kmsKeyId);
            launchPermission(model.launchPermission);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getTargetAccountIds() {
            if (targetAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return targetAccountIds;
        }

        public final void setTargetAccountIds(Collection<String> targetAccountIds) {
            this.targetAccountIds = AccountListCopier.copy(targetAccountIds);
        }

        @Override
        public final Builder targetAccountIds(Collection<String> targetAccountIds) {
            this.targetAccountIds = AccountListCopier.copy(targetAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountIds(String... targetAccountIds) {
            targetAccountIds(Arrays.asList(targetAccountIds));
            return this;
        }

        public final Map<String, String> getAmiTags() {
            if (amiTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return amiTags;
        }

        public final void setAmiTags(Map<String, String> amiTags) {
            this.amiTags = TagMapCopier.copy(amiTags);
        }

        @Override
        public final Builder amiTags(Map<String, String> amiTags) {
            this.amiTags = TagMapCopier.copy(amiTags);
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final LaunchPermissionConfiguration.Builder getLaunchPermission() {
            return launchPermission != null ? launchPermission.toBuilder() : null;
        }

        public final void setLaunchPermission(LaunchPermissionConfiguration.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionConfiguration launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        @Override
        public AmiDistributionConfiguration build() {
            return new AmiDistributionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
