/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * GetInfrastructureConfiguration response object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInfrastructureConfigurationResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetInfrastructureConfigurationResponse.Builder, GetInfrastructureConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(GetInfrastructureConfigurationResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<InfrastructureConfiguration> INFRASTRUCTURE_CONFIGURATION_FIELD = SdkField
            .<InfrastructureConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("infrastructureConfiguration")
            .getter(getter(GetInfrastructureConfigurationResponse::infrastructureConfiguration))
            .setter(setter(Builder::infrastructureConfiguration))
            .constructor(InfrastructureConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            INFRASTRUCTURE_CONFIGURATION_FIELD));

    private final String requestIdValue;

    private final InfrastructureConfiguration infrastructureConfiguration;

    private GetInfrastructureConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.infrastructureConfiguration = builder.infrastructureConfiguration;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The infrastructure configuration object.
     * </p>
     * 
     * @return The infrastructure configuration object.
     */
    public final InfrastructureConfiguration infrastructureConfiguration() {
        return infrastructureConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInfrastructureConfigurationResponse)) {
            return false;
        }
        GetInfrastructureConfigurationResponse other = (GetInfrastructureConfigurationResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(infrastructureConfiguration(), other.infrastructureConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInfrastructureConfigurationResponse").add("RequestId", requestId())
                .add("InfrastructureConfiguration", infrastructureConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "infrastructureConfiguration":
            return Optional.ofNullable(clazz.cast(infrastructureConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInfrastructureConfigurationResponse, T> g) {
        return obj -> g.apply((GetInfrastructureConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInfrastructureConfigurationResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The infrastructure configuration object.
         * </p>
         * 
         * @param infrastructureConfiguration
         *        The infrastructure configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration);

        /**
         * <p>
         * The infrastructure configuration object.
         * </p>
         * This is a convenience method that creates an instance of the {@link InfrastructureConfiguration.Builder}
         * avoiding the need to create one manually via {@link InfrastructureConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InfrastructureConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #infrastructureConfiguration(InfrastructureConfiguration)}.
         * 
         * @param infrastructureConfiguration
         *        a consumer that will call methods on {@link InfrastructureConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infrastructureConfiguration(InfrastructureConfiguration)
         */
        default Builder infrastructureConfiguration(Consumer<InfrastructureConfiguration.Builder> infrastructureConfiguration) {
            return infrastructureConfiguration(InfrastructureConfiguration.builder().applyMutation(infrastructureConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private InfrastructureConfiguration infrastructureConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInfrastructureConfigurationResponse model) {
            super(model);
            requestId(model.requestIdValue);
            infrastructureConfiguration(model.infrastructureConfiguration);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final InfrastructureConfiguration.Builder getInfrastructureConfiguration() {
            return infrastructureConfiguration != null ? infrastructureConfiguration.toBuilder() : null;
        }

        public final void setInfrastructureConfiguration(InfrastructureConfiguration.BuilderImpl infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration != null ? infrastructureConfiguration.build() : null;
        }

        @Override
        public final Builder infrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration;
            return this;
        }

        @Override
        public GetInfrastructureConfigurationResponse build() {
            return new GetInfrastructureConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
