/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A schedule configures how often and when a pipeline will automatically create a new image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleExpression").getter(getter(Schedule::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(Schedule::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_START_CONDITION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionStartCondition")
            .getter(getter(Schedule::pipelineExecutionStartConditionAsString))
            .setter(setter(Builder::pipelineExecutionStartCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionStartCondition")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD,
            TIMEZONE_FIELD, PIPELINE_EXECUTION_START_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private final String timezone;

    private final String pipelineExecutionStartCondition;

    private Schedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.pipelineExecutionStartCondition = builder.pipelineExecutionStartCondition;
    }

    /**
     * <p>
     * The cron expression determines how often EC2 Image Builder evaluates your
     * <code>pipelineExecutionStartCondition</code>.
     * </p>
     * <p>
     * For information on how to format a cron expression in Image Builder, see <a
     * href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron expressions in
     * EC2 Image Builder</a>.
     * </p>
     * 
     * @return The cron expression determines how often EC2 Image Builder evaluates your
     *         <code>pipelineExecutionStartCondition</code>.</p>
     *         <p>
     *         For information on how to format a cron expression in Image Builder, see <a
     *         href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
     *         expressions in EC2 Image Builder</a>.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the <a
     * href="https://www.joda.org/joda-time/timezones.html">IANA timezone format</a>. If not specified this defaults to
     * UTC.
     * </p>
     * 
     * @return The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in
     *         the <a href="https://www.joda.org/joda-time/timezones.html">IANA timezone format</a>. If not specified
     *         this defaults to UTC.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The condition configures when the pipeline should trigger a new image build. When the
     * <code>pipelineExecutionStartCondition</code> is set to
     * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on the
     * source image or components in your image recipe, EC2 Image Builder will build a new image only when there are new
     * versions of the image or components in your recipe that match the semantic version filter. When it is set to
     * <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON expression matches the current
     * time. For semantic version syntax, see <a
     * href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a>
     * in the <i> EC2 Image Builder API Reference</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStartCondition} will return
     * {@link PipelineExecutionStartCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pipelineExecutionStartConditionAsString}.
     * </p>
     * 
     * @return The condition configures when the pipeline should trigger a new image build. When the
     *         <code>pipelineExecutionStartCondition</code> is set to
     *         <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on
     *         the source image or components in your image recipe, EC2 Image Builder will build a new image only when
     *         there are new versions of the image or components in your recipe that match the semantic version filter.
     *         When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON
     *         expression matches the current time. For semantic version syntax, see <a
     *         href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html"
     *         >CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.
     * @see PipelineExecutionStartCondition
     */
    public final PipelineExecutionStartCondition pipelineExecutionStartCondition() {
        return PipelineExecutionStartCondition.fromValue(pipelineExecutionStartCondition);
    }

    /**
     * <p>
     * The condition configures when the pipeline should trigger a new image build. When the
     * <code>pipelineExecutionStartCondition</code> is set to
     * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on the
     * source image or components in your image recipe, EC2 Image Builder will build a new image only when there are new
     * versions of the image or components in your recipe that match the semantic version filter. When it is set to
     * <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON expression matches the current
     * time. For semantic version syntax, see <a
     * href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a>
     * in the <i> EC2 Image Builder API Reference</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStartCondition} will return
     * {@link PipelineExecutionStartCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pipelineExecutionStartConditionAsString}.
     * </p>
     * 
     * @return The condition configures when the pipeline should trigger a new image build. When the
     *         <code>pipelineExecutionStartCondition</code> is set to
     *         <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on
     *         the source image or components in your image recipe, EC2 Image Builder will build a new image only when
     *         there are new versions of the image or components in your recipe that match the semantic version filter.
     *         When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON
     *         expression matches the current time. For semantic version syntax, see <a
     *         href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html"
     *         >CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.
     * @see PipelineExecutionStartCondition
     */
    public final String pipelineExecutionStartConditionAsString() {
        return pipelineExecutionStartCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionStartConditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(pipelineExecutionStartConditionAsString(), other.pipelineExecutionStartConditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Schedule").add("ScheduleExpression", scheduleExpression()).add("Timezone", timezone())
                .add("PipelineExecutionStartCondition", pipelineExecutionStartConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "pipelineExecutionStartCondition":
            return Optional.ofNullable(clazz.cast(pipelineExecutionStartConditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The cron expression determines how often EC2 Image Builder evaluates your
         * <code>pipelineExecutionStartCondition</code>.
         * </p>
         * <p>
         * For information on how to format a cron expression in Image Builder, see <a
         * href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron expressions
         * in EC2 Image Builder</a>.
         * </p>
         * 
         * @param scheduleExpression
         *        The cron expression determines how often EC2 Image Builder evaluates your
         *        <code>pipelineExecutionStartCondition</code>.</p>
         *        <p>
         *        For information on how to format a cron expression in Image Builder, see <a
         *        href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
         *        expressions in EC2 Image Builder</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the
         * <a href="https://www.joda.org/joda-time/timezones.html">IANA timezone format</a>. If not specified this
         * defaults to UTC.
         * </p>
         * 
         * @param timezone
         *        The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles"
         *        in the <a href="https://www.joda.org/joda-time/timezones.html">IANA timezone format</a>. If not
         *        specified this defaults to UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The condition configures when the pipeline should trigger a new image build. When the
         * <code>pipelineExecutionStartCondition</code> is set to
         * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on the
         * source image or components in your image recipe, EC2 Image Builder will build a new image only when there are
         * new versions of the image or components in your recipe that match the semantic version filter. When it is set
         * to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON expression matches the
         * current time. For semantic version syntax, see <a
         * href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html"
         * >CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.
         * </p>
         * 
         * @param pipelineExecutionStartCondition
         *        The condition configures when the pipeline should trigger a new image build. When the
         *        <code>pipelineExecutionStartCondition</code> is set to
         *        <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters
         *        on the source image or components in your image recipe, EC2 Image Builder will build a new image only
         *        when there are new versions of the image or components in your recipe that match the semantic version
         *        filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the
         *        CRON expression matches the current time. For semantic version syntax, see <a
         *        href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html"
         *        >CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.
         * @see PipelineExecutionStartCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStartCondition
         */
        Builder pipelineExecutionStartCondition(String pipelineExecutionStartCondition);

        /**
         * <p>
         * The condition configures when the pipeline should trigger a new image build. When the
         * <code>pipelineExecutionStartCondition</code> is set to
         * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on the
         * source image or components in your image recipe, EC2 Image Builder will build a new image only when there are
         * new versions of the image or components in your recipe that match the semantic version filter. When it is set
         * to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON expression matches the
         * current time. For semantic version syntax, see <a
         * href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html"
         * >CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.
         * </p>
         * 
         * @param pipelineExecutionStartCondition
         *        The condition configures when the pipeline should trigger a new image build. When the
         *        <code>pipelineExecutionStartCondition</code> is set to
         *        <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters
         *        on the source image or components in your image recipe, EC2 Image Builder will build a new image only
         *        when there are new versions of the image or components in your recipe that match the semantic version
         *        filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the
         *        CRON expression matches the current time. For semantic version syntax, see <a
         *        href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html"
         *        >CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.
         * @see PipelineExecutionStartCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStartCondition
         */
        Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition pipelineExecutionStartCondition);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private String timezone;

        private String pipelineExecutionStartCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            scheduleExpression(model.scheduleExpression);
            timezone(model.timezone);
            pipelineExecutionStartCondition(model.pipelineExecutionStartCondition);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        @Transient
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        @Transient
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getPipelineExecutionStartCondition() {
            return pipelineExecutionStartCondition;
        }

        public final void setPipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
            return this;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition(pipelineExecutionStartCondition == null ? null : pipelineExecutionStartCondition
                    .toString());
            return this;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
