/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains settings for the SSM agent on your build instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemsManagerAgent implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemsManagerAgent.Builder, SystemsManagerAgent> {
    private static final SdkField<Boolean> UNINSTALL_AFTER_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("uninstallAfterBuild").getter(getter(SystemsManagerAgent::uninstallAfterBuild))
            .setter(setter(Builder::uninstallAfterBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uninstallAfterBuild").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNINSTALL_AFTER_BUILD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean uninstallAfterBuild;

    private SystemsManagerAgent(BuilderImpl builder) {
        this.uninstallAfterBuild = builder.uninstallAfterBuild;
    }

    /**
     * <p>
     * Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is
     * set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so
     * that it is included in the new AMI. The default value is false.
     * </p>
     * 
     * @return Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If
     *         this is set to true, then the agent is removed from the final image. If it's set to false, then the agent
     *         is left in, so that it is included in the new AMI. The default value is false.
     */
    public final Boolean uninstallAfterBuild() {
        return uninstallAfterBuild;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uninstallAfterBuild());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemsManagerAgent)) {
            return false;
        }
        SystemsManagerAgent other = (SystemsManagerAgent) obj;
        return Objects.equals(uninstallAfterBuild(), other.uninstallAfterBuild());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemsManagerAgent").add("UninstallAfterBuild", uninstallAfterBuild()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uninstallAfterBuild":
            return Optional.ofNullable(clazz.cast(uninstallAfterBuild()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemsManagerAgent, T> g) {
        return obj -> g.apply((SystemsManagerAgent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemsManagerAgent> {
        /**
         * <p>
         * Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this
         * is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left
         * in, so that it is included in the new AMI. The default value is false.
         * </p>
         * 
         * @param uninstallAfterBuild
         *        Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI.
         *        If this is set to true, then the agent is removed from the final image. If it's set to false, then the
         *        agent is left in, so that it is included in the new AMI. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uninstallAfterBuild(Boolean uninstallAfterBuild);
    }

    static final class BuilderImpl implements Builder {
        private Boolean uninstallAfterBuild;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemsManagerAgent model) {
            uninstallAfterBuild(model.uninstallAfterBuild);
        }

        public final Boolean getUninstallAfterBuild() {
            return uninstallAfterBuild;
        }

        public final void setUninstallAfterBuild(Boolean uninstallAfterBuild) {
            this.uninstallAfterBuild = uninstallAfterBuild;
        }

        @Override
        @Transient
        public final Builder uninstallAfterBuild(Boolean uninstallAfterBuild) {
            this.uninstallAfterBuild = uninstallAfterBuild;
            return this;
        }

        @Override
        public SystemsManagerAgent build() {
            return new SystemsManagerAgent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
