/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher;
import software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher;

/**
 * Service client for accessing imagebuilder asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * EC2 Image Builder is a fully managed Amazon Web Services service that makes it easier to automate the creation,
 * management, and deployment of customized, secure, and up-to-date "golden" server images that are pre-installed and
 * pre-configured with software and settings to meet specific IT standards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ImagebuilderAsyncClient extends SdkClient {
    String SERVICE_NAME = "imagebuilder";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "imagebuilder";

    /**
     * Create a {@link ImagebuilderAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ImagebuilderAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ImagebuilderAsyncClient}.
     */
    static ImagebuilderAsyncClientBuilder builder() {
        return new DefaultImagebuilderAsyncClientBuilder();
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     *
     * @param cancelImageCreationRequest
     * @return A Java Future containing the result of the CancelImageCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelImageCreationResponse> cancelImageCreation(
            CancelImageCreationRequest cancelImageCreationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImageCreationRequest.Builder} avoiding the
     * need to create one manually via {@link CancelImageCreationRequest#builder()}
     * </p>
     *
     * @param cancelImageCreationRequest
     *        A {@link Consumer} that will call methods on {@link CancelImageCreationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelImageCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelImageCreationResponse> cancelImageCreation(
            Consumer<CancelImageCreationRequest.Builder> cancelImageCreationRequest) {
        return cancelImageCreation(CancelImageCreationRequest.builder().applyMutation(cancelImageCreationRequest).build());
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image.
     * </p>
     *
     * @param createComponentRequest
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequest createComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on {@link CreateComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComponentResponse> createComponent(
            Consumer<CreateComponentRequest.Builder> createComponentRequest) {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createContainerRecipeRequest
     * @return A Java Future containing the result of the CreateContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContainerRecipeResponse> createContainerRecipe(
            CreateContainerRecipeRequest createContainerRecipeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerRecipeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateContainerRecipeRequest#builder()}
     * </p>
     *
     * @param createContainerRecipeRequest
     *        A {@link Consumer} that will call methods on {@link CreateContainerRecipeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContainerRecipeResponse> createContainerRecipe(
            Consumer<CreateContainerRecipeRequest.Builder> createContainerRecipeRequest) {
        return createContainerRecipe(CreateContainerRecipeRequest.builder().applyMutation(createContainerRecipeRequest).build());
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param createDistributionConfigurationRequest
     * @return A Java Future containing the result of the CreateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDistributionConfigurationResponse> createDistributionConfiguration(
            CreateDistributionConfigurationRequest createDistributionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param createDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDistributionConfigurationResponse> createDistributionConfiguration(
            Consumer<CreateDistributionConfigurationRequest.Builder> createDistributionConfigurationRequest) {
        return createDistributionConfiguration(CreateDistributionConfigurationRequest.builder()
                .applyMutation(createDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateImageRequest#builder()}
     * </p>
     *
     * @param createImageRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImageResponse> createImage(Consumer<CreateImageRequest.Builder> createImageRequest) {
        return createImage(CreateImageRequest.builder().applyMutation(createImageRequest).build());
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param createImagePipelineRequest
     * @return A Java Future containing the result of the CreateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImagePipelineResponse> createImagePipeline(
            CreateImagePipelineRequest createImagePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImagePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImagePipelineRequest#builder()}
     * </p>
     *
     * @param createImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link CreateImagePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImagePipelineResponse> createImagePipeline(
            Consumer<CreateImagePipelineRequest.Builder> createImagePipelineRequest) {
        return createImagePipeline(CreateImagePipelineRequest.builder().applyMutation(createImagePipelineRequest).build());
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createImageRecipeRequest
     * @return A Java Future containing the result of the CreateImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImageRecipeResponse> createImageRecipe(CreateImageRecipeRequest createImageRecipeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRecipeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateImageRecipeRequest#builder()}
     * </p>
     *
     * @param createImageRecipeRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageRecipeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImageRecipeResponse> createImageRecipe(
            Consumer<CreateImageRecipeRequest.Builder> createImageRecipeRequest) {
        return createImageRecipe(CreateImageRecipeRequest.builder().applyMutation(createImageRecipeRequest).build());
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the CreateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInfrastructureConfigurationResponse> createInfrastructureConfiguration(
            CreateInfrastructureConfigurationRequest createInfrastructureConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateInfrastructureConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInfrastructureConfigurationResponse> createInfrastructureConfiguration(
            Consumer<CreateInfrastructureConfigurationRequest.Builder> createInfrastructureConfigurationRequest) {
        return createInfrastructureConfiguration(CreateInfrastructureConfigurationRequest.builder()
                .applyMutation(createInfrastructureConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     *
     * @param deleteComponentRequest
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(DeleteComponentRequest deleteComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(
            Consumer<DeleteComponentRequest.Builder> deleteComponentRequest) {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     *
     * @param deleteContainerRecipeRequest
     * @return A Java Future containing the result of the DeleteContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContainerRecipeResponse> deleteContainerRecipe(
            DeleteContainerRecipeRequest deleteContainerRecipeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerRecipeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContainerRecipeRequest#builder()}
     * </p>
     *
     * @param deleteContainerRecipeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContainerRecipeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContainerRecipeResponse> deleteContainerRecipe(
            Consumer<DeleteContainerRecipeRequest.Builder> deleteContainerRecipeRequest) {
        return deleteContainerRecipe(DeleteContainerRecipeRequest.builder().applyMutation(deleteContainerRecipeRequest).build());
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     * @return A Java Future containing the result of the DeleteDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDistributionConfigurationResponse> deleteDistributionConfiguration(
            DeleteDistributionConfigurationRequest deleteDistributionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDistributionConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDistributionConfigurationResponse> deleteDistributionConfiguration(
            Consumer<DeleteDistributionConfigurationRequest.Builder> deleteDistributionConfigurationRequest) {
        return deleteDistributionConfiguration(DeleteDistributionConfigurationRequest.builder()
                .applyMutation(deleteDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.comAmazonECR/latest/userguide/delete_image.html"
     * >Deleting an image</a> in the <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.comAmazonECR/latest/userguide/delete_image.html"
     * >Deleting an image</a> in the <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImageResponse> deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest) {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     *
     * @param deleteImagePipelineRequest
     * @return A Java Future containing the result of the DeleteImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteImagePipelineResponse> deleteImagePipeline(
            DeleteImagePipelineRequest deleteImagePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImagePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImagePipelineRequest#builder()}
     * </p>
     *
     * @param deleteImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImagePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteImagePipelineResponse> deleteImagePipeline(
            Consumer<DeleteImagePipelineRequest.Builder> deleteImagePipelineRequest) {
        return deleteImagePipeline(DeleteImagePipelineRequest.builder().applyMutation(deleteImagePipelineRequest).build());
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     *
     * @param deleteImageRecipeRequest
     * @return A Java Future containing the result of the DeleteImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteImageRecipeResponse> deleteImageRecipe(DeleteImageRecipeRequest deleteImageRecipeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRecipeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteImageRecipeRequest#builder()}
     * </p>
     *
     * @param deleteImageRecipeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRecipeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteImageRecipeResponse> deleteImageRecipe(
            Consumer<DeleteImageRecipeRequest.Builder> deleteImageRecipeRequest) {
        return deleteImageRecipe(DeleteImageRecipeRequest.builder().applyMutation(deleteImageRecipeRequest).build());
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the DeleteInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInfrastructureConfigurationResponse> deleteInfrastructureConfiguration(
            DeleteInfrastructureConfigurationRequest deleteInfrastructureConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInfrastructureConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInfrastructureConfigurationResponse> deleteInfrastructureConfiguration(
            Consumer<DeleteInfrastructureConfigurationRequest.Builder> deleteInfrastructureConfigurationRequest) {
        return deleteInfrastructureConfiguration(DeleteInfrastructureConfigurationRequest.builder()
                .applyMutation(deleteInfrastructureConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     *
     * @param getComponentRequest
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(GetComponentRequest getComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest) {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     *
     * @param getComponentPolicyRequest
     * @return A Java Future containing the result of the GetComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComponentPolicyResponse> getComponentPolicy(GetComponentPolicyRequest getComponentPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetComponentPolicyRequest#builder()}
     * </p>
     *
     * @param getComponentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComponentPolicyResponse> getComponentPolicy(
            Consumer<GetComponentPolicyRequest.Builder> getComponentPolicyRequest) {
        return getComponentPolicy(GetComponentPolicyRequest.builder().applyMutation(getComponentPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     *
     * @param getContainerRecipeRequest
     * @return A Java Future containing the result of the GetContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContainerRecipeResponse> getContainerRecipe(GetContainerRecipeRequest getContainerRecipeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerRecipeRequest.Builder} avoiding the
     * need to create one manually via {@link GetContainerRecipeRequest#builder()}
     * </p>
     *
     * @param getContainerRecipeRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerRecipeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContainerRecipeResponse> getContainerRecipe(
            Consumer<GetContainerRecipeRequest.Builder> getContainerRecipeRequest) {
        return getContainerRecipe(GetContainerRecipeRequest.builder().applyMutation(getContainerRecipeRequest).build());
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     * @return A Java Future containing the result of the GetContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContainerRecipePolicyResponse> getContainerRecipePolicy(
            GetContainerRecipePolicyRequest getContainerRecipePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerRecipePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetContainerRecipePolicyRequest#builder()}
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerRecipePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContainerRecipePolicyResponse> getContainerRecipePolicy(
            Consumer<GetContainerRecipePolicyRequest.Builder> getContainerRecipePolicyRequest) {
        return getContainerRecipePolicy(GetContainerRecipePolicyRequest.builder().applyMutation(getContainerRecipePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     *
     * @param getDistributionConfigurationRequest
     * @return A Java Future containing the result of the GetDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDistributionConfigurationResponse> getDistributionConfiguration(
            GetDistributionConfigurationRequest getDistributionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param getDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDistributionConfigurationResponse> getDistributionConfiguration(
            Consumer<GetDistributionConfigurationRequest.Builder> getDistributionConfigurationRequest) {
        return getDistributionConfiguration(GetDistributionConfigurationRequest.builder()
                .applyMutation(getDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     *
     * @param getImageRequest
     * @return A Java Future containing the result of the GetImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImageResponse> getImage(GetImageRequest getImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImageRequest.Builder} avoiding the need to
     * create one manually via {@link GetImageRequest#builder()}
     * </p>
     *
     * @param getImageRequest
     *        A {@link Consumer} that will call methods on {@link GetImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImageResponse> getImage(Consumer<GetImageRequest.Builder> getImageRequest) {
        return getImage(GetImageRequest.builder().applyMutation(getImageRequest).build());
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     *
     * @param getImagePipelineRequest
     * @return A Java Future containing the result of the GetImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImagePipelineResponse> getImagePipeline(GetImagePipelineRequest getImagePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImagePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link GetImagePipelineRequest#builder()}
     * </p>
     *
     * @param getImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link GetImagePipelineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImagePipelineResponse> getImagePipeline(
            Consumer<GetImagePipelineRequest.Builder> getImagePipelineRequest) {
        return getImagePipeline(GetImagePipelineRequest.builder().applyMutation(getImagePipelineRequest).build());
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     *
     * @param getImagePolicyRequest
     * @return A Java Future containing the result of the GetImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImagePolicyResponse> getImagePolicy(GetImagePolicyRequest getImagePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImagePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetImagePolicyRequest#builder()}
     * </p>
     *
     * @param getImagePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetImagePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImagePolicyResponse> getImagePolicy(Consumer<GetImagePolicyRequest.Builder> getImagePolicyRequest) {
        return getImagePolicy(GetImagePolicyRequest.builder().applyMutation(getImagePolicyRequest).build());
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     *
     * @param getImageRecipeRequest
     * @return A Java Future containing the result of the GetImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImageRecipeResponse> getImageRecipe(GetImageRecipeRequest getImageRecipeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImageRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link GetImageRecipeRequest#builder()}
     * </p>
     *
     * @param getImageRecipeRequest
     *        A {@link Consumer} that will call methods on {@link GetImageRecipeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImageRecipeResponse> getImageRecipe(Consumer<GetImageRecipeRequest.Builder> getImageRecipeRequest) {
        return getImageRecipe(GetImageRecipeRequest.builder().applyMutation(getImageRecipeRequest).build());
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     *
     * @param getImageRecipePolicyRequest
     * @return A Java Future containing the result of the GetImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetImageRecipePolicyResponse> getImageRecipePolicy(
            GetImageRecipePolicyRequest getImageRecipePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImageRecipePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetImageRecipePolicyRequest#builder()}
     * </p>
     *
     * @param getImageRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetImageRecipePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetImageRecipePolicyResponse> getImageRecipePolicy(
            Consumer<GetImageRecipePolicyRequest.Builder> getImageRecipePolicyRequest) {
        return getImageRecipePolicy(GetImageRecipePolicyRequest.builder().applyMutation(getImageRecipePolicyRequest).build());
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        GetInfrastructureConfiguration request object.
     * @return A Java Future containing the result of the GetInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInfrastructureConfigurationResponse> getInfrastructureConfiguration(
            GetInfrastructureConfigurationRequest getInfrastructureConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetInfrastructureConfigurationRequest.Builder} to
     *        create a request. GetInfrastructureConfiguration request object.
     * @return A Java Future containing the result of the GetInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInfrastructureConfigurationResponse> getInfrastructureConfiguration(
            Consumer<GetInfrastructureConfigurationRequest.Builder> getInfrastructureConfigurationRequest) {
        return getInfrastructureConfiguration(GetInfrastructureConfigurationRequest.builder()
                .applyMutation(getInfrastructureConfigurationRequest).build());
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     *
     * @param importComponentRequest
     * @return A Java Future containing the result of the ImportComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportComponentResponse> importComponent(ImportComponentRequest importComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportComponentRequest.Builder} avoiding the need
     * to create one manually via {@link ImportComponentRequest#builder()}
     * </p>
     *
     * @param importComponentRequest
     *        A {@link Consumer} that will call methods on {@link ImportComponentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportComponentResponse> importComponent(
            Consumer<ImportComponentRequest.Builder> importComponentRequest) {
        return importComponent(ImportComponentRequest.builder().applyMutation(importComponentRequest).build());
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentBuildVersionsRequest
     * @return A Java Future containing the result of the ListComponentBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentBuildVersionsResponse> listComponentBuildVersions(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentBuildVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListComponentBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentBuildVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComponentBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentBuildVersionsResponse> listComponentBuildVersions(
            Consumer<ListComponentBuildVersionsRequest.Builder> listComponentBuildVersionsRequest) {
        return listComponentBuildVersions(ListComponentBuildVersionsRequest.builder()
                .applyMutation(listComponentBuildVersionsRequest).build());
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher publisher = client.listComponentBuildVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher publisher = client.listComponentBuildVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentBuildVersionsPublisher listComponentBuildVersionsPaginator(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher publisher = client.listComponentBuildVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsPublisher publisher = client.listComponentBuildVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentBuildVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListComponentBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentBuildVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentBuildVersionsPublisher listComponentBuildVersionsPaginator(
            Consumer<ListComponentBuildVersionsRequest.Builder> listComponentBuildVersionsRequest) {
        return listComponentBuildVersionsPaginator(ListComponentBuildVersionsRequest.builder()
                .applyMutation(listComponentBuildVersionsRequest).build());
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A Java Future containing the result of the ListContainerRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContainerRecipesResponse> listContainerRecipes(
            ListContainerRecipesRequest listContainerRecipesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerRecipesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContainerRecipesRequest#builder()}
     * </p>
     *
     * @param listContainerRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListContainerRecipesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListContainerRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContainerRecipesResponse> listContainerRecipes(
            Consumer<ListContainerRecipesRequest.Builder> listContainerRecipesRequest) {
        return listContainerRecipes(ListContainerRecipesRequest.builder().applyMutation(listContainerRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher publisher = client.listContainerRecipesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher publisher = client.listContainerRecipesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerRecipesPublisher listContainerRecipesPaginator(ListContainerRecipesRequest listContainerRecipesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher publisher = client.listContainerRecipesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesPublisher publisher = client.listContainerRecipesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerRecipesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContainerRecipesRequest#builder()}
     * </p>
     *
     * @param listContainerRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListContainerRecipesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerRecipesPublisher listContainerRecipesPaginator(
            Consumer<ListContainerRecipesRequest.Builder> listContainerRecipesRequest) {
        return listContainerRecipesPaginator(ListContainerRecipesRequest.builder().applyMutation(listContainerRecipesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A Java Future containing the result of the ListDistributionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionConfigurationsResponse> listDistributionConfigurations(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDistributionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionConfigurationsResponse> listDistributionConfigurations(
            Consumer<ListDistributionConfigurationsRequest.Builder> listDistributionConfigurationsRequest) {
        return listDistributionConfigurations(ListDistributionConfigurationsRequest.builder()
                .applyMutation(listDistributionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher publisher = client.listDistributionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher publisher = client.listDistributionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionConfigurationsPublisher listDistributionConfigurationsPaginator(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher publisher = client.listDistributionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsPublisher publisher = client.listDistributionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionConfigurationsPublisher listDistributionConfigurationsPaginator(
            Consumer<ListDistributionConfigurationsRequest.Builder> listDistributionConfigurationsRequest) {
        return listDistributionConfigurationsPaginator(ListDistributionConfigurationsRequest.builder()
                .applyMutation(listDistributionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A Java Future containing the result of the ListImageBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImageBuildVersionsResponse> listImageBuildVersions(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageBuildVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listImageBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageBuildVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImageBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImageBuildVersionsResponse> listImageBuildVersions(
            Consumer<ListImageBuildVersionsRequest.Builder> listImageBuildVersionsRequest) {
        return listImageBuildVersions(ListImageBuildVersionsRequest.builder().applyMutation(listImageBuildVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher publisher = client.listImageBuildVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher publisher = client.listImageBuildVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageBuildVersionsPublisher listImageBuildVersionsPaginator(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher publisher = client.listImageBuildVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsPublisher publisher = client.listImageBuildVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageBuildVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listImageBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageBuildVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageBuildVersionsPublisher listImageBuildVersionsPaginator(
            Consumer<ListImageBuildVersionsRequest.Builder> listImageBuildVersionsRequest) {
        return listImageBuildVersionsPaginator(ListImageBuildVersionsRequest.builder()
                .applyMutation(listImageBuildVersionsRequest).build());
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     *
     * @param listImagePackagesRequest
     * @return A Java Future containing the result of the ListImagePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImagePackagesResponse> listImagePackages(ListImagePackagesRequest listImagePackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImagePackagesRequest#builder()}
     * </p>
     *
     * @param listImagePackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePackagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImagePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImagePackagesResponse> listImagePackages(
            Consumer<ListImagePackagesRequest.Builder> listImagePackagesRequest) {
        return listImagePackages(ListImagePackagesRequest.builder().applyMutation(listImagePackagesRequest).build());
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesPublisher publisher = client.listImagePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesPublisher publisher = client.listImagePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePackagesPublisher listImagePackagesPaginator(ListImagePackagesRequest listImagePackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesPublisher publisher = client.listImagePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesPublisher publisher = client.listImagePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImagePackagesRequest#builder()}
     * </p>
     *
     * @param listImagePackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePackagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePackagesPublisher listImagePackagesPaginator(
            Consumer<ListImagePackagesRequest.Builder> listImagePackagesRequest) {
        return listImagePackagesPaginator(ListImagePackagesRequest.builder().applyMutation(listImagePackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A Java Future containing the result of the ListImagePipelineImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImagePipelineImagesResponse> listImagePipelineImages(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelineImagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListImagePipelineImagesRequest#builder()}
     * </p>
     *
     * @param listImagePipelineImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelineImagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImagePipelineImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImagePipelineImagesResponse> listImagePipelineImages(
            Consumer<ListImagePipelineImagesRequest.Builder> listImagePipelineImagesRequest) {
        return listImagePipelineImages(ListImagePipelineImagesRequest.builder().applyMutation(listImagePipelineImagesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher publisher = client.listImagePipelineImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher publisher = client.listImagePipelineImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelineImagesPublisher listImagePipelineImagesPaginator(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher publisher = client.listImagePipelineImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesPublisher publisher = client.listImagePipelineImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelineImagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListImagePipelineImagesRequest#builder()}
     * </p>
     *
     * @param listImagePipelineImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelineImagesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelineImagesPublisher listImagePipelineImagesPaginator(
            Consumer<ListImagePipelineImagesRequest.Builder> listImagePipelineImagesRequest) {
        return listImagePipelineImagesPaginator(ListImagePipelineImagesRequest.builder()
                .applyMutation(listImagePipelineImagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A Java Future containing the result of the ListImagePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImagePipelinesResponse> listImagePipelines(ListImagePipelinesRequest listImagePipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListImagePipelinesRequest#builder()}
     * </p>
     *
     * @param listImagePipelinesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImagePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImagePipelinesResponse> listImagePipelines(
            Consumer<ListImagePipelinesRequest.Builder> listImagePipelinesRequest) {
        return listImagePipelines(ListImagePipelinesRequest.builder().applyMutation(listImagePipelinesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher publisher = client.listImagePipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher publisher = client.listImagePipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelinesPublisher listImagePipelinesPaginator(ListImagePipelinesRequest listImagePipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher publisher = client.listImagePipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesPublisher publisher = client.listImagePipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListImagePipelinesRequest#builder()}
     * </p>
     *
     * @param listImagePipelinesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelinesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelinesPublisher listImagePipelinesPaginator(
            Consumer<ListImagePipelinesRequest.Builder> listImagePipelinesRequest) {
        return listImagePipelinesPaginator(ListImagePipelinesRequest.builder().applyMutation(listImagePipelinesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A Java Future containing the result of the ListImageRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImageRecipesResponse> listImageRecipes(ListImageRecipesRequest listImageRecipesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageRecipesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImageRecipesRequest#builder()}
     * </p>
     *
     * @param listImageRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListImageRecipesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImageRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImageRecipesResponse> listImageRecipes(
            Consumer<ListImageRecipesRequest.Builder> listImageRecipesRequest) {
        return listImageRecipes(ListImageRecipesRequest.builder().applyMutation(listImageRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher publisher = client.listImageRecipesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher publisher = client.listImageRecipesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImageRecipesPublisher listImageRecipesPaginator(ListImageRecipesRequest listImageRecipesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher publisher = client.listImageRecipesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesPublisher publisher = client.listImageRecipesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageRecipesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImageRecipesRequest#builder()}
     * </p>
     *
     * @param listImageRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListImageRecipesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImageRecipesPublisher listImageRecipesPaginator(Consumer<ListImageRecipesRequest.Builder> listImageRecipesRequest) {
        return listImageRecipesPaginator(ListImageRecipesRequest.builder().applyMutation(listImageRecipesRequest).build());
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     *
     * @param listImagesRequest
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImagesResponse> listImages(ListImagesRequest listImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImagesResponse> listImages(Consumer<ListImagesRequest.Builder> listImagesRequest) {
        return listImages(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesPublisher listImagesPaginator(ListImagesRequest listImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesPublisher listImagesPaginator(Consumer<ListImagesRequest.Builder> listImagesRequest) {
        return listImagesPaginator(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A Java Future containing the result of the ListInfrastructureConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInfrastructureConfigurationsResponse> listInfrastructureConfigurations(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInfrastructureConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListInfrastructureConfigurationsRequest#builder()}
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInfrastructureConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListInfrastructureConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInfrastructureConfigurationsResponse> listInfrastructureConfigurations(
            Consumer<ListInfrastructureConfigurationsRequest.Builder> listInfrastructureConfigurationsRequest) {
        return listInfrastructureConfigurations(ListInfrastructureConfigurationsRequest.builder()
                .applyMutation(listInfrastructureConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher publisher = client.listInfrastructureConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher publisher = client.listInfrastructureConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInfrastructureConfigurationsPublisher listInfrastructureConfigurationsPaginator(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher publisher = client.listInfrastructureConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsPublisher publisher = client.listInfrastructureConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInfrastructureConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListInfrastructureConfigurationsRequest#builder()}
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInfrastructureConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInfrastructureConfigurationsPublisher listInfrastructureConfigurationsPaginator(
            Consumer<ListInfrastructureConfigurationsRequest.Builder> listInfrastructureConfigurationsRequest) {
        return listInfrastructureConfigurationsPaginator(ListInfrastructureConfigurationsRequest.builder()
                .applyMutation(listInfrastructureConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putComponentPolicyRequest
     * @return A Java Future containing the result of the PutComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutComponentPolicyResponse> putComponentPolicy(PutComponentPolicyRequest putComponentPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutComponentPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutComponentPolicyRequest#builder()}
     * </p>
     *
     * @param putComponentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutComponentPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutComponentPolicyResponse> putComponentPolicy(
            Consumer<PutComponentPolicyRequest.Builder> putComponentPolicyRequest) {
        return putComponentPolicy(PutComponentPolicyRequest.builder().applyMutation(putComponentPolicyRequest).build());
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for
     * the resource to be visible to all principals with whom the resource is shared.
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     * @return A Java Future containing the result of the PutContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutContainerRecipePolicyResponse> putContainerRecipePolicy(
            PutContainerRecipePolicyRequest putContainerRecipePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for
     * the resource to be visible to all principals with whom the resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutContainerRecipePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutContainerRecipePolicyRequest#builder()}
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutContainerRecipePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutContainerRecipePolicyResponse> putContainerRecipePolicy(
            Consumer<PutContainerRecipePolicyRequest.Builder> putContainerRecipePolicyRequest) {
        return putContainerRecipePolicy(PutContainerRecipePolicyRequest.builder().applyMutation(putContainerRecipePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putImagePolicyRequest
     * @return A Java Future containing the result of the PutImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutImagePolicyResponse> putImagePolicy(PutImagePolicyRequest putImagePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImagePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutImagePolicyRequest#builder()}
     * </p>
     *
     * @param putImagePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutImagePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutImagePolicyResponse> putImagePolicy(Consumer<PutImagePolicyRequest.Builder> putImagePolicyRequest) {
        return putImagePolicy(PutImagePolicyRequest.builder().applyMutation(putImagePolicyRequest).build());
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     *
     * @param putImageRecipePolicyRequest
     * @return A Java Future containing the result of the PutImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutImageRecipePolicyResponse> putImageRecipePolicy(
            PutImageRecipePolicyRequest putImageRecipePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageRecipePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutImageRecipePolicyRequest#builder()}
     * </p>
     *
     * @param putImageRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutImageRecipePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutImageRecipePolicyResponse> putImageRecipePolicy(
            Consumer<PutImageRecipePolicyRequest.Builder> putImageRecipePolicyRequest) {
        return putImageRecipePolicy(PutImageRecipePolicyRequest.builder().applyMutation(putImageRecipePolicyRequest).build());
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     * @return A Java Future containing the result of the StartImagePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartImagePipelineExecutionResponse> startImagePipelineExecution(
            StartImagePipelineExecutionRequest startImagePipelineExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImagePipelineExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link StartImagePipelineExecutionRequest#builder()}
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StartImagePipelineExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartImagePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartImagePipelineExecutionResponse> startImagePipelineExecution(
            Consumer<StartImagePipelineExecutionRequest.Builder> startImagePipelineExecutionRequest) {
        return startImagePipelineExecution(StartImagePipelineExecutionRequest.builder()
                .applyMutation(startImagePipelineExecutionRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     * @return A Java Future containing the result of the UpdateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDistributionConfigurationResponse> updateDistributionConfiguration(
            UpdateDistributionConfigurationRequest updateDistributionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDistributionConfigurationResponse> updateDistributionConfiguration(
            Consumer<UpdateDistributionConfigurationRequest.Builder> updateDistributionConfigurationRequest) {
        return updateDistributionConfiguration(UpdateDistributionConfigurationRequest.builder()
                .applyMutation(updateDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note>
     *
     * @param updateImagePipelineRequest
     * @return A Java Future containing the result of the UpdateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateImagePipelineResponse> updateImagePipeline(
            UpdateImagePipelineRequest updateImagePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateImagePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateImagePipelineRequest#builder()}
     * </p>
     *
     * @param updateImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link UpdateImagePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateImagePipelineResponse> updateImagePipeline(
            Consumer<UpdateImagePipelineRequest.Builder> updateImagePipelineRequest) {
        return updateImagePipeline(UpdateImagePipelineRequest.builder().applyMutation(updateImagePipelineRequest).build());
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the UpdateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInfrastructureConfigurationResponse> updateInfrastructureConfiguration(
            UpdateInfrastructureConfigurationRequest updateInfrastructureConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInfrastructureConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have made a request for an action that is not supported by the service.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInfrastructureConfigurationResponse> updateInfrastructureConfiguration(
            Consumer<UpdateInfrastructureConfigurationRequest.Builder> updateInfrastructureConfigurationRequest) {
        return updateInfrastructureConfiguration(UpdateInfrastructureConfigurationRequest.builder()
                .applyMutation(updateInfrastructureConfigurationRequest).build());
    }
}
