/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The defining characteristics of a specific version of an Image Builder image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageVersion implements SdkPojo, Serializable, ToCopyableBuilder<ImageVersion.Builder, ImageVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ImageVersion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImageVersion::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ImageVersion::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ImageVersion::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ImageVersion::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osVersion").getter(getter(ImageVersion::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ImageVersion::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(ImageVersion::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, VERSION_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, OWNER_FIELD, DATE_CREATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final String version;

    private final String platform;

    private final String osVersion;

    private final String owner;

    private final String dateCreated;

    private ImageVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
     * </p>
     * <note>
     * <p>
     * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that
     * object as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off
     * entirely, or they are specified as wildcards, for example: x.x.x.
     * </p>
     * </li>
     * <li>
     * <p>
     * Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
     * </p>
     * </li>
     * <li>
     * <p>
     * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     * </p>
     * </li>
     * </ol>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of a specific version of an Image Builder image.</p> <note>
     *         <p>
     *         Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to
     *         that object as follows:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either
     *         left off entirely, or they are specified as wildcards, for example: x.x.x.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Build version ARNs have all four nodes, and point to a specific build for a specific version of an
     *         object.
     *         </p>
     *         </li>
     *         </ol>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of this specific version of an Image Builder image.
     * </p>
     * 
     * @return The name of this specific version of an Image Builder image.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this image is an AMI or a container image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether this image is an AMI or a container image.
     * @see ImageType
     */
    public final ImageType type() {
        return ImageType.fromValue(type);
    }

    /**
     * <p>
     * Specifies whether this image is an AMI or a container image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether this image is an AMI or a container image.
     * @see ImageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an
     * upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the
     * fourth node.
     * </p>
     * <p>
     * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that
     * you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as
     * 2021.01.01.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the source image or components for your recipe. When you use a wildcard
     * in any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     * 
     * @return Details for a specific version of an Image Builder image. This version follows the semantic version
     *         syntax.</p> <note>
     *         <p>
     *         The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
     *         assign values for the first three, and can filter on all of them.
     *         </p>
     *         <p>
     *         <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero,
     *         with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build
     *         number to the fourth node.
     *         </p>
     *         <p>
     *         <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
     *         nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a
     *         date, such as 2021.01.01.
     *         </p>
     *         <p>
     *         <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the
     *         most recent versions or nodes when selecting the source image or components for your recipe. When you use
     *         a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     *         </p>
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The platform of the image version, for example "Windows" or "Linux".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image version, for example "Windows" or "Linux".
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the image version, for example "Windows" or "Linux".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image version, for example "Windows" or "Linux".
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
     * Microsoft Windows Server 2019.
     * </p>
     * 
     * @return The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
     *         Microsoft Windows Server 2019.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * <p>
     * The owner of the image version.
     * </p>
     * 
     * @return The owner of the image version.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The date on which this specific version of the Image Builder image was created.
     * </p>
     * 
     * @return The date on which this specific version of the Image Builder image was created.
     */
    public final String dateCreated() {
        return dateCreated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(version(), other.version())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(osVersion(), other.osVersion())
                && Objects.equals(owner(), other.owner()) && Objects.equals(dateCreated(), other.dateCreated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageVersion").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Version", version()).add("Platform", platformAsString()).add("OsVersion", osVersion())
                .add("Owner", owner()).add("DateCreated", dateCreated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "osVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageVersion, T> g) {
        return obj -> g.apply((ImageVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageVersion> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
         * </p>
         * <note>
         * <p>
         * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to
         * that object as follows:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left
         * off entirely, or they are specified as wildcards, for example: x.x.x.
         * </p>
         * </li>
         * <li>
         * <p>
         * Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
         * </p>
         * </li>
         * <li>
         * <p>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </p>
         * </li>
         * </ol>
         * </note>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of a specific version of an Image Builder image.</p> <note>
         *        <p>
         *        Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies
         *        to that object as follows:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         *        either left off entirely, or they are specified as wildcards, for example: x.x.x.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Build version ARNs have all four nodes, and point to a specific build for a specific version of an
         *        object.
         *        </p>
         *        </li>
         *        </ol>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of this specific version of an Image Builder image.
         * </p>
         * 
         * @param name
         *        The name of this specific version of an Image Builder image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this image is an AMI or a container image.
         * </p>
         * 
         * @param type
         *        Specifies whether this image is an AMI or a container image.
         * @see ImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies whether this image is an AMI or a container image.
         * </p>
         * 
         * @param type
         *        Specifies whether this image is an AMI or a container image.
         * @see ImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageType
         */
        Builder type(ImageType type);

        /**
         * <p>
         * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with
         * an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number
         * to the fourth node.
         * </p>
         * <p>
         * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes
         * that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such
         * as 2021.01.01.
         * </p>
         * <p>
         * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
         * recent versions or nodes when selecting the source image or components for your recipe. When you use a
         * wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         * </p>
         * </note>
         * 
         * @param version
         *        Details for a specific version of an Image Builder image. This version follows the semantic version
         *        syntax.</p> <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
         *        zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns
         *        the build number to the fourth node.
         *        </p>
         *        <p>
         *        <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
         *        nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         *        a date, such as 2021.01.01.
         *        </p>
         *        <p>
         *        <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify
         *        the most recent versions or nodes when selecting the source image or components for your recipe. When
         *        you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The platform of the image version, for example "Windows" or "Linux".
         * </p>
         * 
         * @param platform
         *        The platform of the image version, for example "Windows" or "Linux".
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the image version, for example "Windows" or "Linux".
         * </p>
         * 
         * @param platform
         *        The platform of the image version, for example "Windows" or "Linux".
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         * </p>
         * 
         * @param osVersion
         *        The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18,
         *        or Microsoft Windows Server 2019.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The owner of the image version.
         * </p>
         * 
         * @param owner
         *        The owner of the image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The date on which this specific version of the Image Builder image was created.
         * </p>
         * 
         * @param dateCreated
         *        The date on which this specific version of the Image Builder image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String version;

        private String platform;

        private String osVersion;

        private String owner;

        private String dateCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageVersion model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            version(model.version);
            platform(model.platform);
            osVersion(model.osVersion);
            owner(model.owner);
            dateCreated(model.dateCreated);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ImageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        @Transient
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        @Override
        public ImageVersion build() {
            return new ImageVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
