/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerRecipeResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetContainerRecipeResponse.Builder, GetContainerRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(GetContainerRecipeResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<ContainerRecipe> CONTAINER_RECIPE_FIELD = SdkField
            .<ContainerRecipe> builder(MarshallingType.SDK_POJO).memberName("containerRecipe")
            .getter(getter(GetContainerRecipeResponse::containerRecipe)).setter(setter(Builder::containerRecipe))
            .constructor(ContainerRecipe::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipe").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            CONTAINER_RECIPE_FIELD));

    private final String requestIdValue;

    private final ContainerRecipe containerRecipe;

    private GetContainerRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.containerRecipe = builder.containerRecipe;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The container recipe object that is returned.
     * </p>
     * 
     * @return The container recipe object that is returned.
     */
    public final ContainerRecipe containerRecipe() {
        return containerRecipe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(containerRecipe());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerRecipeResponse)) {
            return false;
        }
        GetContainerRecipeResponse other = (GetContainerRecipeResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(containerRecipe(), other.containerRecipe());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContainerRecipeResponse").add("RequestId", requestId())
                .add("ContainerRecipe", containerRecipe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "containerRecipe":
            return Optional.ofNullable(clazz.cast(containerRecipe()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerRecipeResponse, T> g) {
        return obj -> g.apply((GetContainerRecipeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContainerRecipeResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The container recipe object that is returned.
         * </p>
         * 
         * @param containerRecipe
         *        The container recipe object that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRecipe(ContainerRecipe containerRecipe);

        /**
         * <p>
         * The container recipe object that is returned.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerRecipe.Builder} avoiding the need to
         * create one manually via {@link ContainerRecipe#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerRecipe.Builder#build()} is called immediately and its
         * result is passed to {@link #containerRecipe(ContainerRecipe)}.
         * 
         * @param containerRecipe
         *        a consumer that will call methods on {@link ContainerRecipe.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerRecipe(ContainerRecipe)
         */
        default Builder containerRecipe(Consumer<ContainerRecipe.Builder> containerRecipe) {
            return containerRecipe(ContainerRecipe.builder().applyMutation(containerRecipe).build());
        }
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private ContainerRecipe containerRecipe;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerRecipeResponse model) {
            super(model);
            requestId(model.requestIdValue);
            containerRecipe(model.containerRecipe);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        @Transient
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final ContainerRecipe.Builder getContainerRecipe() {
            return containerRecipe != null ? containerRecipe.toBuilder() : null;
        }

        public final void setContainerRecipe(ContainerRecipe.BuilderImpl containerRecipe) {
            this.containerRecipe = containerRecipe != null ? containerRecipe.build() : null;
        }

        @Override
        @Transient
        public final Builder containerRecipe(ContainerRecipe containerRecipe) {
            this.containerRecipe = containerRecipe;
            return this;
        }

        @Override
        public GetContainerRecipeResponse build() {
            return new GetContainerRecipeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
