/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionConfigurationResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetDistributionConfigurationResponse.Builder, GetDistributionConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(GetDistributionConfigurationResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<DistributionConfiguration> DISTRIBUTION_CONFIGURATION_FIELD = SdkField
            .<DistributionConfiguration> builder(MarshallingType.SDK_POJO).memberName("distributionConfiguration")
            .getter(getter(GetDistributionConfigurationResponse::distributionConfiguration))
            .setter(setter(Builder::distributionConfiguration)).constructor(DistributionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            DISTRIBUTION_CONFIGURATION_FIELD));

    private final String requestIdValue;

    private final DistributionConfiguration distributionConfiguration;

    private GetDistributionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.distributionConfiguration = builder.distributionConfiguration;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The distribution configuration object.
     * </p>
     * 
     * @return The distribution configuration object.
     */
    public final DistributionConfiguration distributionConfiguration() {
        return distributionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionConfigurationResponse)) {
            return false;
        }
        GetDistributionConfigurationResponse other = (GetDistributionConfigurationResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(distributionConfiguration(), other.distributionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDistributionConfigurationResponse").add("RequestId", requestId())
                .add("DistributionConfiguration", distributionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "distributionConfiguration":
            return Optional.ofNullable(clazz.cast(distributionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionConfigurationResponse, T> g) {
        return obj -> g.apply((GetDistributionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDistributionConfigurationResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The distribution configuration object.
         * </p>
         * 
         * @param distributionConfiguration
         *        The distribution configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfiguration(DistributionConfiguration distributionConfiguration);

        /**
         * <p>
         * The distribution configuration object.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionConfiguration.Builder} avoiding the
         * need to create one manually via {@link DistributionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #distributionConfiguration(DistributionConfiguration)}.
         * 
         * @param distributionConfiguration
         *        a consumer that will call methods on {@link DistributionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfiguration(DistributionConfiguration)
         */
        default Builder distributionConfiguration(Consumer<DistributionConfiguration.Builder> distributionConfiguration) {
            return distributionConfiguration(DistributionConfiguration.builder().applyMutation(distributionConfiguration).build());
        }
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private DistributionConfiguration distributionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionConfigurationResponse model) {
            super(model);
            requestId(model.requestIdValue);
            distributionConfiguration(model.distributionConfiguration);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        @Transient
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final DistributionConfiguration.Builder getDistributionConfiguration() {
            return distributionConfiguration != null ? distributionConfiguration.toBuilder() : null;
        }

        public final void setDistributionConfiguration(DistributionConfiguration.BuilderImpl distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration != null ? distributionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder distributionConfiguration(DistributionConfiguration distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration;
            return this;
        }

        @Override
        public GetDistributionConfigurationResponse build() {
            return new GetDistributionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
