/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentPolicyRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<GetComponentPolicyRequest.Builder, GetComponentPolicyRequest> {
    private static final SdkField<String> COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentArn").getter(getter(GetComponentPolicyRequest::componentArn))
            .setter(setter(Builder::componentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("componentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ARN_FIELD));

    private final String componentArn;

    private GetComponentPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.componentArn = builder.componentArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.
     */
    public final String componentArn() {
        return componentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentPolicyRequest)) {
            return false;
        }
        GetComponentPolicyRequest other = (GetComponentPolicyRequest) obj;
        return Objects.equals(componentArn(), other.componentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComponentPolicyRequest").add("ComponentArn", componentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentArn":
            return Optional.ofNullable(clazz.cast(componentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentPolicyRequest, T> g) {
        return obj -> g.apply((GetComponentPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetComponentPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.
         * </p>
         * 
         * @param componentArn
         *        The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentArn(String componentArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String componentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentPolicyRequest model) {
            super(model);
            componentArn(model.componentArn);
        }

        public final String getComponentArn() {
            return componentArn;
        }

        public final void setComponentArn(String componentArn) {
            this.componentArn = componentArn;
        }

        @Override
        @Transient
        public final Builder componentArn(String componentArn) {
            this.componentArn = componentArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComponentPolicyRequest build() {
            return new GetComponentPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
