/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container repository where the output container image is stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetContainerRepository implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetContainerRepository.Builder, TargetContainerRepository> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(TargetContainerRepository::serviceAsString)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(TargetContainerRepository::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD,
            REPOSITORY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String service;

    private final String repositoryName;

    private TargetContainerRepository(BuilderImpl builder) {
        this.service = builder.service;
        this.repositoryName = builder.repositoryName;
    }

    /**
     * <p>
     * Specifies the service in which this image was registered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link ContainerRepositoryService#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceAsString}.
     * </p>
     * 
     * @return Specifies the service in which this image was registered.
     * @see ContainerRepositoryService
     */
    public final ContainerRepositoryService service() {
        return ContainerRepositoryService.fromValue(service);
    }

    /**
     * <p>
     * Specifies the service in which this image was registered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link ContainerRepositoryService#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceAsString}.
     * </p>
     * 
     * @return Specifies the service in which this image was registered.
     * @see ContainerRepositoryService
     */
    public final String serviceAsString() {
        return service;
    }

    /**
     * <p>
     * The name of the container repository where the output container image is stored. This name is prefixed by the
     * repository location.
     * </p>
     * 
     * @return The name of the container repository where the output container image is stored. This name is prefixed by
     *         the repository location.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetContainerRepository)) {
            return false;
        }
        TargetContainerRepository other = (TargetContainerRepository) obj;
        return Objects.equals(serviceAsString(), other.serviceAsString())
                && Objects.equals(repositoryName(), other.repositoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetContainerRepository").add("Service", serviceAsString())
                .add("RepositoryName", repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(serviceAsString()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetContainerRepository, T> g) {
        return obj -> g.apply((TargetContainerRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetContainerRepository> {
        /**
         * <p>
         * Specifies the service in which this image was registered.
         * </p>
         * 
         * @param service
         *        Specifies the service in which this image was registered.
         * @see ContainerRepositoryService
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerRepositoryService
         */
        Builder service(String service);

        /**
         * <p>
         * Specifies the service in which this image was registered.
         * </p>
         * 
         * @param service
         *        Specifies the service in which this image was registered.
         * @see ContainerRepositoryService
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerRepositoryService
         */
        Builder service(ContainerRepositoryService service);

        /**
         * <p>
         * The name of the container repository where the output container image is stored. This name is prefixed by the
         * repository location.
         * </p>
         * 
         * @param repositoryName
         *        The name of the container repository where the output container image is stored. This name is prefixed
         *        by the repository location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);
    }

    static final class BuilderImpl implements Builder {
        private String service;

        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetContainerRepository model) {
            service(model.service);
            repositoryName(model.repositoryName);
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        @Transient
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        @Transient
        public final Builder service(ContainerRepositoryService service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        @Override
        public TargetContainerRepository build() {
            return new TargetContainerRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
