/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.imagebuilder.model.CallRateLimitExceededException;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ClientException;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ForbiddenException;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterValueException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidRequestException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidVersionNumberException;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceDependencyException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceInUseException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceUnavailableException;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable;
import software.amazon.awssdk.services.imagebuilder.transform.CancelImageCreationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportVmImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListContainerRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListDistributionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePackagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelineImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelinesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListInfrastructureConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.StartImagePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ImagebuilderClient}.
 *
 * @see ImagebuilderClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultImagebuilderClient implements ImagebuilderClient {
    private static final Logger log = Logger.loggerFor(DefaultImagebuilderClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultImagebuilderClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     *
     * @param cancelImageCreationRequest
     * @return Result of the CancelImageCreation operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelImageCreationResponse cancelImageCreation(CancelImageCreationRequest cancelImageCreationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelImageCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelImageCreationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImageCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImageCreation");

            return clientHandler.execute(new ClientExecutionParams<CancelImageCreationRequest, CancelImageCreationResponse>()
                    .withOperationName("CancelImageCreation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cancelImageCreationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelImageCreationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based
     * on a YAML document that you specify using exactly one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline, using the <code>data</code> property in the request body.
     * </p>
     * </li>
     * <li>
     * <p>
     * A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request
     * body.
     * </p>
     * </li>
     * </ul>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponent");

            return clientHandler.execute(new ClientExecutionParams<CreateComponentRequest, CreateComponentResponse>()
                    .withOperationName("CreateComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createContainerRecipeRequest
     * @return Result of the CreateContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContainerRecipeResponse createContainerRecipe(CreateContainerRecipeRequest createContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContainerRecipeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerRecipe");

            return clientHandler.execute(new ClientExecutionParams<CreateContainerRecipeRequest, CreateContainerRecipeResponse>()
                    .withOperationName("CreateContainerRecipe").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createContainerRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateContainerRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param createDistributionConfigurationRequest
     * @return Result of the CreateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDistributionConfigurationResponse createDistributionConfiguration(
            CreateDistributionConfigurationRequest createDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDistributionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionConfigurationRequest, CreateDistributionConfigurationResponse>()
                            .withOperationName("CreateDistributionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateImageResponse createImage(CreateImageRequest createImageRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");

            return clientHandler.execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                    .withOperationName("CreateImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param createImagePipelineRequest
     * @return Result of the CreateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateImagePipelineResponse createImagePipeline(CreateImagePipelineRequest createImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateImagePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<CreateImagePipelineRequest, CreateImagePipelineResponse>()
                    .withOperationName("CreateImagePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createImageRecipeRequest
     * @return Result of the CreateImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateImageRecipeResponse createImageRecipe(CreateImageRecipeRequest createImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImageRecipeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageRecipe");

            return clientHandler.execute(new ClientExecutionParams<CreateImageRecipeRequest, CreateImageRecipeResponse>()
                    .withOperationName("CreateImageRecipe").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createImageRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     * @return Result of the CreateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInfrastructureConfigurationResponse createInfrastructureConfiguration(
            CreateInfrastructureConfigurationRequest createInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInfrastructureConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInfrastructureConfigurationRequest, CreateInfrastructureConfigurationResponse>()
                            .withOperationName("CreateInfrastructureConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponent");

            return clientHandler.execute(new ClientExecutionParams<DeleteComponentRequest, DeleteComponentResponse>()
                    .withOperationName("DeleteComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     *
     * @param deleteContainerRecipeRequest
     * @return Result of the DeleteContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContainerRecipeResponse deleteContainerRecipe(DeleteContainerRecipeRequest deleteContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContainerRecipeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerRecipe");

            return clientHandler.execute(new ClientExecutionParams<DeleteContainerRecipeRequest, DeleteContainerRecipeResponse>()
                    .withOperationName("DeleteContainerRecipe").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteContainerRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteContainerRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     * @return Result of the DeleteDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDistributionConfigurationResponse deleteDistributionConfiguration(
            DeleteDistributionConfigurationRequest deleteDistributionConfigurationRequest) throws ServiceException,
            ClientException, InvalidRequestException, ServiceUnavailableException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDistributionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDistributionConfigurationRequest, DeleteDistributionConfigurationResponse>()
                            .withOperationName("DeleteDistributionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the
     * <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ServiceException, ClientException,
            InvalidRequestException, ServiceUnavailableException, ForbiddenException, CallRateLimitExceededException,
            ResourceDependencyException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                    .withOperationName("DeleteImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     *
     * @param deleteImagePipelineRequest
     * @return Result of the DeleteImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteImagePipelineResponse deleteImagePipeline(DeleteImagePipelineRequest deleteImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteImagePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<DeleteImagePipelineRequest, DeleteImagePipelineResponse>()
                    .withOperationName("DeleteImagePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     *
     * @param deleteImageRecipeRequest
     * @return Result of the DeleteImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteImageRecipeResponse deleteImageRecipe(DeleteImageRecipeRequest deleteImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImageRecipeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageRecipe");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageRecipeRequest, DeleteImageRecipeResponse>()
                    .withOperationName("DeleteImageRecipe").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImageRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     * @return Result of the DeleteInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInfrastructureConfigurationResponse deleteInfrastructureConfiguration(
            DeleteInfrastructureConfigurationRequest deleteInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInfrastructureConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInfrastructureConfigurationRequest, DeleteInfrastructureConfigurationResponse>()
                            .withOperationName("DeleteInfrastructureConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponent");

            return clientHandler.execute(new ClientExecutionParams<GetComponentRequest, GetComponentResponse>()
                    .withOperationName("GetComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     *
     * @param getComponentPolicyRequest
     * @return Result of the GetComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComponentPolicyResponse getComponentPolicy(GetComponentPolicyRequest getComponentPolicyRequest)
            throws ServiceException, ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetComponentPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponentPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetComponentPolicyRequest, GetComponentPolicyResponse>()
                    .withOperationName("GetComponentPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getComponentPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetComponentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     *
     * @param getContainerRecipeRequest
     * @return Result of the GetContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContainerRecipeResponse getContainerRecipe(GetContainerRecipeRequest getContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetContainerRecipeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipe");

            return clientHandler.execute(new ClientExecutionParams<GetContainerRecipeRequest, GetContainerRecipeResponse>()
                    .withOperationName("GetContainerRecipe").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getContainerRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetContainerRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     * @return Result of the GetContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContainerRecipePolicyResponse getContainerRecipePolicy(
            GetContainerRecipePolicyRequest getContainerRecipePolicyRequest) throws ServiceException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetContainerRecipePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetContainerRecipePolicyRequest, GetContainerRecipePolicyResponse>()
                            .withOperationName("GetContainerRecipePolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getContainerRecipePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetContainerRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     *
     * @param getDistributionConfigurationRequest
     * @return Result of the GetDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDistributionConfigurationResponse getDistributionConfiguration(
            GetDistributionConfigurationRequest getDistributionConfigurationRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDistributionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDistributionConfigurationRequest, GetDistributionConfigurationResponse>()
                            .withOperationName("GetDistributionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     *
     * @param getImageRequest
     * @return Result of the GetImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImageResponse getImage(GetImageRequest getImageRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImage");

            return clientHandler.execute(new ClientExecutionParams<GetImageRequest, GetImageResponse>()
                    .withOperationName("GetImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getImageRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     *
     * @param getImagePipelineRequest
     * @return Result of the GetImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetImagePipelineResponse getImagePipeline(GetImagePipelineRequest getImagePipelineRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImagePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<GetImagePipelineRequest, GetImagePipelineResponse>()
                    .withOperationName("GetImagePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     *
     * @param getImagePolicyRequest
     * @return Result of the GetImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetImagePolicyResponse getImagePolicy(GetImagePolicyRequest getImagePolicyRequest) throws ServiceException,
            ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImagePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetImagePolicyRequest, GetImagePolicyResponse>()
                    .withOperationName("GetImagePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getImagePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImagePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     *
     * @param getImageRecipeRequest
     * @return Result of the GetImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetImageRecipeResponse getImageRecipe(GetImageRecipeRequest getImageRecipeRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImageRecipeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipe");

            return clientHandler.execute(new ClientExecutionParams<GetImageRecipeRequest, GetImageRecipeResponse>()
                    .withOperationName("GetImageRecipe").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getImageRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImageRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     *
     * @param getImageRecipePolicyRequest
     * @return Result of the GetImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetImageRecipePolicyResponse getImageRecipePolicy(GetImageRecipePolicyRequest getImageRecipePolicyRequest)
            throws ServiceException, ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetImageRecipePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetImageRecipePolicyRequest, GetImageRecipePolicyResponse>()
                    .withOperationName("GetImageRecipePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getImageRecipePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImageRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        GetInfrastructureConfiguration request object.
     * @return Result of the GetInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInfrastructureConfigurationResponse getInfrastructureConfiguration(
            GetInfrastructureConfigurationRequest getInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInfrastructureConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetInfrastructureConfigurationRequest, GetInfrastructureConfigurationResponse>()
                            .withOperationName("GetInfrastructureConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     *
     * @param importComponentRequest
     * @return Result of the ImportComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ImportComponentResponse importComponent(ImportComponentRequest importComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportComponent");

            return clientHandler.execute(new ClientExecutionParams<ImportComponentRequest, ImportComponentResponse>()
                    .withOperationName("ImportComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one
     * or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2
     * API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action
     * uses those files to import your VM and create an AMI. To import using the CLI command, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a>
     * </p>
     * <p>
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for
     * your Image Builder recipe.
     * </p>
     *
     * @param importVmImageRequest
     * @return Result of the ImportVmImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportVmImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ImportVmImageResponse importVmImage(ImportVmImageRequest importVmImageRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportVmImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportVmImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importVmImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportVmImage");

            return clientHandler.execute(new ClientExecutionParams<ImportVmImageRequest, ImportVmImageResponse>()
                    .withOperationName("ImportVmImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importVmImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportVmImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentBuildVersionsRequest
     * @return Result of the ListComponentBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListComponentBuildVersionsResponse listComponentBuildVersions(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComponentBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListComponentBuildVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponentBuildVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListComponentBuildVersionsRequest, ListComponentBuildVersionsResponse>()
                            .withOperationName("ListComponentBuildVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listComponentBuildVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListComponentBuildVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client.listComponentBuildVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client
     *             .listComponentBuildVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client.listComponentBuildVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListComponentBuildVersionsIterable listComponentBuildVersionsPaginator(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListComponentBuildVersionsIterable(this, applyPaginatorUserAgent(listComponentBuildVersionsRequest));
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComponentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListComponentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponents");

            return clientHandler.execute(new ClientExecutionParams<ListComponentsRequest, ListComponentsResponse>()
                    .withOperationName("ListComponents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listComponentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListComponentsIterable(this, applyPaginatorUserAgent(listComponentsRequest));
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return Result of the ListContainerRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListContainerRecipesResponse listContainerRecipes(ListContainerRecipesRequest listContainerRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListContainerRecipesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListContainerRecipesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContainerRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerRecipes");

            return clientHandler.execute(new ClientExecutionParams<ListContainerRecipesRequest, ListContainerRecipesResponse>()
                    .withOperationName("ListContainerRecipes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listContainerRecipesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListContainerRecipesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client.listContainerRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client
     *             .listContainerRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client.listContainerRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListContainerRecipesIterable listContainerRecipesPaginator(ListContainerRecipesRequest listContainerRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return new ListContainerRecipesIterable(this, applyPaginatorUserAgent(listContainerRecipesRequest));
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return Result of the ListDistributionConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionConfigurationsResponse listDistributionConfigurations(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDistributionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDistributionConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionConfigurationsRequest, ListDistributionConfigurationsResponse>()
                            .withOperationName("ListDistributionConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listDistributionConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDistributionConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client.listDistributionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client
     *             .listDistributionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client.listDistributionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionConfigurationsIterable listDistributionConfigurationsPaginator(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListDistributionConfigurationsIterable(this, applyPaginatorUserAgent(listDistributionConfigurationsRequest));
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return Result of the ListImageBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImageBuildVersionsResponse listImageBuildVersions(ListImageBuildVersionsRequest listImageBuildVersionsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImageBuildVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageBuildVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImageBuildVersionsRequest, ListImageBuildVersionsResponse>()
                            .withOperationName("ListImageBuildVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listImageBuildVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImageBuildVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client.listImageBuildVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client
     *             .listImageBuildVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client.listImageBuildVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImageBuildVersionsIterable listImageBuildVersionsPaginator(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListImageBuildVersionsIterable(this, applyPaginatorUserAgent(listImageBuildVersionsRequest));
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     *
     * @param listImagePackagesRequest
     * @return Result of the ListImagePackages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePackagesResponse listImagePackages(ListImagePackagesRequest listImagePackagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagePackagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImagePackagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePackages");

            return clientHandler.execute(new ClientExecutionParams<ListImagePackagesRequest, ListImagePackagesResponse>()
                    .withOperationName("ListImagePackages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listImagePackagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImagePackagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client.listImagePackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client
     *             .listImagePackagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client.listImagePackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePackagesIterable listImagePackagesPaginator(ListImagePackagesRequest listImagePackagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListImagePackagesIterable(this, applyPaginatorUserAgent(listImagePackagesRequest));
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return Result of the ListImagePipelineImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePipelineImagesResponse listImagePipelineImages(ListImagePipelineImagesRequest listImagePipelineImagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagePipelineImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImagePipelineImagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelineImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelineImages");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImagePipelineImagesRequest, ListImagePipelineImagesResponse>()
                            .withOperationName("ListImagePipelineImages").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listImagePipelineImagesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImagePipelineImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client.listImagePipelineImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client
     *             .listImagePipelineImagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client.listImagePipelineImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePipelineImagesIterable listImagePipelineImagesPaginator(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListImagePipelineImagesIterable(this, applyPaginatorUserAgent(listImagePipelineImagesRequest));
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return Result of the ListImagePipelines operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePipelinesResponse listImagePipelines(ListImagePipelinesRequest listImagePipelinesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagePipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImagePipelinesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelines");

            return clientHandler.execute(new ClientExecutionParams<ListImagePipelinesRequest, ListImagePipelinesResponse>()
                    .withOperationName("ListImagePipelines").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listImagePipelinesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImagePipelinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client.listImagePipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client
     *             .listImagePipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client.listImagePipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePipelinesIterable listImagePipelinesPaginator(ListImagePipelinesRequest listImagePipelinesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return new ListImagePipelinesIterable(this, applyPaginatorUserAgent(listImagePipelinesRequest));
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     *
     * @param listImageRecipesRequest
     * @return Result of the ListImageRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImageRecipesResponse listImageRecipes(ListImageRecipesRequest listImageRecipesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageRecipesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImageRecipesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageRecipes");

            return clientHandler.execute(new ClientExecutionParams<ListImageRecipesRequest, ListImageRecipesResponse>()
                    .withOperationName("ListImageRecipes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listImageRecipesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImageRecipesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client.listImageRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client
     *             .listImageRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client.listImageRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImageRecipesIterable listImageRecipesPaginator(ListImageRecipesRequest listImageRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return new ListImageRecipesIterable(this, applyPaginatorUserAgent(listImageRecipesRequest));
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     *
     * @param listImagesRequest
     * @return Result of the ListImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImages");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImagesRequest, ListImagesResponse>().withOperationName("ListImages")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listImagesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of images that you have access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImagesIterable listImagesPaginator(ListImagesRequest listImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListImagesIterable(this, applyPaginatorUserAgent(listImagesRequest));
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return Result of the ListInfrastructureConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInfrastructureConfigurationsResponse listInfrastructureConfigurations(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInfrastructureConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInfrastructureConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listInfrastructureConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInfrastructureConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInfrastructureConfigurationsRequest, ListInfrastructureConfigurationsResponse>()
                            .withOperationName("ListInfrastructureConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listInfrastructureConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInfrastructureConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client.listInfrastructureConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client
     *             .listInfrastructureConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client.listInfrastructureConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInfrastructureConfigurationsIterable listInfrastructureConfigurationsPaginator(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return new ListInfrastructureConfigurationsIterable(this,
                applyPaginatorUserAgent(listInfrastructureConfigurationsRequest));
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putComponentPolicyRequest
     * @return Result of the PutComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutComponentPolicyResponse putComponentPolicy(PutComponentPolicyRequest putComponentPolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutComponentPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutComponentPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutComponentPolicyRequest, PutComponentPolicyResponse>()
                    .withOperationName("PutComponentPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putComponentPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutComponentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order
     * for the resource to be visible to all principals with whom the resource is shared.
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     * @return Result of the PutContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutContainerRecipePolicyResponse putContainerRecipePolicy(
            PutContainerRecipePolicyRequest putContainerRecipePolicyRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutContainerRecipePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutContainerRecipePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutContainerRecipePolicyRequest, PutContainerRecipePolicyResponse>()
                            .withOperationName("PutContainerRecipePolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putContainerRecipePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutContainerRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putImagePolicyRequest
     * @return Result of the PutImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutImagePolicyResponse putImagePolicy(PutImagePolicyRequest putImagePolicyRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException,
            ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutImagePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImagePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutImagePolicyRequest, PutImagePolicyResponse>()
                    .withOperationName("PutImagePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putImagePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutImagePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     *
     * @param putImageRecipePolicyRequest
     * @return Result of the PutImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutImageRecipePolicyResponse putImageRecipePolicy(PutImageRecipePolicyRequest putImageRecipePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutImageRecipePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImageRecipePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutImageRecipePolicyRequest, PutImageRecipePolicyResponse>()
                    .withOperationName("PutImageRecipePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putImageRecipePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutImageRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     * @return Result of the StartImagePipelineExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartImagePipelineExecutionResponse startImagePipelineExecution(
            StartImagePipelineExecutionRequest startImagePipelineExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImagePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartImagePipelineExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImagePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImagePipelineExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StartImagePipelineExecutionRequest, StartImagePipelineExecutionResponse>()
                            .withOperationName("StartImagePipelineExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startImagePipelineExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartImagePipelineExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     * @return Result of the UpdateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDistributionConfigurationResponse updateDistributionConfiguration(
            UpdateDistributionConfigurationRequest updateDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDistributionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionConfigurationRequest, UpdateDistributionConfigurationResponse>()
                            .withOperationName("UpdateDistributionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note>
     *
     * @param updateImagePipelineRequest
     * @return Result of the UpdateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateImagePipelineResponse updateImagePipeline(UpdateImagePipelineRequest updateImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateImagePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<UpdateImagePipelineRequest, UpdateImagePipelineResponse>()
                    .withOperationName("UpdateImagePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     * @return Result of the UpdateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have made a request for an action that is not supported by the service.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateInfrastructureConfigurationResponse updateInfrastructureConfiguration(
            UpdateInfrastructureConfigurationRequest updateInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateInfrastructureConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateInfrastructureConfigurationRequest, UpdateInfrastructureConfigurationResponse>()
                            .withOperationName("UpdateInfrastructureConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ImagebuilderException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CallRateLimitExceededException")
                                .exceptionBuilderSupplier(CallRateLimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVersionNumberException")
                                .exceptionBuilderSupplier(InvalidVersionNumberException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientException")
                                .exceptionBuilderSupplier(ClientException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDependencyException")
                                .exceptionBuilderSupplier(ResourceDependencyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends ImagebuilderRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
