/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.PipelineStatus;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.Schedule;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImagePipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImagePipeline> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ImagePipeline.getter(ImagePipeline::arn)).setter(ImagePipeline.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImagePipeline.getter(ImagePipeline::name)).setter(ImagePipeline.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ImagePipeline.getter(ImagePipeline::description)).setter(ImagePipeline.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ImagePipeline.getter(ImagePipeline::platformAsString)).setter(ImagePipeline.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedImageMetadataEnabled").getter(ImagePipeline.getter(ImagePipeline::enhancedImageMetadataEnabled)).setter(ImagePipeline.setter(Builder::enhancedImageMetadataEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled").build()}).build();
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageRecipeArn").getter(ImagePipeline.getter(ImagePipeline::imageRecipeArn)).setter(ImagePipeline.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerRecipeArn").getter(ImagePipeline.getter(ImagePipeline::containerRecipeArn)).setter(ImagePipeline.setter(Builder::containerRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("infrastructureConfigurationArn").getter(ImagePipeline.getter(ImagePipeline::infrastructureConfigurationArn)).setter(ImagePipeline.setter(Builder::infrastructureConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionConfigurationArn").getter(ImagePipeline.getter(ImagePipeline::distributionConfigurationArn)).setter(ImagePipeline.setter(Builder::distributionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn").build()}).build();
    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageTestsConfiguration").getter(ImagePipeline.getter(ImagePipeline::imageTestsConfiguration)).setter(ImagePipeline.setter(Builder::imageTestsConfiguration)).constructor(ImageTestsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(ImagePipeline.getter(ImagePipeline::schedule)).setter(ImagePipeline.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImagePipeline.getter(ImagePipeline::statusAsString)).setter(ImagePipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(ImagePipeline.getter(ImagePipeline::dateCreated)).setter(ImagePipeline.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateUpdated").getter(ImagePipeline.getter(ImagePipeline::dateUpdated)).setter(ImagePipeline.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()}).build();
    private static final SdkField<String> DATE_LAST_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateLastRun").getter(ImagePipeline.getter(ImagePipeline::dateLastRun)).setter(ImagePipeline.setter(Builder::dateLastRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateLastRun").build()}).build();
    private static final SdkField<String> DATE_NEXT_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateNextRun").getter(ImagePipeline.getter(ImagePipeline::dateNextRun)).setter(ImagePipeline.setter(Builder::dateNextRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateNextRun").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ImagePipeline.getter(ImagePipeline::tags)).setter(ImagePipeline.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD, IMAGE_RECIPE_ARN_FIELD, CONTAINER_RECIPE_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, SCHEDULE_FIELD, STATUS_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, DATE_LAST_RUN_FIELD, DATE_NEXT_RUN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String platform;
    private final Boolean enhancedImageMetadataEnabled;
    private final String imageRecipeArn;
    private final String containerRecipeArn;
    private final String infrastructureConfigurationArn;
    private final String distributionConfigurationArn;
    private final ImageTestsConfiguration imageTestsConfiguration;
    private final Schedule schedule;
    private final String status;
    private final String dateCreated;
    private final String dateUpdated;
    private final String dateLastRun;
    private final String dateNextRun;
    private final Map<String, String> tags;

    private ImagePipeline(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.platform = builder.platform;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.imageRecipeArn = builder.imageRecipeArn;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.dateLastRun = builder.dateLastRun;
        this.dateNextRun = builder.dateNextRun;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final Boolean enhancedImageMetadataEnabled() {
        return this.enhancedImageMetadataEnabled;
    }

    public final String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public final String containerRecipeArn() {
        return this.containerRecipeArn;
    }

    public final String infrastructureConfigurationArn() {
        return this.infrastructureConfigurationArn;
    }

    public final String distributionConfigurationArn() {
        return this.distributionConfigurationArn;
    }

    public final ImageTestsConfiguration imageTestsConfiguration() {
        return this.imageTestsConfiguration;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final PipelineStatus status() {
        return PipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final String dateUpdated() {
        return this.dateUpdated;
    }

    public final String dateLastRun() {
        return this.dateLastRun;
    }

    public final String dateNextRun() {
        return this.dateNextRun;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateLastRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateNextRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagePipeline)) {
            return false;
        }
        ImagePipeline other = (ImagePipeline)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled()) && Objects.equals(this.imageRecipeArn(), other.imageRecipeArn()) && Objects.equals(this.containerRecipeArn(), other.containerRecipeArn()) && Objects.equals(this.infrastructureConfigurationArn(), other.infrastructureConfigurationArn()) && Objects.equals(this.distributionConfigurationArn(), other.distributionConfigurationArn()) && Objects.equals(this.imageTestsConfiguration(), other.imageTestsConfiguration()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.dateLastRun(), other.dateLastRun()) && Objects.equals(this.dateNextRun(), other.dateNextRun()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ImagePipeline").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Platform", (Object)this.platformAsString()).add("EnhancedImageMetadataEnabled", (Object)this.enhancedImageMetadataEnabled()).add("ImageRecipeArn", (Object)this.imageRecipeArn()).add("ContainerRecipeArn", (Object)this.containerRecipeArn()).add("InfrastructureConfigurationArn", (Object)this.infrastructureConfigurationArn()).add("DistributionConfigurationArn", (Object)this.distributionConfigurationArn()).add("ImageTestsConfiguration", (Object)this.imageTestsConfiguration()).add("Schedule", (Object)this.schedule()).add("Status", (Object)this.statusAsString()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("DateLastRun", (Object)this.dateLastRun()).add("DateNextRun", (Object)this.dateNextRun()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "enhancedImageMetadataEnabled": {
                return Optional.ofNullable(clazz.cast(this.enhancedImageMetadataEnabled()));
            }
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
            case "containerRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.containerRecipeArn()));
            }
            case "infrastructureConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationArn()));
            }
            case "distributionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationArn()));
            }
            case "imageTestsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageTestsConfiguration()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "dateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "dateLastRun": {
                return Optional.ofNullable(clazz.cast(this.dateLastRun()));
            }
            case "dateNextRun": {
                return Optional.ofNullable(clazz.cast(this.dateNextRun()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImagePipeline, T> g) {
        return obj -> g.apply((ImagePipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String platform;
        private Boolean enhancedImageMetadataEnabled;
        private String imageRecipeArn;
        private String containerRecipeArn;
        private String infrastructureConfigurationArn;
        private String distributionConfigurationArn;
        private ImageTestsConfiguration imageTestsConfiguration;
        private Schedule schedule;
        private String status;
        private String dateCreated;
        private String dateUpdated;
        private String dateLastRun;
        private String dateNextRun;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImagePipeline model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.platform(model.platform);
            this.enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            this.imageRecipeArn(model.imageRecipeArn);
            this.containerRecipeArn(model.containerRecipeArn);
            this.infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            this.distributionConfigurationArn(model.distributionConfigurationArn);
            this.imageTestsConfiguration(model.imageTestsConfiguration);
            this.schedule(model.schedule);
            this.status(model.status);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.dateLastRun(model.dateLastRun);
            this.dateNextRun(model.dateNextRun);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return this.imageTestsConfiguration != null ? this.imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final String getDateUpdated() {
            return this.dateUpdated;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final String getDateLastRun() {
            return this.dateLastRun;
        }

        public final void setDateLastRun(String dateLastRun) {
            this.dateLastRun = dateLastRun;
        }

        @Override
        public final Builder dateLastRun(String dateLastRun) {
            this.dateLastRun = dateLastRun;
            return this;
        }

        public final String getDateNextRun() {
            return this.dateNextRun;
        }

        public final void setDateNextRun(String dateNextRun) {
            this.dateNextRun = dateNextRun;
        }

        @Override
        public final Builder dateNextRun(String dateNextRun) {
            this.dateNextRun = dateNextRun;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public ImagePipeline build() {
            return new ImagePipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImagePipeline> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder enhancedImageMetadataEnabled(Boolean var1);

        public Builder imageRecipeArn(String var1);

        public Builder containerRecipeArn(String var1);

        public Builder infrastructureConfigurationArn(String var1);

        public Builder distributionConfigurationArn(String var1);

        public Builder imageTestsConfiguration(ImageTestsConfiguration var1);

        default public Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return this.imageTestsConfiguration((ImageTestsConfiguration)((ImageTestsConfiguration.Builder)ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration)).build());
        }

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder status(String var1);

        public Builder status(PipelineStatus var1);

        public Builder dateCreated(String var1);

        public Builder dateUpdated(String var1);

        public Builder dateLastRun(String var1);

        public Builder dateNextRun(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

