/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.imagebuilder.model.CallRateLimitExceededException;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ClientException;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ForbiddenException;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderException;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterValueException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidRequestException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidVersionNumberException;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceDependencyException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceInUseException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceUnavailableException;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable;
import software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable;

/**
 * Service client for accessing imagebuilder. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * EC2 Image Builder is a fully managed Amazon Web Services service that makes it easier to automate the creation,
 * management, and deployment of customized, secure, and up-to-date "golden" server images that are pre-installed and
 * pre-configured with software and settings to meet specific IT standards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ImagebuilderClient extends AwsClient {
    String SERVICE_NAME = "imagebuilder";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "imagebuilder";

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     *
     * @param cancelImageCreationRequest
     * @return Result of the CancelImageCreation operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelImageCreationResponse cancelImageCreation(CancelImageCreationRequest cancelImageCreationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImageCreationRequest.Builder} avoiding the
     * need to create one manually via {@link CancelImageCreationRequest#builder()}
     * </p>
     *
     * @param cancelImageCreationRequest
     *        A {@link Consumer} that will call methods on {@link CancelImageCreationRequest.Builder} to create a
     *        request.
     * @return Result of the CancelImageCreation operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelImageCreationResponse cancelImageCreation(
            Consumer<CancelImageCreationRequest.Builder> cancelImageCreationRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return cancelImageCreation(CancelImageCreationRequest.builder().applyMutation(cancelImageCreationRequest).build());
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based
     * on a YAML document that you specify using exactly one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline, using the <code>data</code> property in the request body.
     * </p>
     * </li>
     * <li>
     * <p>
     * A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request
     * body.
     * </p>
     * </li>
     * </ul>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based
     * on a YAML document that you specify using exactly one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline, using the <code>data</code> property in the request body.
     * </p>
     * </li>
     * <li>
     * <p>
     * A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request
     * body.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on {@link CreateComponentRequest.Builder} to create a request.
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateComponentResponse createComponent(Consumer<CreateComponentRequest.Builder> createComponentRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, InvalidParameterCombinationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createContainerRecipeRequest
     * @return Result of the CreateContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerRecipeResponse createContainerRecipe(CreateContainerRecipeRequest createContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerRecipeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateContainerRecipeRequest#builder()}
     * </p>
     *
     * @param createContainerRecipeRequest
     *        A {@link Consumer} that will call methods on {@link CreateContainerRecipeRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerRecipeResponse createContainerRecipe(
            Consumer<CreateContainerRecipeRequest.Builder> createContainerRecipeRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return createContainerRecipe(CreateContainerRecipeRequest.builder().applyMutation(createContainerRecipeRequest).build());
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param createDistributionConfigurationRequest
     * @return Result of the CreateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDistributionConfigurationResponse createDistributionConfiguration(
            CreateDistributionConfigurationRequest createDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param createDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDistributionConfigurationResponse createDistributionConfiguration(
            Consumer<CreateDistributionConfigurationRequest.Builder> createDistributionConfigurationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            ResourceAlreadyExistsException, InvalidParameterCombinationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return createDistributionConfiguration(CreateDistributionConfigurationRequest.builder()
                .applyMutation(createDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImageResponse createImage(CreateImageRequest createImageRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateImageRequest#builder()}
     * </p>
     *
     * @param createImageRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageRequest.Builder} to create a request.
     * @return Result of the CreateImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImageResponse createImage(Consumer<CreateImageRequest.Builder> createImageRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return createImage(CreateImageRequest.builder().applyMutation(createImageRequest).build());
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param createImagePipelineRequest
     * @return Result of the CreateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImagePipelineResponse createImagePipeline(CreateImagePipelineRequest createImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImagePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImagePipelineRequest#builder()}
     * </p>
     *
     * @param createImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link CreateImagePipelineRequest.Builder} to create a
     *        request.
     * @return Result of the CreateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImagePipelineResponse createImagePipeline(
            Consumer<CreateImagePipelineRequest.Builder> createImagePipelineRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return createImagePipeline(CreateImagePipelineRequest.builder().applyMutation(createImagePipelineRequest).build());
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createImageRecipeRequest
     * @return Result of the CreateImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImageRecipeResponse createImageRecipe(CreateImageRecipeRequest createImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRecipeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateImageRecipeRequest#builder()}
     * </p>
     *
     * @param createImageRecipeRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageRecipeRequest.Builder} to create a request.
     * @return Result of the CreateImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImageRecipeResponse createImageRecipe(Consumer<CreateImageRecipeRequest.Builder> createImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return createImageRecipe(CreateImageRecipeRequest.builder().applyMutation(createImageRecipeRequest).build());
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     * @return Result of the CreateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInfrastructureConfigurationResponse createInfrastructureConfiguration(
            CreateInfrastructureConfigurationRequest createInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateInfrastructureConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInfrastructureConfigurationResponse createInfrastructureConfiguration(
            Consumer<CreateInfrastructureConfigurationRequest.Builder> createInfrastructureConfigurationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return createInfrastructureConfiguration(CreateInfrastructureConfigurationRequest.builder()
                .applyMutation(createInfrastructureConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteComponentRequest.Builder} to create a request.
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(Consumer<DeleteComponentRequest.Builder> deleteComponentRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     *
     * @param deleteContainerRecipeRequest
     * @return Result of the DeleteContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContainerRecipeResponse deleteContainerRecipe(DeleteContainerRecipeRequest deleteContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerRecipeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContainerRecipeRequest#builder()}
     * </p>
     *
     * @param deleteContainerRecipeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContainerRecipeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContainerRecipeResponse deleteContainerRecipe(
            Consumer<DeleteContainerRecipeRequest.Builder> deleteContainerRecipeRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return deleteContainerRecipe(DeleteContainerRecipeRequest.builder().applyMutation(deleteContainerRecipeRequest).build());
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     * @return Result of the DeleteDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDistributionConfigurationResponse deleteDistributionConfiguration(
            DeleteDistributionConfigurationRequest deleteDistributionConfigurationRequest) throws ServiceException,
            ClientException, InvalidRequestException, ServiceUnavailableException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDistributionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDistributionConfigurationResponse deleteDistributionConfiguration(
            Consumer<DeleteDistributionConfigurationRequest.Builder> deleteDistributionConfigurationRequest)
            throws ServiceException, ClientException, InvalidRequestException, ServiceUnavailableException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return deleteDistributionConfiguration(DeleteDistributionConfigurationRequest.builder()
                .applyMutation(deleteDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the
     * <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ServiceException, ClientException,
            InvalidRequestException, ServiceUnavailableException, ForbiddenException, CallRateLimitExceededException,
            ResourceDependencyException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the
     * <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRequest.Builder} to create a request.
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest) throws ServiceException,
            ClientException, InvalidRequestException, ServiceUnavailableException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     *
     * @param deleteImagePipelineRequest
     * @return Result of the DeleteImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteImagePipelineResponse deleteImagePipeline(DeleteImagePipelineRequest deleteImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImagePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImagePipelineRequest#builder()}
     * </p>
     *
     * @param deleteImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImagePipelineRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteImagePipelineResponse deleteImagePipeline(
            Consumer<DeleteImagePipelineRequest.Builder> deleteImagePipelineRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            ResourceDependencyException, AwsServiceException, SdkClientException, ImagebuilderException {
        return deleteImagePipeline(DeleteImagePipelineRequest.builder().applyMutation(deleteImagePipelineRequest).build());
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     *
     * @param deleteImageRecipeRequest
     * @return Result of the DeleteImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteImageRecipeResponse deleteImageRecipe(DeleteImageRecipeRequest deleteImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRecipeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteImageRecipeRequest#builder()}
     * </p>
     *
     * @param deleteImageRecipeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRecipeRequest.Builder} to create a request.
     * @return Result of the DeleteImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteImageRecipeResponse deleteImageRecipe(Consumer<DeleteImageRecipeRequest.Builder> deleteImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return deleteImageRecipe(DeleteImageRecipeRequest.builder().applyMutation(deleteImageRecipeRequest).build());
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     * @return Result of the DeleteInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInfrastructureConfigurationResponse deleteInfrastructureConfiguration(
            DeleteInfrastructureConfigurationRequest deleteInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInfrastructureConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInfrastructureConfigurationResponse deleteInfrastructureConfiguration(
            Consumer<DeleteInfrastructureConfigurationRequest.Builder> deleteInfrastructureConfigurationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return deleteInfrastructureConfiguration(DeleteInfrastructureConfigurationRequest.builder()
                .applyMutation(deleteInfrastructureConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentRequest.Builder} to create a request.
     * @return Result of the GetComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComponentResponse getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     *
     * @param getComponentPolicyRequest
     * @return Result of the GetComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComponentPolicyResponse getComponentPolicy(GetComponentPolicyRequest getComponentPolicyRequest)
            throws ServiceException, ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetComponentPolicyRequest#builder()}
     * </p>
     *
     * @param getComponentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComponentPolicyResponse getComponentPolicy(Consumer<GetComponentPolicyRequest.Builder> getComponentPolicyRequest)
            throws ServiceException, ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getComponentPolicy(GetComponentPolicyRequest.builder().applyMutation(getComponentPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     *
     * @param getContainerRecipeRequest
     * @return Result of the GetContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerRecipeResponse getContainerRecipe(GetContainerRecipeRequest getContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerRecipeRequest.Builder} avoiding the
     * need to create one manually via {@link GetContainerRecipeRequest#builder()}
     * </p>
     *
     * @param getContainerRecipeRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerRecipeRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerRecipeResponse getContainerRecipe(Consumer<GetContainerRecipeRequest.Builder> getContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getContainerRecipe(GetContainerRecipeRequest.builder().applyMutation(getContainerRecipeRequest).build());
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     * @return Result of the GetContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerRecipePolicyResponse getContainerRecipePolicy(
            GetContainerRecipePolicyRequest getContainerRecipePolicyRequest) throws ServiceException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerRecipePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetContainerRecipePolicyRequest#builder()}
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerRecipePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerRecipePolicyResponse getContainerRecipePolicy(
            Consumer<GetContainerRecipePolicyRequest.Builder> getContainerRecipePolicyRequest) throws ServiceException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getContainerRecipePolicy(GetContainerRecipePolicyRequest.builder().applyMutation(getContainerRecipePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     *
     * @param getDistributionConfigurationRequest
     * @return Result of the GetDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionConfigurationResponse getDistributionConfiguration(
            GetDistributionConfigurationRequest getDistributionConfigurationRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param getDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionConfigurationResponse getDistributionConfiguration(
            Consumer<GetDistributionConfigurationRequest.Builder> getDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getDistributionConfiguration(GetDistributionConfigurationRequest.builder()
                .applyMutation(getDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     *
     * @param getImageRequest
     * @return Result of the GetImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImageResponse getImage(GetImageRequest getImageRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImageRequest.Builder} avoiding the need to
     * create one manually via {@link GetImageRequest#builder()}
     * </p>
     *
     * @param getImageRequest
     *        A {@link Consumer} that will call methods on {@link GetImageRequest.Builder} to create a request.
     * @return Result of the GetImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImageResponse getImage(Consumer<GetImageRequest.Builder> getImageRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getImage(GetImageRequest.builder().applyMutation(getImageRequest).build());
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     *
     * @param getImagePipelineRequest
     * @return Result of the GetImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImagePipelineResponse getImagePipeline(GetImagePipelineRequest getImagePipelineRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImagePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link GetImagePipelineRequest#builder()}
     * </p>
     *
     * @param getImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link GetImagePipelineRequest.Builder} to create a request.
     * @return Result of the GetImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImagePipelineResponse getImagePipeline(Consumer<GetImagePipelineRequest.Builder> getImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getImagePipeline(GetImagePipelineRequest.builder().applyMutation(getImagePipelineRequest).build());
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     *
     * @param getImagePolicyRequest
     * @return Result of the GetImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImagePolicyResponse getImagePolicy(GetImagePolicyRequest getImagePolicyRequest) throws ServiceException,
            ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImagePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetImagePolicyRequest#builder()}
     * </p>
     *
     * @param getImagePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetImagePolicyRequest.Builder} to create a request.
     * @return Result of the GetImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImagePolicyResponse getImagePolicy(Consumer<GetImagePolicyRequest.Builder> getImagePolicyRequest)
            throws ServiceException, ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getImagePolicy(GetImagePolicyRequest.builder().applyMutation(getImagePolicyRequest).build());
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     *
     * @param getImageRecipeRequest
     * @return Result of the GetImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImageRecipeResponse getImageRecipe(GetImageRecipeRequest getImageRecipeRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImageRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link GetImageRecipeRequest#builder()}
     * </p>
     *
     * @param getImageRecipeRequest
     *        A {@link Consumer} that will call methods on {@link GetImageRecipeRequest.Builder} to create a request.
     * @return Result of the GetImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImageRecipeResponse getImageRecipe(Consumer<GetImageRecipeRequest.Builder> getImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getImageRecipe(GetImageRecipeRequest.builder().applyMutation(getImageRecipeRequest).build());
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     *
     * @param getImageRecipePolicyRequest
     * @return Result of the GetImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetImageRecipePolicyResponse getImageRecipePolicy(GetImageRecipePolicyRequest getImageRecipePolicyRequest)
            throws ServiceException, ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImageRecipePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetImageRecipePolicyRequest#builder()}
     * </p>
     *
     * @param getImageRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetImageRecipePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetImageRecipePolicyResponse getImageRecipePolicy(
            Consumer<GetImageRecipePolicyRequest.Builder> getImageRecipePolicyRequest) throws ServiceException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getImageRecipePolicy(GetImageRecipePolicyRequest.builder().applyMutation(getImageRecipePolicyRequest).build());
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        GetInfrastructureConfiguration request object.
     * @return Result of the GetInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInfrastructureConfigurationResponse getInfrastructureConfiguration(
            GetInfrastructureConfigurationRequest getInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetInfrastructureConfigurationRequest.Builder} to
     *        create a request. GetInfrastructureConfiguration request object.
     * @return Result of the GetInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInfrastructureConfigurationResponse getInfrastructureConfiguration(
            Consumer<GetInfrastructureConfigurationRequest.Builder> getInfrastructureConfigurationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getInfrastructureConfiguration(GetInfrastructureConfigurationRequest.builder()
                .applyMutation(getInfrastructureConfigurationRequest).build());
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow.
     * </p>
     *
     * @param getWorkflowExecutionRequest
     * @return Result of the GetWorkflowExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowExecutionResponse getWorkflowExecution(GetWorkflowExecutionRequest getWorkflowExecutionRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkflowExecutionRequest#builder()}
     * </p>
     *
     * @param getWorkflowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowExecutionRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflowExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowExecutionResponse getWorkflowExecution(
            Consumer<GetWorkflowExecutionRequest.Builder> getWorkflowExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return getWorkflowExecution(GetWorkflowExecutionRequest.builder().applyMutation(getWorkflowExecutionRequest).build());
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow step.
     * </p>
     *
     * @param getWorkflowStepExecutionRequest
     * @return Result of the GetWorkflowStepExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflowStepExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowStepExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepExecutionResponse getWorkflowStepExecution(
            GetWorkflowStepExecutionRequest getWorkflowStepExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowStepExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link GetWorkflowStepExecutionRequest#builder()}
     * </p>
     *
     * @param getWorkflowStepExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowStepExecutionRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflowStepExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflowStepExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowStepExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepExecutionResponse getWorkflowStepExecution(
            Consumer<GetWorkflowStepExecutionRequest.Builder> getWorkflowStepExecutionRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return getWorkflowStepExecution(GetWorkflowStepExecutionRequest.builder().applyMutation(getWorkflowStepExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     *
     * @param importComponentRequest
     * @return Result of the ImportComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportComponentResponse importComponent(ImportComponentRequest importComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportComponentRequest.Builder} avoiding the need
     * to create one manually via {@link ImportComponentRequest#builder()}
     * </p>
     *
     * @param importComponentRequest
     *        A {@link Consumer} that will call methods on {@link ImportComponentRequest.Builder} to create a request.
     * @return Result of the ImportComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportComponentResponse importComponent(Consumer<ImportComponentRequest.Builder> importComponentRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, InvalidParameterCombinationException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return importComponent(ImportComponentRequest.builder().applyMutation(importComponentRequest).build());
    }

    /**
     * <p>
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one
     * or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2
     * API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action
     * uses those files to import your VM and create an AMI. To import using the CLI command, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a>
     * </p>
     * <p>
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for
     * your Image Builder recipe.
     * </p>
     *
     * @param importVmImageRequest
     * @return Result of the ImportVmImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportVmImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportVmImageResponse importVmImage(ImportVmImageRequest importVmImageRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one
     * or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2
     * API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action
     * uses those files to import your VM and create an AMI. To import using the CLI command, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a>
     * </p>
     * <p>
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for
     * your Image Builder recipe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportVmImageRequest.Builder} avoiding the need to
     * create one manually via {@link ImportVmImageRequest#builder()}
     * </p>
     *
     * @param importVmImageRequest
     *        A {@link Consumer} that will call methods on {@link ImportVmImageRequest.Builder} to create a request.
     * @return Result of the ImportVmImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportVmImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportVmImageResponse importVmImage(Consumer<ImportVmImageRequest.Builder> importVmImageRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return importVmImage(ImportVmImageRequest.builder().applyMutation(importVmImageRequest).build());
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentBuildVersionsRequest
     * @return Result of the ListComponentBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentBuildVersionsResponse listComponentBuildVersions(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentBuildVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListComponentBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentBuildVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListComponentBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentBuildVersionsResponse listComponentBuildVersions(
            Consumer<ListComponentBuildVersionsRequest.Builder> listComponentBuildVersionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listComponentBuildVersions(ListComponentBuildVersionsRequest.builder()
                .applyMutation(listComponentBuildVersionsRequest).build());
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client.listComponentBuildVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client
     *             .listComponentBuildVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client.listComponentBuildVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentBuildVersionsIterable listComponentBuildVersionsPaginator(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client.listComponentBuildVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client
     *             .listComponentBuildVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentBuildVersionsIterable responses = client.listComponentBuildVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentBuildVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListComponentBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentBuildVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentBuildVersionsIterable listComponentBuildVersionsPaginator(
            Consumer<ListComponentBuildVersionsRequest.Builder> listComponentBuildVersionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listComponentBuildVersionsPaginator(ListComponentBuildVersionsRequest.builder()
                .applyMutation(listComponentBuildVersionsRequest).build());
    }

    /**
     * <p>
     * Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to
     * streamline results. Newly created components can take up to two minutes to appear in the ListComponents API
     * Results.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to
     * streamline results. Newly created components can take up to two minutes to appear in the ListComponents API
     * Results.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return Result of the ListComponents operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsResponse listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to
     * streamline results. Newly created components can take up to two minutes to appear in the ListComponents API
     * Results.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to
     * streamline results. Newly created components can take up to two minutes to appear in the ListComponents API
     * Results.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return Result of the ListContainerRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerRecipesResponse listContainerRecipes(ListContainerRecipesRequest listContainerRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerRecipesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContainerRecipesRequest#builder()}
     * </p>
     *
     * @param listContainerRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListContainerRecipesRequest.Builder} to create a
     *        request.
     * @return Result of the ListContainerRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerRecipesResponse listContainerRecipes(
            Consumer<ListContainerRecipesRequest.Builder> listContainerRecipesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listContainerRecipes(ListContainerRecipesRequest.builder().applyMutation(listContainerRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client.listContainerRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client
     *             .listContainerRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client.listContainerRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerRecipesIterable listContainerRecipesPaginator(ListContainerRecipesRequest listContainerRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client.listContainerRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client
     *             .listContainerRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListContainerRecipesIterable responses = client.listContainerRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerRecipes(software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerRecipesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContainerRecipesRequest#builder()}
     * </p>
     *
     * @param listContainerRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListContainerRecipesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerRecipesIterable listContainerRecipesPaginator(
            Consumer<ListContainerRecipesRequest.Builder> listContainerRecipesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listContainerRecipesPaginator(ListContainerRecipesRequest.builder().applyMutation(listContainerRecipesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return Result of the ListDistributionConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionConfigurationsResponse listDistributionConfigurations(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDistributionConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionConfigurationsResponse listDistributionConfigurations(
            Consumer<ListDistributionConfigurationsRequest.Builder> listDistributionConfigurationsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listDistributionConfigurations(ListDistributionConfigurationsRequest.builder()
                .applyMutation(listDistributionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client.listDistributionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client
     *             .listDistributionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client.listDistributionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionConfigurationsIterable listDistributionConfigurationsPaginator(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client.listDistributionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client
     *             .listDistributionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListDistributionConfigurationsIterable responses = client.listDistributionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDistributionConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionConfigurationsIterable listDistributionConfigurationsPaginator(
            Consumer<ListDistributionConfigurationsRequest.Builder> listDistributionConfigurationsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listDistributionConfigurationsPaginator(ListDistributionConfigurationsRequest.builder()
                .applyMutation(listDistributionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return Result of the ListImageBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageBuildVersionsResponse listImageBuildVersions(ListImageBuildVersionsRequest listImageBuildVersionsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageBuildVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listImageBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageBuildVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListImageBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageBuildVersionsResponse listImageBuildVersions(
            Consumer<ListImageBuildVersionsRequest.Builder> listImageBuildVersionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImageBuildVersions(ListImageBuildVersionsRequest.builder().applyMutation(listImageBuildVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client.listImageBuildVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client
     *             .listImageBuildVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client.listImageBuildVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageBuildVersionsIterable listImageBuildVersionsPaginator(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client.listImageBuildVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client
     *             .listImageBuildVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageBuildVersionsIterable responses = client.listImageBuildVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageBuildVersions(software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageBuildVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageBuildVersionsRequest#builder()}
     * </p>
     *
     * @param listImageBuildVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageBuildVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageBuildVersionsIterable listImageBuildVersionsPaginator(
            Consumer<ListImageBuildVersionsRequest.Builder> listImageBuildVersionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImageBuildVersionsPaginator(ListImageBuildVersionsRequest.builder()
                .applyMutation(listImageBuildVersionsRequest).build());
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     *
     * @param listImagePackagesRequest
     * @return Result of the ListImagePackages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePackagesResponse listImagePackages(ListImagePackagesRequest listImagePackagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImagePackagesRequest#builder()}
     * </p>
     *
     * @param listImagePackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePackagesRequest.Builder} to create a request.
     * @return Result of the ListImagePackages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePackagesResponse listImagePackages(Consumer<ListImagePackagesRequest.Builder> listImagePackagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return listImagePackages(ListImagePackagesRequest.builder().applyMutation(listImagePackagesRequest).build());
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client.listImagePackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client
     *             .listImagePackagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client.listImagePackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePackagesIterable listImagePackagesPaginator(ListImagePackagesRequest listImagePackagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client.listImagePackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client
     *             .listImagePackagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePackagesIterable responses = client.listImagePackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePackages(software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImagePackagesRequest#builder()}
     * </p>
     *
     * @param listImagePackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePackagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePackagesIterable listImagePackagesPaginator(
            Consumer<ListImagePackagesRequest.Builder> listImagePackagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImagePackagesPaginator(ListImagePackagesRequest.builder().applyMutation(listImagePackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return Result of the ListImagePipelineImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelineImagesResponse listImagePipelineImages(ListImagePipelineImagesRequest listImagePipelineImagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelineImagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListImagePipelineImagesRequest#builder()}
     * </p>
     *
     * @param listImagePipelineImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelineImagesRequest.Builder} to create a
     *        request.
     * @return Result of the ListImagePipelineImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelineImagesResponse listImagePipelineImages(
            Consumer<ListImagePipelineImagesRequest.Builder> listImagePipelineImagesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImagePipelineImages(ListImagePipelineImagesRequest.builder().applyMutation(listImagePipelineImagesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client.listImagePipelineImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client
     *             .listImagePipelineImagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client.listImagePipelineImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelineImagesIterable listImagePipelineImagesPaginator(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client.listImagePipelineImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client
     *             .listImagePipelineImagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelineImagesIterable responses = client.listImagePipelineImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelineImages(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelineImagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListImagePipelineImagesRequest#builder()}
     * </p>
     *
     * @param listImagePipelineImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelineImagesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelineImagesIterable listImagePipelineImagesPaginator(
            Consumer<ListImagePipelineImagesRequest.Builder> listImagePipelineImagesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImagePipelineImagesPaginator(ListImagePipelineImagesRequest.builder()
                .applyMutation(listImagePipelineImagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return Result of the ListImagePipelines operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelinesResponse listImagePipelines(ListImagePipelinesRequest listImagePipelinesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListImagePipelinesRequest#builder()}
     * </p>
     *
     * @param listImagePipelinesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelinesRequest.Builder} to create a
     *        request.
     * @return Result of the ListImagePipelines operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelinesResponse listImagePipelines(Consumer<ListImagePipelinesRequest.Builder> listImagePipelinesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImagePipelines(ListImagePipelinesRequest.builder().applyMutation(listImagePipelinesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client.listImagePipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client
     *             .listImagePipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client.listImagePipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelinesIterable listImagePipelinesPaginator(ListImagePipelinesRequest listImagePipelinesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client.listImagePipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client
     *             .listImagePipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagePipelinesIterable responses = client.listImagePipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImagePipelines(software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagePipelinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListImagePipelinesRequest#builder()}
     * </p>
     *
     * @param listImagePipelinesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagePipelinesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImagePipelinesIterable listImagePipelinesPaginator(
            Consumer<ListImagePipelinesRequest.Builder> listImagePipelinesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImagePipelinesPaginator(ListImagePipelinesRequest.builder().applyMutation(listImagePipelinesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     *
     * @param listImageRecipesRequest
     * @return Result of the ListImageRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImageRecipesResponse listImageRecipes(ListImageRecipesRequest listImageRecipesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageRecipesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImageRecipesRequest#builder()}
     * </p>
     *
     * @param listImageRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListImageRecipesRequest.Builder} to create a request.
     * @return Result of the ListImageRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImageRecipesResponse listImageRecipes(Consumer<ListImageRecipesRequest.Builder> listImageRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImageRecipes(ListImageRecipesRequest.builder().applyMutation(listImageRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client.listImageRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client
     *             .listImageRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client.listImageRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImageRecipesIterable listImageRecipesPaginator(ListImageRecipesRequest listImageRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client.listImageRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client
     *             .listImageRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageRecipesIterable responses = client.listImageRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageRecipes(software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageRecipesRequest.Builder} avoiding the need
     * to create one manually via {@link ListImageRecipesRequest#builder()}
     * </p>
     *
     * @param listImageRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListImageRecipesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImageRecipesIterable listImageRecipesPaginator(Consumer<ListImageRecipesRequest.Builder> listImageRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImageRecipesPaginator(ListImageRecipesRequest.builder().applyMutation(listImageRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder
     * uses to group results. For example, if you want to get a list of findings by severity level for one of your
     * pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don't specify a
     * filter, Image Builder returns an aggregation for your account.
     * </p>
     * <p>
     * To streamline results, you can use the following filters in your request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accountId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imageBuildVersionArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imagePipelineArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vulnerabilityId</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param listImageScanFindingAggregationsRequest
     * @return Result of the ListImageScanFindingAggregations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingAggregationsResponse listImageScanFindingAggregations(
            ListImageScanFindingAggregationsRequest listImageScanFindingAggregationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder
     * uses to group results. For example, if you want to get a list of findings by severity level for one of your
     * pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don't specify a
     * filter, Image Builder returns an aggregation for your account.
     * </p>
     * <p>
     * To streamline results, you can use the following filters in your request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accountId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imageBuildVersionArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imagePipelineArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vulnerabilityId</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageScanFindingAggregationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListImageScanFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listImageScanFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageScanFindingAggregationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListImageScanFindingAggregations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingAggregationsResponse listImageScanFindingAggregations(
            Consumer<ListImageScanFindingAggregationsRequest.Builder> listImageScanFindingAggregationsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImageScanFindingAggregations(ListImageScanFindingAggregationsRequest.builder()
                .applyMutation(listImageScanFindingAggregationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder
     * uses to group results. For example, if you want to get a list of findings by severity level for one of your
     * pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don't specify a
     * filter, Image Builder returns an aggregation for your account.
     * </p>
     * <p>
     * To streamline results, you can use the following filters in your request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accountId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imageBuildVersionArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imagePipelineArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vulnerabilityId</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageScanFindingAggregations(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable responses = client.listImageScanFindingAggregationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable responses = client
     *             .listImageScanFindingAggregationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable responses = client.listImageScanFindingAggregationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageScanFindingAggregations(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageScanFindingAggregationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingAggregationsIterable listImageScanFindingAggregationsPaginator(
            ListImageScanFindingAggregationsRequest listImageScanFindingAggregationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder
     * uses to group results. For example, if you want to get a list of findings by severity level for one of your
     * pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don't specify a
     * filter, Image Builder returns an aggregation for your account.
     * </p>
     * <p>
     * To streamline results, you can use the following filters in your request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accountId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imageBuildVersionArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imagePipelineArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vulnerabilityId</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageScanFindingAggregations(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable responses = client.listImageScanFindingAggregationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable responses = client
     *             .listImageScanFindingAggregationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingAggregationsIterable responses = client.listImageScanFindingAggregationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageScanFindingAggregations(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageScanFindingAggregationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListImageScanFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listImageScanFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageScanFindingAggregationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingAggregationsIterable listImageScanFindingAggregationsPaginator(
            Consumer<ListImageScanFindingAggregationsRequest.Builder> listImageScanFindingAggregationsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImageScanFindingAggregationsPaginator(ListImageScanFindingAggregationsRequest.builder()
                .applyMutation(listImageScanFindingAggregationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of image scan findings for your account.
     * </p>
     *
     * @param listImageScanFindingsRequest
     * @return Result of the ListImageScanFindings operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingsResponse listImageScanFindings(ListImageScanFindingsRequest listImageScanFindingsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image scan findings for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageScanFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageScanFindingsRequest#builder()}
     * </p>
     *
     * @param listImageScanFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageScanFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListImageScanFindings operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingsResponse listImageScanFindings(
            Consumer<ListImageScanFindingsRequest.Builder> listImageScanFindingsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImageScanFindings(ListImageScanFindingsRequest.builder().applyMutation(listImageScanFindingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of image scan findings for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageScanFindings(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable responses = client.listImageScanFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable responses = client
     *             .listImageScanFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable responses = client.listImageScanFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageScanFindings(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageScanFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingsIterable listImageScanFindingsPaginator(ListImageScanFindingsRequest listImageScanFindingsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of image scan findings for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageScanFindings(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable responses = client.listImageScanFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable responses = client
     *             .listImageScanFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImageScanFindingsIterable responses = client.listImageScanFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageScanFindings(software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageScanFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageScanFindingsRequest#builder()}
     * </p>
     *
     * @param listImageScanFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListImageScanFindingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImageScanFindingsIterable listImageScanFindingsPaginator(
            Consumer<ListImageScanFindingsRequest.Builder> listImageScanFindingsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImageScanFindingsPaginator(ListImageScanFindingsRequest.builder().applyMutation(listImageScanFindingsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in
     * the ListImages API Results.
     * </p>
     *
     * @param listImagesRequest
     * @return Result of the ListImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in
     * the ListImages API Results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagesRequest.Builder} to create a request.
     * @return Result of the ListImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesResponse listImages(Consumer<ListImagesRequest.Builder> listImagesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listImages(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in
     * the ListImages API Results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesIterable listImagesPaginator(ListImagesRequest listImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in
     * the ListImages API Results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesIterable listImagesPaginator(Consumer<ListImagesRequest.Builder> listImagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listImagesPaginator(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return Result of the ListInfrastructureConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInfrastructureConfigurationsResponse listInfrastructureConfigurations(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInfrastructureConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListInfrastructureConfigurationsRequest#builder()}
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInfrastructureConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListInfrastructureConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInfrastructureConfigurationsResponse listInfrastructureConfigurations(
            Consumer<ListInfrastructureConfigurationsRequest.Builder> listInfrastructureConfigurationsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listInfrastructureConfigurations(ListInfrastructureConfigurationsRequest.builder()
                .applyMutation(listInfrastructureConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client.listInfrastructureConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client
     *             .listInfrastructureConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client.listInfrastructureConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInfrastructureConfigurationsIterable listInfrastructureConfigurationsPaginator(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client.listInfrastructureConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client
     *             .listInfrastructureConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListInfrastructureConfigurationsIterable responses = client.listInfrastructureConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInfrastructureConfigurations(software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInfrastructureConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListInfrastructureConfigurationsRequest#builder()}
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInfrastructureConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInfrastructureConfigurationsIterable listInfrastructureConfigurationsPaginator(
            Consumer<ListInfrastructureConfigurationsRequest.Builder> listInfrastructureConfigurationsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return listInfrastructureConfigurationsPaginator(ListInfrastructureConfigurationsRequest.builder()
                .applyMutation(listInfrastructureConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     * </p>
     *
     * @param listWorkflowExecutionsRequest
     * @return Result of the ListWorkflowExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowExecutionsResponse listWorkflowExecutions(ListWorkflowExecutionsRequest listWorkflowExecutionsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowExecutionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkflowExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowExecutionsResponse listWorkflowExecutions(
            Consumer<ListWorkflowExecutionsRequest.Builder> listWorkflowExecutionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listWorkflowExecutions(ListWorkflowExecutionsRequest.builder().applyMutation(listWorkflowExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable responses = client.listWorkflowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable responses = client
     *             .listWorkflowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable responses = client.listWorkflowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowExecutionsIterable listWorkflowExecutionsPaginator(
            ListWorkflowExecutionsRequest listWorkflowExecutionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable responses = client.listWorkflowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable responses = client
     *             .listWorkflowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowExecutionsIterable responses = client.listWorkflowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowExecutionsIterable listWorkflowExecutionsPaginator(
            Consumer<ListWorkflowExecutionsRequest.Builder> listWorkflowExecutionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listWorkflowExecutionsPaginator(ListWorkflowExecutionsRequest.builder()
                .applyMutation(listWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * Shows runtime data for each step in a runtime instance of the workflow that you specify in the request.
     * </p>
     *
     * @param listWorkflowStepExecutionsRequest
     * @return Result of the ListWorkflowStepExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepExecutionsResponse listWorkflowStepExecutions(
            ListWorkflowStepExecutionsRequest listWorkflowStepExecutionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows runtime data for each step in a runtime instance of the workflow that you specify in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowStepExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkflowStepExecutionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowStepExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowStepExecutionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkflowStepExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepExecutionsResponse listWorkflowStepExecutions(
            Consumer<ListWorkflowStepExecutionsRequest.Builder> listWorkflowStepExecutionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listWorkflowStepExecutions(ListWorkflowStepExecutionsRequest.builder()
                .applyMutation(listWorkflowStepExecutionsRequest).build());
    }

    /**
     * <p>
     * Shows runtime data for each step in a runtime instance of the workflow that you specify in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowStepExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable responses = client.listWorkflowStepExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable responses = client
     *             .listWorkflowStepExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable responses = client.listWorkflowStepExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowStepExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowStepExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepExecutionsIterable listWorkflowStepExecutionsPaginator(
            ListWorkflowStepExecutionsRequest listWorkflowStepExecutionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows runtime data for each step in a runtime instance of the workflow that you specify in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowStepExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable responses = client.listWorkflowStepExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable responses = client
     *             .listWorkflowStepExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.imagebuilder.paginators.ListWorkflowStepExecutionsIterable responses = client.listWorkflowStepExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowStepExecutions(software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowStepExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkflowStepExecutionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowStepExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowStepExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepExecutionsIterable listWorkflowStepExecutionsPaginator(
            Consumer<ListWorkflowStepExecutionsRequest.Builder> listWorkflowStepExecutionsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return listWorkflowStepExecutionsPaginator(ListWorkflowStepExecutionsRequest.builder()
                .applyMutation(listWorkflowStepExecutionsRequest).build());
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putComponentPolicyRequest
     * @return Result of the PutComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutComponentPolicyResponse putComponentPolicy(PutComponentPolicyRequest putComponentPolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutComponentPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutComponentPolicyRequest#builder()}
     * </p>
     *
     * @param putComponentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutComponentPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutComponentPolicyResponse putComponentPolicy(Consumer<PutComponentPolicyRequest.Builder> putComponentPolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return putComponentPolicy(PutComponentPolicyRequest.builder().applyMutation(putComponentPolicyRequest).build());
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order
     * for the resource to be visible to all principals with whom the resource is shared.
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     * @return Result of the PutContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutContainerRecipePolicyResponse putContainerRecipePolicy(
            PutContainerRecipePolicyRequest putContainerRecipePolicyRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order
     * for the resource to be visible to all principals with whom the resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutContainerRecipePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutContainerRecipePolicyRequest#builder()}
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutContainerRecipePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutContainerRecipePolicyResponse putContainerRecipePolicy(
            Consumer<PutContainerRecipePolicyRequest.Builder> putContainerRecipePolicyRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException,
            ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return putContainerRecipePolicy(PutContainerRecipePolicyRequest.builder().applyMutation(putContainerRecipePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putImagePolicyRequest
     * @return Result of the PutImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutImagePolicyResponse putImagePolicy(PutImagePolicyRequest putImagePolicyRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException,
            ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImagePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutImagePolicyRequest#builder()}
     * </p>
     *
     * @param putImagePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutImagePolicyRequest.Builder} to create a request.
     * @return Result of the PutImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutImagePolicyResponse putImagePolicy(Consumer<PutImagePolicyRequest.Builder> putImagePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return putImagePolicy(PutImagePolicyRequest.builder().applyMutation(putImagePolicyRequest).build());
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     *
     * @param putImageRecipePolicyRequest
     * @return Result of the PutImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutImageRecipePolicyResponse putImageRecipePolicy(PutImageRecipePolicyRequest putImageRecipePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageRecipePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutImageRecipePolicyRequest#builder()}
     * </p>
     *
     * @param putImageRecipePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutImageRecipePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutImageRecipePolicyResponse putImageRecipePolicy(
            Consumer<PutImageRecipePolicyRequest.Builder> putImageRecipePolicyRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        return putImageRecipePolicy(PutImageRecipePolicyRequest.builder().applyMutation(putImageRecipePolicyRequest).build());
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     * @return Result of the StartImagePipelineExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartImagePipelineExecutionResponse startImagePipelineExecution(
            StartImagePipelineExecutionRequest startImagePipelineExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImagePipelineExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link StartImagePipelineExecutionRequest#builder()}
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StartImagePipelineExecutionRequest.Builder} to create
     *        a request.
     * @return Result of the StartImagePipelineExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartImagePipelineExecutionResponse startImagePipelineExecution(
            Consumer<StartImagePipelineExecutionRequest.Builder> startImagePipelineExecutionRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return startImagePipelineExecution(StartImagePipelineExecutionRequest.builder()
                .applyMutation(startImagePipelineExecutionRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     * @return Result of the UpdateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDistributionConfigurationResponse updateDistributionConfiguration(
            UpdateDistributionConfigurationRequest updateDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDistributionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDistributionConfigurationResponse updateDistributionConfiguration(
            Consumer<UpdateDistributionConfigurationRequest.Builder> updateDistributionConfigurationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ImagebuilderException {
        return updateDistributionConfiguration(UpdateDistributionConfigurationRequest.builder()
                .applyMutation(updateDistributionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note>
     *
     * @param updateImagePipelineRequest
     * @return Result of the UpdateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateImagePipelineResponse updateImagePipeline(UpdateImagePipelineRequest updateImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateImagePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateImagePipelineRequest#builder()}
     * </p>
     *
     * @param updateImagePipelineRequest
     *        A {@link Consumer} that will call methods on {@link UpdateImagePipelineRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateImagePipelineResponse updateImagePipeline(
            Consumer<UpdateImagePipelineRequest.Builder> updateImagePipelineRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        return updateImagePipeline(UpdateImagePipelineRequest.builder().applyMutation(updateImagePipelineRequest).build());
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     * @return Result of the UpdateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInfrastructureConfigurationResponse updateInfrastructureConfiguration(
            UpdateInfrastructureConfigurationRequest updateInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInfrastructureConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateInfrastructureConfigurationRequest#builder()}
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInfrastructureConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInfrastructureConfigurationResponse updateInfrastructureConfiguration(
            Consumer<UpdateInfrastructureConfigurationRequest.Builder> updateInfrastructureConfigurationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        return updateInfrastructureConfiguration(UpdateInfrastructureConfigurationRequest.builder()
                .applyMutation(updateInfrastructureConfigurationRequest).build());
    }

    /**
     * Create a {@link ImagebuilderClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ImagebuilderClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ImagebuilderClient}.
     */
    static ImagebuilderClientBuilder builder() {
        return new DefaultImagebuilderClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ImagebuilderServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
