/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.imagebuilder.internal.ImagebuilderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.imagebuilder.model.CallRateLimitExceededException;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ClientException;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.ForbiddenException;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderException;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterValueException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidRequestException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidVersionNumberException;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceDependencyException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceInUseException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceUnavailableException;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.transform.CancelImageCreationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetWorkflowStepExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportVmImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListContainerRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListDistributionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePackagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelineImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelinesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageScanFindingAggregationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageScanFindingsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListInfrastructureConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWorkflowStepExecutionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.StartImagePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ImagebuilderAsyncClient}.
 *
 * @see ImagebuilderAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultImagebuilderAsyncClient implements ImagebuilderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultImagebuilderAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ImagebuilderServiceClientConfiguration serviceClientConfiguration;

    protected DefaultImagebuilderAsyncClient(ImagebuilderServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     *
     * @param cancelImageCreationRequest
     * @return A Java Future containing the result of the CancelImageCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelImageCreationResponse> cancelImageCreation(
            CancelImageCreationRequest cancelImageCreationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelImageCreationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImageCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImageCreation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelImageCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelImageCreationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelImageCreationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelImageCreationRequest, CancelImageCreationResponse>()
                            .withOperationName("CancelImageCreation")
                            .withMarshaller(new CancelImageCreationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelImageCreationRequest));
            CompletableFuture<CancelImageCreationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based
     * on a YAML document that you specify using exactly one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline, using the <code>data</code> property in the request body.
     * </p>
     * </li>
     * <li>
     * <p>
     * A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request
     * body.
     * </p>
     * </li>
     * </ul>
     *
     * @param createComponentRequest
     * @return A Java Future containing the result of the CreateComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequest createComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateComponentRequest, CreateComponentResponse>()
                            .withOperationName("CreateComponent")
                            .withMarshaller(new CreateComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createComponentRequest));
            CompletableFuture<CreateComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createContainerRecipeRequest
     * @return A Java Future containing the result of the CreateContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerRecipeResponse> createContainerRecipe(
            CreateContainerRecipeRequest createContainerRecipeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContainerRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContainerRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContainerRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerRecipeRequest, CreateContainerRecipeResponse>()
                            .withOperationName("CreateContainerRecipe")
                            .withMarshaller(new CreateContainerRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContainerRecipeRequest));
            CompletableFuture<CreateContainerRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param createDistributionConfigurationRequest
     * @return A Java Future containing the result of the CreateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDistributionConfigurationResponse> createDistributionConfiguration(
            CreateDistributionConfigurationRequest createDistributionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionConfigurationRequest, CreateDistributionConfigurationResponse>()
                            .withOperationName("CreateDistributionConfiguration")
                            .withMarshaller(new CreateDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDistributionConfigurationRequest));
            CompletableFuture<CreateDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                            .withOperationName("CreateImage").withMarshaller(new CreateImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImageRequest));
            CompletableFuture<CreateImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param createImagePipelineRequest
     * @return A Java Future containing the result of the CreateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImagePipelineResponse> createImagePipeline(
            CreateImagePipelineRequest createImagePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImagePipelineRequest, CreateImagePipelineResponse>()
                            .withOperationName("CreateImagePipeline")
                            .withMarshaller(new CreateImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImagePipelineRequest));
            CompletableFuture<CreateImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createImageRecipeRequest
     * @return A Java Future containing the result of the CreateImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageRecipeResponse> createImageRecipe(CreateImageRecipeRequest createImageRecipeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImageRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRecipeRequest, CreateImageRecipeResponse>()
                            .withOperationName("CreateImageRecipe")
                            .withMarshaller(new CreateImageRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImageRecipeRequest));
            CompletableFuture<CreateImageRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the CreateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>ResourceAlreadyExistsException The resource that you are trying to create already exists.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the number of permitted resources or operations for
     *         this service. For service quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image
     *         Builder endpoints and quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInfrastructureConfigurationResponse> createInfrastructureConfiguration(
            CreateInfrastructureConfigurationRequest createInfrastructureConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInfrastructureConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInfrastructureConfigurationRequest, CreateInfrastructureConfigurationResponse>()
                            .withOperationName("CreateInfrastructureConfiguration")
                            .withMarshaller(new CreateInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInfrastructureConfigurationRequest));
            CompletableFuture<CreateInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     *
     * @param deleteComponentRequest
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteComponentResponse> deleteComponent(DeleteComponentRequest deleteComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteComponentRequest, DeleteComponentResponse>()
                            .withOperationName("DeleteComponent")
                            .withMarshaller(new DeleteComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteComponentRequest));
            CompletableFuture<DeleteComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     *
     * @param deleteContainerRecipeRequest
     * @return A Java Future containing the result of the DeleteContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContainerRecipeResponse> deleteContainerRecipe(
            DeleteContainerRecipeRequest deleteContainerRecipeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContainerRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContainerRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContainerRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContainerRecipeRequest, DeleteContainerRecipeResponse>()
                            .withOperationName("DeleteContainerRecipe")
                            .withMarshaller(new DeleteContainerRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContainerRecipeRequest));
            CompletableFuture<DeleteContainerRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     * @return A Java Future containing the result of the DeleteDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDistributionConfigurationResponse> deleteDistributionConfiguration(
            DeleteDistributionConfigurationRequest deleteDistributionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDistributionConfigurationRequest, DeleteDistributionConfigurationResponse>()
                            .withOperationName("DeleteDistributionConfiguration")
                            .withMarshaller(new DeleteDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDistributionConfigurationRequest));
            CompletableFuture<DeleteDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the
     * <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                            .withOperationName("DeleteImage").withMarshaller(new DeleteImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImageRequest));
            CompletableFuture<DeleteImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     *
     * @param deleteImagePipelineRequest
     * @return A Java Future containing the result of the DeleteImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImagePipelineResponse> deleteImagePipeline(
            DeleteImagePipelineRequest deleteImagePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImagePipelineRequest, DeleteImagePipelineResponse>()
                            .withOperationName("DeleteImagePipeline")
                            .withMarshaller(new DeleteImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImagePipelineRequest));
            CompletableFuture<DeleteImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     *
     * @param deleteImageRecipeRequest
     * @return A Java Future containing the result of the DeleteImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageRecipeResponse> deleteImageRecipe(DeleteImageRecipeRequest deleteImageRecipeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImageRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImageRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageRecipeRequest, DeleteImageRecipeResponse>()
                            .withOperationName("DeleteImageRecipe")
                            .withMarshaller(new DeleteImageRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImageRecipeRequest));
            CompletableFuture<DeleteImageRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the DeleteInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceDependencyException You have attempted to mutate or delete a resource with a dependency that
     *         prohibits this action. See the error message for more details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInfrastructureConfigurationResponse> deleteInfrastructureConfiguration(
            DeleteInfrastructureConfigurationRequest deleteInfrastructureConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInfrastructureConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInfrastructureConfigurationRequest, DeleteInfrastructureConfigurationResponse>()
                            .withOperationName("DeleteInfrastructureConfiguration")
                            .withMarshaller(new DeleteInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInfrastructureConfigurationRequest));
            CompletableFuture<DeleteInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     *
     * @param getComponentRequest
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetComponentResponse> getComponent(GetComponentRequest getComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComponentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComponentRequest, GetComponentResponse>()
                            .withOperationName("GetComponent").withMarshaller(new GetComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getComponentRequest));
            CompletableFuture<GetComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     *
     * @param getComponentPolicyRequest
     * @return A Java Future containing the result of the GetComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComponentPolicyResponse> getComponentPolicy(GetComponentPolicyRequest getComponentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComponentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetComponentPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComponentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComponentPolicyRequest, GetComponentPolicyResponse>()
                            .withOperationName("GetComponentPolicy")
                            .withMarshaller(new GetComponentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getComponentPolicyRequest));
            CompletableFuture<GetComponentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     *
     * @param getContainerRecipeRequest
     * @return A Java Future containing the result of the GetContainerRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerRecipeResponse> getContainerRecipe(GetContainerRecipeRequest getContainerRecipeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContainerRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerRecipeRequest, GetContainerRecipeResponse>()
                            .withOperationName("GetContainerRecipe")
                            .withMarshaller(new GetContainerRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContainerRecipeRequest));
            CompletableFuture<GetContainerRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     * @return A Java Future containing the result of the GetContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerRecipePolicyResponse> getContainerRecipePolicy(
            GetContainerRecipePolicyRequest getContainerRecipePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContainerRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerRecipePolicyRequest, GetContainerRecipePolicyResponse>()
                            .withOperationName("GetContainerRecipePolicy")
                            .withMarshaller(new GetContainerRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContainerRecipePolicyRequest));
            CompletableFuture<GetContainerRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     *
     * @param getDistributionConfigurationRequest
     * @return A Java Future containing the result of the GetDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionConfigurationResponse> getDistributionConfiguration(
            GetDistributionConfigurationRequest getDistributionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionConfigurationRequest, GetDistributionConfigurationResponse>()
                            .withOperationName("GetDistributionConfiguration")
                            .withMarshaller(new GetDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDistributionConfigurationRequest));
            CompletableFuture<GetDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     *
     * @param getImageRequest
     * @return A Java Future containing the result of the GetImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImageResponse> getImage(GetImageRequest getImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImageRequest, GetImageResponse>().withOperationName("GetImage")
                            .withMarshaller(new GetImageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImageRequest));
            CompletableFuture<GetImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     *
     * @param getImagePipelineRequest
     * @return A Java Future containing the result of the GetImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImagePipelineResponse> getImagePipeline(GetImagePipelineRequest getImagePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImagePipelineRequest, GetImagePipelineResponse>()
                            .withOperationName("GetImagePipeline")
                            .withMarshaller(new GetImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImagePipelineRequest));
            CompletableFuture<GetImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     *
     * @param getImagePolicyRequest
     * @return A Java Future containing the result of the GetImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImagePolicyResponse> getImagePolicy(GetImagePolicyRequest getImagePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImagePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImagePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImagePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImagePolicyRequest, GetImagePolicyResponse>()
                            .withOperationName("GetImagePolicy")
                            .withMarshaller(new GetImagePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImagePolicyRequest));
            CompletableFuture<GetImagePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     *
     * @param getImageRecipeRequest
     * @return A Java Future containing the result of the GetImageRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImageRecipeResponse> getImageRecipe(GetImageRecipeRequest getImageRecipeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImageRecipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImageRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImageRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImageRecipeRequest, GetImageRecipeResponse>()
                            .withOperationName("GetImageRecipe")
                            .withMarshaller(new GetImageRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImageRecipeRequest));
            CompletableFuture<GetImageRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     *
     * @param getImageRecipePolicyRequest
     * @return A Java Future containing the result of the GetImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImageRecipePolicyResponse> getImageRecipePolicy(
            GetImageRecipePolicyRequest getImageRecipePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImageRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImageRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImageRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImageRecipePolicyRequest, GetImageRecipePolicyResponse>()
                            .withOperationName("GetImageRecipePolicy")
                            .withMarshaller(new GetImageRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImageRecipePolicyRequest));
            CompletableFuture<GetImageRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        GetInfrastructureConfiguration request object.
     * @return A Java Future containing the result of the GetInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInfrastructureConfigurationResponse> getInfrastructureConfiguration(
            GetInfrastructureConfigurationRequest getInfrastructureConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInfrastructureConfigurationRequest, GetInfrastructureConfigurationResponse>()
                            .withOperationName("GetInfrastructureConfiguration")
                            .withMarshaller(new GetInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInfrastructureConfigurationRequest));
            CompletableFuture<GetInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow.
     * </p>
     *
     * @param getWorkflowExecutionRequest
     * @return A Java Future containing the result of the GetWorkflowExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetWorkflowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkflowExecutionResponse> getWorkflowExecution(
            GetWorkflowExecutionRequest getWorkflowExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWorkflowExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWorkflowExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkflowExecutionRequest, GetWorkflowExecutionResponse>()
                            .withOperationName("GetWorkflowExecution")
                            .withMarshaller(new GetWorkflowExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorkflowExecutionRequest));
            CompletableFuture<GetWorkflowExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow step.
     * </p>
     *
     * @param getWorkflowStepExecutionRequest
     * @return A Java Future containing the result of the GetWorkflowStepExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.GetWorkflowStepExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowStepExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkflowStepExecutionResponse> getWorkflowStepExecution(
            GetWorkflowStepExecutionRequest getWorkflowStepExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowStepExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowStepExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflowStepExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkflowStepExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWorkflowStepExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWorkflowStepExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkflowStepExecutionRequest, GetWorkflowStepExecutionResponse>()
                            .withOperationName("GetWorkflowStepExecution")
                            .withMarshaller(new GetWorkflowStepExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorkflowStepExecutionRequest));
            CompletableFuture<GetWorkflowStepExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     *
     * @param importComponentRequest
     * @return A Java Future containing the result of the ImportComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>InvalidVersionNumberException Your version number is out of bounds or does not follow the required
     *         syntax.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportComponentResponse> importComponent(ImportComponentRequest importComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportComponentRequest, ImportComponentResponse>()
                            .withOperationName("ImportComponent")
                            .withMarshaller(new ImportComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importComponentRequest));
            CompletableFuture<ImportComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one
     * or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2
     * API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action
     * uses those files to import your VM and create an AMI. To import using the CLI command, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a>
     * </p>
     * <p>
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for
     * your Image Builder recipe.
     * </p>
     *
     * @param importVmImageRequest
     * @return A Java Future containing the result of the ImportVmImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ImportVmImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportVmImageResponse> importVmImage(ImportVmImageRequest importVmImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importVmImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importVmImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportVmImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportVmImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportVmImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportVmImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportVmImageRequest, ImportVmImageResponse>()
                            .withOperationName("ImportVmImage")
                            .withMarshaller(new ImportVmImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importVmImageRequest));
            CompletableFuture<ImportVmImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified semantic version.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentBuildVersionsRequest
     * @return A Java Future containing the result of the ListComponentBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComponentBuildVersionsResponse> listComponentBuildVersions(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComponentBuildVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponentBuildVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComponentBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComponentBuildVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListComponentBuildVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComponentBuildVersionsRequest, ListComponentBuildVersionsResponse>()
                            .withOperationName("ListComponentBuildVersions")
                            .withMarshaller(new ListComponentBuildVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listComponentBuildVersionsRequest));
            CompletableFuture<ListComponentBuildVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to
     * streamline results. Newly created components can take up to two minutes to appear in the ListComponents API
     * Results.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComponentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComponentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListComponentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComponentsRequest, ListComponentsResponse>()
                            .withOperationName("ListComponents")
                            .withMarshaller(new ListComponentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listComponentsRequest));
            CompletableFuture<ListComponentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return A Java Future containing the result of the ListContainerRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContainerRecipesResponse> listContainerRecipes(
            ListContainerRecipesRequest listContainerRecipesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContainerRecipesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContainerRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerRecipes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContainerRecipesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListContainerRecipesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContainerRecipesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContainerRecipesRequest, ListContainerRecipesResponse>()
                            .withOperationName("ListContainerRecipes")
                            .withMarshaller(new ListContainerRecipesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContainerRecipesRequest));
            CompletableFuture<ListContainerRecipesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return A Java Future containing the result of the ListDistributionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionConfigurationsResponse> listDistributionConfigurations(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDistributionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDistributionConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDistributionConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionConfigurationsRequest, ListDistributionConfigurationsResponse>()
                            .withOperationName("ListDistributionConfigurations")
                            .withMarshaller(new ListDistributionConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionConfigurationsRequest));
            CompletableFuture<ListDistributionConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return A Java Future containing the result of the ListImageBuildVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageBuildVersionsResponse> listImageBuildVersions(
            ListImageBuildVersionsRequest listImageBuildVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageBuildVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageBuildVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImageBuildVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageBuildVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageBuildVersionsRequest, ListImageBuildVersionsResponse>()
                            .withOperationName("ListImageBuildVersions")
                            .withMarshaller(new ListImageBuildVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImageBuildVersionsRequest));
            CompletableFuture<ListImageBuildVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     *
     * @param listImagePackagesRequest
     * @return A Java Future containing the result of the ListImagePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagePackagesResponse> listImagePackages(ListImagePackagesRequest listImagePackagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagePackagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePackages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagePackagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImagePackagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagePackagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagePackagesRequest, ListImagePackagesResponse>()
                            .withOperationName("ListImagePackages")
                            .withMarshaller(new ListImagePackagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImagePackagesRequest));
            CompletableFuture<ListImagePackagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return A Java Future containing the result of the ListImagePipelineImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagePipelineImagesResponse> listImagePipelineImages(
            ListImagePipelineImagesRequest listImagePipelineImagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagePipelineImagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelineImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelineImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagePipelineImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImagePipelineImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagePipelineImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagePipelineImagesRequest, ListImagePipelineImagesResponse>()
                            .withOperationName("ListImagePipelineImages")
                            .withMarshaller(new ListImagePipelineImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImagePipelineImagesRequest));
            CompletableFuture<ListImagePipelineImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return A Java Future containing the result of the ListImagePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagePipelinesResponse> listImagePipelines(ListImagePipelinesRequest listImagePipelinesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagePipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagePipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImagePipelinesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagePipelinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagePipelinesRequest, ListImagePipelinesResponse>()
                            .withOperationName("ListImagePipelines")
                            .withMarshaller(new ListImagePipelinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImagePipelinesRequest));
            CompletableFuture<ListImagePipelinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     *
     * @param listImageRecipesRequest
     * @return A Java Future containing the result of the ListImageRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageRecipesResponse> listImageRecipes(ListImageRecipesRequest listImageRecipesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageRecipesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageRecipes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageRecipesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImageRecipesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageRecipesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageRecipesRequest, ListImageRecipesResponse>()
                            .withOperationName("ListImageRecipes")
                            .withMarshaller(new ListImageRecipesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImageRecipesRequest));
            CompletableFuture<ListImageRecipesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder
     * uses to group results. For example, if you want to get a list of findings by severity level for one of your
     * pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don't specify a
     * filter, Image Builder returns an aggregation for your account.
     * </p>
     * <p>
     * To streamline results, you can use the following filters in your request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accountId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imageBuildVersionArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imagePipelineArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vulnerabilityId</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param listImageScanFindingAggregationsRequest
     * @return A Java Future containing the result of the ListImageScanFindingAggregations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageScanFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageScanFindingAggregationsResponse> listImageScanFindingAggregations(
            ListImageScanFindingAggregationsRequest listImageScanFindingAggregationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageScanFindingAggregationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listImageScanFindingAggregationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageScanFindingAggregations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageScanFindingAggregationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListImageScanFindingAggregationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageScanFindingAggregationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageScanFindingAggregationsRequest, ListImageScanFindingAggregationsResponse>()
                            .withOperationName("ListImageScanFindingAggregations")
                            .withMarshaller(new ListImageScanFindingAggregationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImageScanFindingAggregationsRequest));
            CompletableFuture<ListImageScanFindingAggregationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of image scan findings for your account.
     * </p>
     *
     * @param listImageScanFindingsRequest
     * @return A Java Future containing the result of the ListImageScanFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageScanFindingsResponse> listImageScanFindings(
            ListImageScanFindingsRequest listImageScanFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageScanFindingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageScanFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageScanFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageScanFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImageScanFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageScanFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageScanFindingsRequest, ListImageScanFindingsResponse>()
                            .withOperationName("ListImageScanFindings")
                            .withMarshaller(new ListImageScanFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImageScanFindingsRequest));
            CompletableFuture<ListImageScanFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in
     * the ListImages API Results.
     * </p>
     *
     * @param listImagesRequest
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagesResponse> listImages(ListImagesRequest listImagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagesRequest, ListImagesResponse>().withOperationName("ListImages")
                            .withMarshaller(new ListImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImagesRequest));
            CompletableFuture<ListImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return A Java Future containing the result of the ListInfrastructureConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInfrastructureConfigurationsResponse> listInfrastructureConfigurations(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInfrastructureConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listInfrastructureConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInfrastructureConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInfrastructureConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListInfrastructureConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInfrastructureConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInfrastructureConfigurationsRequest, ListInfrastructureConfigurationsResponse>()
                            .withOperationName("ListInfrastructureConfigurations")
                            .withMarshaller(new ListInfrastructureConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInfrastructureConfigurationsRequest));
            CompletableFuture<ListInfrastructureConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     * </p>
     *
     * @param listWorkflowExecutionsRequest
     * @return A Java Future containing the result of the ListWorkflowExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListWorkflowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkflowExecutionsResponse> listWorkflowExecutions(
            ListWorkflowExecutionsRequest listWorkflowExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkflowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkflowExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorkflowExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowExecutionsRequest, ListWorkflowExecutionsResponse>()
                            .withOperationName("ListWorkflowExecutions")
                            .withMarshaller(new ListWorkflowExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkflowExecutionsRequest));
            CompletableFuture<ListWorkflowExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shows runtime data for each step in a runtime instance of the workflow that you specify in the request.
     * </p>
     *
     * @param listWorkflowStepExecutionsRequest
     * @return A Java Future containing the result of the ListWorkflowStepExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidPaginationTokenException You have provided an invalid pagination token in your request.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.ListWorkflowStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkflowStepExecutionsResponse> listWorkflowStepExecutions(
            ListWorkflowStepExecutionsRequest listWorkflowStepExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowStepExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowStepExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowStepExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkflowStepExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkflowStepExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorkflowStepExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowStepExecutionsRequest, ListWorkflowStepExecutionsResponse>()
                            .withOperationName("ListWorkflowStepExecutions")
                            .withMarshaller(new ListWorkflowStepExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkflowStepExecutionsRequest));
            CompletableFuture<ListWorkflowStepExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putComponentPolicyRequest
     * @return A Java Future containing the result of the PutComponentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutComponentPolicyResponse> putComponentPolicy(PutComponentPolicyRequest putComponentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putComponentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutComponentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutComponentPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutComponentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutComponentPolicyRequest, PutComponentPolicyResponse>()
                            .withOperationName("PutComponentPolicy")
                            .withMarshaller(new PutComponentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putComponentPolicyRequest));
            CompletableFuture<PutComponentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order
     * for the resource to be visible to all principals with whom the resource is shared.
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     * @return A Java Future containing the result of the PutContainerRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutContainerRecipePolicyResponse> putContainerRecipePolicy(
            PutContainerRecipePolicyRequest putContainerRecipePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putContainerRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutContainerRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutContainerRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutContainerRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutContainerRecipePolicyRequest, PutContainerRecipePolicyResponse>()
                            .withOperationName("PutContainerRecipePolicy")
                            .withMarshaller(new PutContainerRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putContainerRecipePolicyRequest));
            CompletableFuture<PutContainerRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putImagePolicyRequest
     * @return A Java Future containing the result of the PutImagePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutImagePolicyResponse> putImagePolicy(PutImagePolicyRequest putImagePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putImagePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImagePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutImagePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutImagePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutImagePolicyRequest, PutImagePolicyResponse>()
                            .withOperationName("PutImagePolicy")
                            .withMarshaller(new PutImagePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putImagePolicyRequest));
            CompletableFuture<PutImagePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     *
     * @param putImageRecipePolicyRequest
     * @return A Java Future containing the result of the PutImageRecipePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>InvalidParameterValueException The value that you provided for the specified parameter is invalid.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutImageRecipePolicyResponse> putImageRecipePolicy(
            PutImageRecipePolicyRequest putImageRecipePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putImageRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImageRecipePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutImageRecipePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutImageRecipePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutImageRecipePolicyRequest, PutImageRecipePolicyResponse>()
                            .withOperationName("PutImageRecipePolicy")
                            .withMarshaller(new PutImageRecipePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putImageRecipePolicyRequest));
            CompletableFuture<PutImageRecipePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     * @return A Java Future containing the result of the StartImagePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartImagePipelineExecutionResponse> startImagePipelineExecution(
            StartImagePipelineExecutionRequest startImagePipelineExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImagePipelineExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImagePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImagePipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartImagePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartImagePipelineExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartImagePipelineExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartImagePipelineExecutionRequest, StartImagePipelineExecutionResponse>()
                            .withOperationName("StartImagePipelineExecution")
                            .withMarshaller(new StartImagePipelineExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startImagePipelineExecutionRequest));
            CompletableFuture<StartImagePipelineExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ResourceNotFoundException At least one of the resources referenced by your request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     * @return A Java Future containing the result of the UpdateDistributionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>InvalidParameterCombinationException You have specified two or more mutually exclusive parameters.
     *         Review the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDistributionConfigurationResponse> updateDistributionConfiguration(
            UpdateDistributionConfigurationRequest updateDistributionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDistributionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDistributionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionConfigurationRequest, UpdateDistributionConfigurationResponse>()
                            .withOperationName("UpdateDistributionConfiguration")
                            .withMarshaller(new UpdateDistributionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDistributionConfigurationRequest));
            CompletableFuture<UpdateDistributionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note>
     *
     * @param updateImagePipelineRequest
     * @return A Java Future containing the result of the UpdateImagePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateImagePipelineResponse> updateImagePipeline(
            UpdateImagePipelineRequest updateImagePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateImagePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateImagePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateImagePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateImagePipelineRequest, UpdateImagePipelineResponse>()
                            .withOperationName("UpdateImagePipeline")
                            .withMarshaller(new UpdateImagePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateImagePipelineRequest));
            CompletableFuture<UpdateImagePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     * @return A Java Future containing the result of the UpdateInfrastructureConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException This exception is thrown when the service encounters an unrecoverable exception.</li>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permissions to use the action or resource, or specifying
     *         an invalid resource identifier.</li>
     *         <li>ServiceUnavailableException The service is unable to process your request at this time.</li>
     *         <li>InvalidRequestException You have requested an action that that the service doesn't support.</li>
     *         <li>IdempotentParameterMismatchException You have specified a client token for an operation using
     *         parameter values that differ from a previous request that used the same client token.</li>
     *         <li>ForbiddenException You are not authorized to perform the requested operation.</li>
     *         <li>CallRateLimitExceededException You have exceeded the permitted request rate for the specific
     *         operation.</li>
     *         <li>ResourceInUseException The resource that you are trying to operate on is currently in use. Review the
     *         message details and retry later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ImagebuilderException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ImagebuilderAsyncClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInfrastructureConfigurationResponse> updateInfrastructureConfiguration(
            UpdateInfrastructureConfigurationRequest updateInfrastructureConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInfrastructureConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInfrastructureConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateInfrastructureConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInfrastructureConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInfrastructureConfigurationRequest, UpdateInfrastructureConfigurationResponse>()
                            .withOperationName("UpdateInfrastructureConfiguration")
                            .withMarshaller(new UpdateInfrastructureConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateInfrastructureConfigurationRequest));
            CompletableFuture<UpdateInfrastructureConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ImagebuilderServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ImagebuilderException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVersionNumberException")
                                .exceptionBuilderSupplier(InvalidVersionNumberException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientException")
                                .exceptionBuilderSupplier(ClientException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDependencyException")
                                .exceptionBuilderSupplier(ResourceDependencyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CallRateLimitExceededException")
                                .exceptionBuilderSupplier(CallRateLimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        ImagebuilderServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = ImagebuilderServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
