/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a parameter that is used to provide configuration details for the component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentParameterDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentParameterDetail.Builder, ComponentParameterDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ComponentParameterDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ComponentParameterDetail::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> DEFAULT_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("defaultValue")
            .getter(getter(ComponentParameterDetail::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ComponentParameterDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final List<String> defaultValue;

    private final String description;

    private ComponentParameterDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of this input parameter.
     * </p>
     * 
     * @return The name of this input parameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of input this parameter provides. The currently supported value is "string".
     * </p>
     * 
     * @return The type of input this parameter provides. The currently supported value is "string".
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultValue() {
        return defaultValue != null && !(defaultValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default value of this parameter if no input is provided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultValue} method.
     * </p>
     * 
     * @return The default value of this parameter if no input is provided.
     */
    public final List<String> defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * Describes this parameter.
     * </p>
     * 
     * @return Describes this parameter.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultValue() ? defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentParameterDetail)) {
            return false;
        }
        ComponentParameterDetail other = (ComponentParameterDetail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && hasDefaultValue() == other.hasDefaultValue() && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentParameterDetail").add("Name", name()).add("Type", type())
                .add("DefaultValue", hasDefaultValue() ? defaultValue() : null).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentParameterDetail, T> g) {
        return obj -> g.apply((ComponentParameterDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentParameterDetail> {
        /**
         * <p>
         * The name of this input parameter.
         * </p>
         * 
         * @param name
         *        The name of this input parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of input this parameter provides. The currently supported value is "string".
         * </p>
         * 
         * @param type
         *        The type of input this parameter provides. The currently supported value is "string".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The default value of this parameter if no input is provided.
         * </p>
         * 
         * @param defaultValue
         *        The default value of this parameter if no input is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Collection<String> defaultValue);

        /**
         * <p>
         * The default value of this parameter if no input is provided.
         * </p>
         * 
         * @param defaultValue
         *        The default value of this parameter if no input is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String... defaultValue);

        /**
         * <p>
         * Describes this parameter.
         * </p>
         * 
         * @param description
         *        Describes this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private List<String> defaultValue = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentParameterDetail model) {
            name(model.name);
            type(model.type);
            defaultValue(model.defaultValue);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getDefaultValue() {
            if (defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultValue;
        }

        public final void setDefaultValue(Collection<String> defaultValue) {
            this.defaultValue = ComponentParameterValueListCopier.copy(defaultValue);
        }

        @Override
        public final Builder defaultValue(Collection<String> defaultValue) {
            this.defaultValue = ComponentParameterValueListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValue(String... defaultValue) {
            defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ComponentParameterDetail build() {
            return new ComponentParameterDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
