/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLifecyclePolicyRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<UpdateLifecyclePolicyRequest.Builder, UpdateLifecyclePolicyRequest> {
    private static final SdkField<String> LIFECYCLE_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecyclePolicyArn").getter(getter(UpdateLifecyclePolicyRequest::lifecyclePolicyArn))
            .setter(setter(Builder::lifecyclePolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyArn").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateLifecyclePolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateLifecyclePolicyRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(UpdateLifecyclePolicyRequest::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(UpdateLifecyclePolicyRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<LifecyclePolicyDetail>> POLICY_DETAILS_FIELD = SdkField
            .<List<LifecyclePolicyDetail>> builder(MarshallingType.LIST)
            .memberName("policyDetails")
            .getter(getter(UpdateLifecyclePolicyRequest::policyDetails))
            .setter(setter(Builder::policyDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LifecyclePolicyResourceSelection> RESOURCE_SELECTION_FIELD = SdkField
            .<LifecyclePolicyResourceSelection> builder(MarshallingType.SDK_POJO).memberName("resourceSelection")
            .getter(getter(UpdateLifecyclePolicyRequest::resourceSelection)).setter(setter(Builder::resourceSelection))
            .constructor(LifecyclePolicyResourceSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSelection").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateLifecyclePolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_ARN_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, EXECUTION_ROLE_FIELD, RESOURCE_TYPE_FIELD, POLICY_DETAILS_FIELD,
            RESOURCE_SELECTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String lifecyclePolicyArn;

    private final String description;

    private final String status;

    private final String executionRole;

    private final String resourceType;

    private final List<LifecyclePolicyDetail> policyDetails;

    private final LifecyclePolicyResourceSelection resourceSelection;

    private final String clientToken;

    private UpdateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicyArn = builder.lifecyclePolicyArn;
        this.description = builder.description;
        this.status = builder.status;
        this.executionRole = builder.executionRole;
        this.resourceType = builder.resourceType;
        this.policyDetails = builder.policyDetails;
        this.resourceSelection = builder.resourceSelection;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle policy resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle policy resource.
     */
    public final String lifecyclePolicyArn() {
        return lifecyclePolicyArn;
    }

    /**
     * <p>
     * Optional description for the lifecycle policy.
     * </p>
     * 
     * @return Optional description for the lifecycle policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the lifecycle policy resource is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether the lifecycle policy resource is enabled.
     * @see LifecyclePolicyStatus
     */
    public final LifecyclePolicyStatus status() {
        return LifecyclePolicyStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether the lifecycle policy resource is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether the lifecycle policy resource is enabled.
     * @see LifecyclePolicyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the IAM role that Image Builder should use to update the lifecycle policy.
     * </p>
     * 
     * @return The name of the IAM role that Image Builder should use to update the lifecycle policy.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The type of image resource that the lifecycle policy applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LifecyclePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of image resource that the lifecycle policy applies to.
     * @see LifecyclePolicyResourceType
     */
    public final LifecyclePolicyResourceType resourceType() {
        return LifecyclePolicyResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of image resource that the lifecycle policy applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LifecyclePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of image resource that the lifecycle policy applies to.
     * @see LifecyclePolicyResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyDetails() {
        return policyDetails != null && !(policyDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration details for a lifecycle policy resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyDetails} method.
     * </p>
     * 
     * @return The configuration details for a lifecycle policy resource.
     */
    public final List<LifecyclePolicyDetail> policyDetails() {
        return policyDetails;
    }

    /**
     * <p>
     * Selection criteria for resources that the lifecycle policy applies to.
     * </p>
     * 
     * @return Selection criteria for resources that the lifecycle policy applies to.
     */
    public final LifecyclePolicyResourceSelection resourceSelection() {
        return resourceSelection;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyDetails() ? policyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceSelection());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLifecyclePolicyRequest)) {
            return false;
        }
        UpdateLifecyclePolicyRequest other = (UpdateLifecyclePolicyRequest) obj;
        return Objects.equals(lifecyclePolicyArn(), other.lifecyclePolicyArn())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasPolicyDetails() == other.hasPolicyDetails() && Objects.equals(policyDetails(), other.policyDetails())
                && Objects.equals(resourceSelection(), other.resourceSelection())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLifecyclePolicyRequest").add("LifecyclePolicyArn", lifecyclePolicyArn())
                .add("Description", description()).add("Status", statusAsString()).add("ExecutionRole", executionRole())
                .add("ResourceType", resourceTypeAsString()).add("PolicyDetails", hasPolicyDetails() ? policyDetails() : null)
                .add("ResourceSelection", resourceSelection()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecyclePolicyArn":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "policyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "resourceSelection":
            return Optional.ofNullable(clazz.cast(resourceSelection()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((UpdateLifecyclePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLifecyclePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle policy resource.
         * </p>
         * 
         * @param lifecyclePolicyArn
         *        The Amazon Resource Name (ARN) of the lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyArn(String lifecyclePolicyArn);

        /**
         * <p>
         * Optional description for the lifecycle policy.
         * </p>
         * 
         * @param description
         *        Optional description for the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the lifecycle policy resource is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether the lifecycle policy resource is enabled.
         * @see LifecyclePolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether the lifecycle policy resource is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether the lifecycle policy resource is enabled.
         * @see LifecyclePolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyStatus
         */
        Builder status(LifecyclePolicyStatus status);

        /**
         * <p>
         * The name of the IAM role that Image Builder should use to update the lifecycle policy.
         * </p>
         * 
         * @param executionRole
         *        The name of the IAM role that Image Builder should use to update the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The type of image resource that the lifecycle policy applies to.
         * </p>
         * 
         * @param resourceType
         *        The type of image resource that the lifecycle policy applies to.
         * @see LifecyclePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of image resource that the lifecycle policy applies to.
         * </p>
         * 
         * @param resourceType
         *        The type of image resource that the lifecycle policy applies to.
         * @see LifecyclePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyResourceType
         */
        Builder resourceType(LifecyclePolicyResourceType resourceType);

        /**
         * <p>
         * The configuration details for a lifecycle policy resource.
         * </p>
         * 
         * @param policyDetails
         *        The configuration details for a lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails);

        /**
         * <p>
         * The configuration details for a lifecycle policy resource.
         * </p>
         * 
         * @param policyDetails
         *        The configuration details for a lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(LifecyclePolicyDetail... policyDetails);

        /**
         * <p>
         * The configuration details for a lifecycle policy resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDetails(List<LifecyclePolicyDetail>)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(java.util.Collection<LifecyclePolicyDetail>)
         */
        Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder>... policyDetails);

        /**
         * <p>
         * Selection criteria for resources that the lifecycle policy applies to.
         * </p>
         * 
         * @param resourceSelection
         *        Selection criteria for resources that the lifecycle policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection);

        /**
         * <p>
         * Selection criteria for resources that the lifecycle policy applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyResourceSelection.Builder}
         * avoiding the need to create one manually via {@link LifecyclePolicyResourceSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyResourceSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSelection(LifecyclePolicyResourceSelection)}.
         * 
         * @param resourceSelection
         *        a consumer that will call methods on {@link LifecyclePolicyResourceSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSelection(LifecyclePolicyResourceSelection)
         */
        default Builder resourceSelection(Consumer<LifecyclePolicyResourceSelection.Builder> resourceSelection) {
            return resourceSelection(LifecyclePolicyResourceSelection.builder().applyMutation(resourceSelection).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String lifecyclePolicyArn;

        private String description;

        private String status;

        private String executionRole;

        private String resourceType;

        private List<LifecyclePolicyDetail> policyDetails = DefaultSdkAutoConstructList.getInstance();

        private LifecyclePolicyResourceSelection resourceSelection;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLifecyclePolicyRequest model) {
            super(model);
            lifecyclePolicyArn(model.lifecyclePolicyArn);
            description(model.description);
            status(model.status);
            executionRole(model.executionRole);
            resourceType(model.resourceType);
            policyDetails(model.policyDetails);
            resourceSelection(model.resourceSelection);
            clientToken(model.clientToken);
        }

        public final String getLifecyclePolicyArn() {
            return lifecyclePolicyArn;
        }

        public final void setLifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
        }

        @Override
        public final Builder lifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LifecyclePolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<LifecyclePolicyDetail.Builder> getPolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.policyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(policyDetails);
        }

        @Override
        public final Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copy(policyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(LifecyclePolicyDetail... policyDetails) {
            policyDetails(Arrays.asList(policyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder>... policyDetails) {
            policyDetails(Stream.of(policyDetails).map(c -> LifecyclePolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LifecyclePolicyResourceSelection.Builder getResourceSelection() {
            return resourceSelection != null ? resourceSelection.toBuilder() : null;
        }

        public final void setResourceSelection(LifecyclePolicyResourceSelection.BuilderImpl resourceSelection) {
            this.resourceSelection = resourceSelection != null ? resourceSelection.build() : null;
        }

        @Override
        public final Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLifecyclePolicyRequest build() {
            return new UpdateLifecyclePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
