/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an image resource that was identified for a lifecycle action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecycleExecutionResourcesImpactedSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecycleExecutionResourcesImpactedSummary.Builder, LifecycleExecutionResourcesImpactedSummary> {
    private static final SdkField<Boolean> HAS_IMPACTED_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasImpactedResources").getter(getter(LifecycleExecutionResourcesImpactedSummary::hasImpactedResources))
            .setter(setter(Builder::hasImpactedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasImpactedResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAS_IMPACTED_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean hasImpactedResources;

    private LifecycleExecutionResourcesImpactedSummary(BuilderImpl builder) {
        this.hasImpactedResources = builder.hasImpactedResources;
    }

    /**
     * <p>
     * Indicates whether an image resource that was identified for a lifecycle action has associated resources that are
     * also impacted.
     * </p>
     * 
     * @return Indicates whether an image resource that was identified for a lifecycle action has associated resources
     *         that are also impacted.
     */
    public final Boolean hasImpactedResources() {
        return hasImpactedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecutionResourcesImpactedSummary)) {
            return false;
        }
        LifecycleExecutionResourcesImpactedSummary other = (LifecycleExecutionResourcesImpactedSummary) obj;
        return Objects.equals(hasImpactedResources(), other.hasImpactedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecycleExecutionResourcesImpactedSummary").add("HasImpactedResources", hasImpactedResources())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hasImpactedResources":
            return Optional.ofNullable(clazz.cast(hasImpactedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleExecutionResourcesImpactedSummary, T> g) {
        return obj -> g.apply((LifecycleExecutionResourcesImpactedSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecycleExecutionResourcesImpactedSummary> {
        /**
         * <p>
         * Indicates whether an image resource that was identified for a lifecycle action has associated resources that
         * are also impacted.
         * </p>
         * 
         * @param hasImpactedResources
         *        Indicates whether an image resource that was identified for a lifecycle action has associated
         *        resources that are also impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasImpactedResources(Boolean hasImpactedResources);
    }

    static final class BuilderImpl implements Builder {
        private Boolean hasImpactedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExecutionResourcesImpactedSummary model) {
            hasImpactedResources(model.hasImpactedResources);
        }

        public final Boolean getHasImpactedResources() {
            return hasImpactedResources;
        }

        public final void setHasImpactedResources(Boolean hasImpactedResources) {
            this.hasImpactedResources = hasImpactedResources;
        }

        @Override
        public final Builder hasImpactedResources(Boolean hasImpactedResources) {
            this.hasImpactedResources = hasImpactedResources;
            return this;
        }

        @Override
        public LifecycleExecutionResourcesImpactedSummary build() {
            return new LifecycleExecutionResourcesImpactedSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
