/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartResourceStateUpdateRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<StartResourceStateUpdateRequest.Builder, StartResourceStateUpdateRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(StartResourceStateUpdateRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<ResourceState> STATE_FIELD = SdkField.<ResourceState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(StartResourceStateUpdateRequest::state)).setter(setter(Builder::state))
            .constructor(ResourceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(StartResourceStateUpdateRequest::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<ResourceStateUpdateIncludeResources> INCLUDE_RESOURCES_FIELD = SdkField
            .<ResourceStateUpdateIncludeResources> builder(MarshallingType.SDK_POJO).memberName("includeResources")
            .getter(getter(StartResourceStateUpdateRequest::includeResources)).setter(setter(Builder::includeResources))
            .constructor(ResourceStateUpdateIncludeResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResources").build()).build();

    private static final SdkField<ResourceStateUpdateExclusionRules> EXCLUSION_RULES_FIELD = SdkField
            .<ResourceStateUpdateExclusionRules> builder(MarshallingType.SDK_POJO).memberName("exclusionRules")
            .getter(getter(StartResourceStateUpdateRequest::exclusionRules)).setter(setter(Builder::exclusionRules))
            .constructor(ResourceStateUpdateExclusionRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionRules").build()).build();

    private static final SdkField<Instant> UPDATE_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateAt").getter(getter(StartResourceStateUpdateRequest::updateAt)).setter(setter(Builder::updateAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateAt").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartResourceStateUpdateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            STATE_FIELD, EXECUTION_ROLE_FIELD, INCLUDE_RESOURCES_FIELD, EXCLUSION_RULES_FIELD, UPDATE_AT_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String resourceArn;

    private final ResourceState state;

    private final String executionRole;

    private final ResourceStateUpdateIncludeResources includeResources;

    private final ResourceStateUpdateExclusionRules exclusionRules;

    private final Instant updateAt;

    private final String clientToken;

    private StartResourceStateUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.state = builder.state;
        this.executionRole = builder.executionRole;
        this.includeResources = builder.includeResources;
        this.exclusionRules = builder.exclusionRules;
        this.updateAt = builder.updateAt;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ARN of the Image Builder resource that is updated. The state update might also impact associated resources.
     * </p>
     * 
     * @return The ARN of the Image Builder resource that is updated. The state update might also impact associated
     *         resources.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Indicates the lifecycle action to take for this request.
     * </p>
     * 
     * @return Indicates the lifecycle action to take for this request.
     */
    public final ResourceState state() {
        return state;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role that’s used to update image state.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role that’s used to update image state.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * A list of image resources to update state for.
     * </p>
     * 
     * @return A list of image resources to update state for.
     */
    public final ResourceStateUpdateIncludeResources includeResources() {
        return includeResources;
    }

    /**
     * <p>
     * Skip action on the image resource and associated resources if specified exclusion rules are met.
     * </p>
     * 
     * @return Skip action on the image resource and associated resources if specified exclusion rules are met.
     */
    public final ResourceStateUpdateExclusionRules exclusionRules() {
        return exclusionRules;
    }

    /**
     * <p>
     * The timestamp that indicates when resources are updated by a lifecycle action.
     * </p>
     * 
     * @return The timestamp that indicates when resources are updated by a lifecycle action.
     */
    public final Instant updateAt() {
        return updateAt;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(includeResources());
        hashCode = 31 * hashCode + Objects.hashCode(exclusionRules());
        hashCode = 31 * hashCode + Objects.hashCode(updateAt());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceStateUpdateRequest)) {
            return false;
        }
        StartResourceStateUpdateRequest other = (StartResourceStateUpdateRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(state(), other.state())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(includeResources(), other.includeResources())
                && Objects.equals(exclusionRules(), other.exclusionRules()) && Objects.equals(updateAt(), other.updateAt())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartResourceStateUpdateRequest").add("ResourceArn", resourceArn()).add("State", state())
                .add("ExecutionRole", executionRole()).add("IncludeResources", includeResources())
                .add("ExclusionRules", exclusionRules()).add("UpdateAt", updateAt()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "includeResources":
            return Optional.ofNullable(clazz.cast(includeResources()));
        case "exclusionRules":
            return Optional.ofNullable(clazz.cast(exclusionRules()));
        case "updateAt":
            return Optional.ofNullable(clazz.cast(updateAt()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartResourceStateUpdateRequest, T> g) {
        return obj -> g.apply((StartResourceStateUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartResourceStateUpdateRequest> {
        /**
         * <p>
         * The ARN of the Image Builder resource that is updated. The state update might also impact associated
         * resources.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the Image Builder resource that is updated. The state update might also impact associated
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Indicates the lifecycle action to take for this request.
         * </p>
         * 
         * @param state
         *        Indicates the lifecycle action to take for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ResourceState state);

        /**
         * <p>
         * Indicates the lifecycle action to take for this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceState.Builder} avoiding the need
         * to create one manually via {@link ResourceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(ResourceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ResourceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ResourceState)
         */
        default Builder state(Consumer<ResourceState.Builder> state) {
            return state(ResourceState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role that’s used to update image state.
         * </p>
         * 
         * @param executionRole
         *        The name or Amazon Resource Name (ARN) of the IAM role that’s used to update image state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * A list of image resources to update state for.
         * </p>
         * 
         * @param includeResources
         *        A list of image resources to update state for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResources(ResourceStateUpdateIncludeResources includeResources);

        /**
         * <p>
         * A list of image resources to update state for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResourceStateUpdateIncludeResources.Builder} avoiding the need to create one manually via
         * {@link ResourceStateUpdateIncludeResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceStateUpdateIncludeResources.Builder#build()} is called
         * immediately and its result is passed to {@link #includeResources(ResourceStateUpdateIncludeResources)}.
         * 
         * @param includeResources
         *        a consumer that will call methods on {@link ResourceStateUpdateIncludeResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includeResources(ResourceStateUpdateIncludeResources)
         */
        default Builder includeResources(Consumer<ResourceStateUpdateIncludeResources.Builder> includeResources) {
            return includeResources(ResourceStateUpdateIncludeResources.builder().applyMutation(includeResources).build());
        }

        /**
         * <p>
         * Skip action on the image resource and associated resources if specified exclusion rules are met.
         * </p>
         * 
         * @param exclusionRules
         *        Skip action on the image resource and associated resources if specified exclusion rules are met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionRules(ResourceStateUpdateExclusionRules exclusionRules);

        /**
         * <p>
         * Skip action on the image resource and associated resources if specified exclusion rules are met.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResourceStateUpdateExclusionRules.Builder} avoiding the need to create one manually via
         * {@link ResourceStateUpdateExclusionRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceStateUpdateExclusionRules.Builder#build()} is called
         * immediately and its result is passed to {@link #exclusionRules(ResourceStateUpdateExclusionRules)}.
         * 
         * @param exclusionRules
         *        a consumer that will call methods on {@link ResourceStateUpdateExclusionRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusionRules(ResourceStateUpdateExclusionRules)
         */
        default Builder exclusionRules(Consumer<ResourceStateUpdateExclusionRules.Builder> exclusionRules) {
            return exclusionRules(ResourceStateUpdateExclusionRules.builder().applyMutation(exclusionRules).build());
        }

        /**
         * <p>
         * The timestamp that indicates when resources are updated by a lifecycle action.
         * </p>
         * 
         * @param updateAt
         *        The timestamp that indicates when resources are updated by a lifecycle action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateAt(Instant updateAt);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private ResourceState state;

        private String executionRole;

        private ResourceStateUpdateIncludeResources includeResources;

        private ResourceStateUpdateExclusionRules exclusionRules;

        private Instant updateAt;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceStateUpdateRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            state(model.state);
            executionRole(model.executionRole);
            includeResources(model.includeResources);
            exclusionRules(model.exclusionRules);
            updateAt(model.updateAt);
            clientToken(model.clientToken);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ResourceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ResourceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ResourceState state) {
            this.state = state;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final ResourceStateUpdateIncludeResources.Builder getIncludeResources() {
            return includeResources != null ? includeResources.toBuilder() : null;
        }

        public final void setIncludeResources(ResourceStateUpdateIncludeResources.BuilderImpl includeResources) {
            this.includeResources = includeResources != null ? includeResources.build() : null;
        }

        @Override
        public final Builder includeResources(ResourceStateUpdateIncludeResources includeResources) {
            this.includeResources = includeResources;
            return this;
        }

        public final ResourceStateUpdateExclusionRules.Builder getExclusionRules() {
            return exclusionRules != null ? exclusionRules.toBuilder() : null;
        }

        public final void setExclusionRules(ResourceStateUpdateExclusionRules.BuilderImpl exclusionRules) {
            this.exclusionRules = exclusionRules != null ? exclusionRules.build() : null;
        }

        @Override
        public final Builder exclusionRules(ResourceStateUpdateExclusionRules exclusionRules) {
            this.exclusionRules = exclusionRules;
            return this;
        }

        public final Instant getUpdateAt() {
            return updateAt;
        }

        public final void setUpdateAt(Instant updateAt) {
            this.updateAt = updateAt;
        }

        @Override
        public final Builder updateAt(Instant updateAt) {
            this.updateAt = updateAt;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartResourceStateUpdateRequest build() {
            return new StartResourceStateUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
