/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains selection criteria for the lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyDetailAction implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyDetailAction.Builder, LifecyclePolicyDetailAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LifecyclePolicyDetailAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<LifecyclePolicyDetailActionIncludeResources> INCLUDE_RESOURCES_FIELD = SdkField
            .<LifecyclePolicyDetailActionIncludeResources> builder(MarshallingType.SDK_POJO).memberName("includeResources")
            .getter(getter(LifecyclePolicyDetailAction::includeResources)).setter(setter(Builder::includeResources))
            .constructor(LifecyclePolicyDetailActionIncludeResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            INCLUDE_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final LifecyclePolicyDetailActionIncludeResources includeResources;

    private LifecyclePolicyDetailAction(BuilderImpl builder) {
        this.type = builder.type;
        this.includeResources = builder.includeResources;
    }

    /**
     * <p>
     * Specifies the lifecycle action to take.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyDetailActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the lifecycle action to take.
     * @see LifecyclePolicyDetailActionType
     */
    public final LifecyclePolicyDetailActionType type() {
        return LifecyclePolicyDetailActionType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the lifecycle action to take.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyDetailActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the lifecycle action to take.
     * @see LifecyclePolicyDetailActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the resources that the lifecycle policy applies to.
     * </p>
     * 
     * @return Specifies the resources that the lifecycle policy applies to.
     */
    public final LifecyclePolicyDetailActionIncludeResources includeResources() {
        return includeResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyDetailAction)) {
            return false;
        }
        LifecyclePolicyDetailAction other = (LifecyclePolicyDetailAction) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(includeResources(), other.includeResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyDetailAction").add("Type", typeAsString())
                .add("IncludeResources", includeResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "includeResources":
            return Optional.ofNullable(clazz.cast(includeResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyDetailAction, T> g) {
        return obj -> g.apply((LifecyclePolicyDetailAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyDetailAction> {
        /**
         * <p>
         * Specifies the lifecycle action to take.
         * </p>
         * 
         * @param type
         *        Specifies the lifecycle action to take.
         * @see LifecyclePolicyDetailActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyDetailActionType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the lifecycle action to take.
         * </p>
         * 
         * @param type
         *        Specifies the lifecycle action to take.
         * @see LifecyclePolicyDetailActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyDetailActionType
         */
        Builder type(LifecyclePolicyDetailActionType type);

        /**
         * <p>
         * Specifies the resources that the lifecycle policy applies to.
         * </p>
         * 
         * @param includeResources
         *        Specifies the resources that the lifecycle policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResources(LifecyclePolicyDetailActionIncludeResources includeResources);

        /**
         * <p>
         * Specifies the resources that the lifecycle policy applies to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LifecyclePolicyDetailActionIncludeResources.Builder} avoiding the need to create one manually via
         * {@link LifecyclePolicyDetailActionIncludeResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyDetailActionIncludeResources.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #includeResources(LifecyclePolicyDetailActionIncludeResources)}.
         * 
         * @param includeResources
         *        a consumer that will call methods on {@link LifecyclePolicyDetailActionIncludeResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includeResources(LifecyclePolicyDetailActionIncludeResources)
         */
        default Builder includeResources(Consumer<LifecyclePolicyDetailActionIncludeResources.Builder> includeResources) {
            return includeResources(LifecyclePolicyDetailActionIncludeResources.builder().applyMutation(includeResources).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private LifecyclePolicyDetailActionIncludeResources includeResources;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyDetailAction model) {
            type(model.type);
            includeResources(model.includeResources);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyDetailActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final LifecyclePolicyDetailActionIncludeResources.Builder getIncludeResources() {
            return includeResources != null ? includeResources.toBuilder() : null;
        }

        public final void setIncludeResources(LifecyclePolicyDetailActionIncludeResources.BuilderImpl includeResources) {
            this.includeResources = includeResources != null ? includeResources.build() : null;
        }

        @Override
        public final Builder includeResources(LifecyclePolicyDetailActionIncludeResources includeResources) {
            this.includeResources = includeResources;
            return this;
        }

        @Override
        public LifecyclePolicyDetailAction build() {
            return new LifecyclePolicyDetailAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
