/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional rules to specify resources that should be exempt from ad-hoc lifecycle actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceStateUpdateExclusionRules implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceStateUpdateExclusionRules.Builder, ResourceStateUpdateExclusionRules> {
    private static final SdkField<LifecyclePolicyDetailExclusionRulesAmis> AMIS_FIELD = SdkField
            .<LifecyclePolicyDetailExclusionRulesAmis> builder(MarshallingType.SDK_POJO).memberName("amis")
            .getter(getter(ResourceStateUpdateExclusionRules::amis)).setter(setter(Builder::amis))
            .constructor(LifecyclePolicyDetailExclusionRulesAmis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LifecyclePolicyDetailExclusionRulesAmis amis;

    private ResourceStateUpdateExclusionRules(BuilderImpl builder) {
        this.amis = builder.amis;
    }

    /**
     * Returns the value of the Amis property for this object.
     * 
     * @return The value of the Amis property for this object.
     */
    public final LifecyclePolicyDetailExclusionRulesAmis amis() {
        return amis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStateUpdateExclusionRules)) {
            return false;
        }
        ResourceStateUpdateExclusionRules other = (ResourceStateUpdateExclusionRules) obj;
        return Objects.equals(amis(), other.amis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceStateUpdateExclusionRules").add("Amis", amis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amis":
            return Optional.ofNullable(clazz.cast(amis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceStateUpdateExclusionRules, T> g) {
        return obj -> g.apply((ResourceStateUpdateExclusionRules) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceStateUpdateExclusionRules> {
        /**
         * Sets the value of the Amis property for this object.
         *
         * @param amis
         *        The new value for the Amis property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(LifecyclePolicyDetailExclusionRulesAmis amis);

        /**
         * Sets the value of the Amis property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link LifecyclePolicyDetailExclusionRulesAmis.Builder} avoiding the need to create one manually via
         * {@link LifecyclePolicyDetailExclusionRulesAmis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyDetailExclusionRulesAmis.Builder#build()} is
         * called immediately and its result is passed to {@link #amis(LifecyclePolicyDetailExclusionRulesAmis)}.
         * 
         * @param amis
         *        a consumer that will call methods on {@link LifecyclePolicyDetailExclusionRulesAmis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amis(LifecyclePolicyDetailExclusionRulesAmis)
         */
        default Builder amis(Consumer<LifecyclePolicyDetailExclusionRulesAmis.Builder> amis) {
            return amis(LifecyclePolicyDetailExclusionRulesAmis.builder().applyMutation(amis).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LifecyclePolicyDetailExclusionRulesAmis amis;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStateUpdateExclusionRules model) {
            amis(model.amis);
        }

        public final LifecyclePolicyDetailExclusionRulesAmis.Builder getAmis() {
            return amis != null ? amis.toBuilder() : null;
        }

        public final void setAmis(LifecyclePolicyDetailExclusionRulesAmis.BuilderImpl amis) {
            this.amis = amis != null ? amis.build() : null;
        }

        @Override
        public final Builder amis(LifecyclePolicyDetailExclusionRulesAmis amis) {
            this.amis = amis;
            return this;
        }

        @Override
        public ResourceStateUpdateExclusionRules build() {
            return new ResourceStateUpdateExclusionRules(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
