/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Image Builder recipe that the lifecycle policy uses for resource selection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyResourceSelectionRecipe implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyResourceSelectionRecipe.Builder, LifecyclePolicyResourceSelectionRecipe> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LifecyclePolicyResourceSelectionRecipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(LifecyclePolicyResourceSelectionRecipe::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEMANTIC_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String semanticVersion;

    private LifecyclePolicyResourceSelectionRecipe(BuilderImpl builder) {
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
    }

    /**
     * <p>
     * The name of an Image Builder recipe that the lifecycle policy uses for resource selection.
     * </p>
     * 
     * @return The name of an Image Builder recipe that the lifecycle policy uses for resource selection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the Image Builder recipe specified by the <code>name</code> field.
     * </p>
     * 
     * @return The version of the Image Builder recipe specified by the <code>name</code> field.
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyResourceSelectionRecipe)) {
            return false;
        }
        LifecyclePolicyResourceSelectionRecipe other = (LifecyclePolicyResourceSelectionRecipe) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(semanticVersion(), other.semanticVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyResourceSelectionRecipe").add("Name", name())
                .add("SemanticVersion", semanticVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyResourceSelectionRecipe, T> g) {
        return obj -> g.apply((LifecyclePolicyResourceSelectionRecipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyResourceSelectionRecipe> {
        /**
         * <p>
         * The name of an Image Builder recipe that the lifecycle policy uses for resource selection.
         * </p>
         * 
         * @param name
         *        The name of an Image Builder recipe that the lifecycle policy uses for resource selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the Image Builder recipe specified by the <code>name</code> field.
         * </p>
         * 
         * @param semanticVersion
         *        The version of the Image Builder recipe specified by the <code>name</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String semanticVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyResourceSelectionRecipe model) {
            name(model.name);
            semanticVersion(model.semanticVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        @Override
        public LifecyclePolicyResourceSelectionRecipe build() {
            return new LifecyclePolicyResourceSelectionRecipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
