/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains control settings and configurable inputs for a workflow resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowConfiguration.Builder, WorkflowConfiguration> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowArn").getter(getter(WorkflowConfiguration::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()).build();

    private static final SdkField<List<WorkflowParameter>> PARAMETERS_FIELD = SdkField
            .<List<WorkflowParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(WorkflowConfiguration::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARALLEL_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parallelGroup").getter(getter(WorkflowConfiguration::parallelGroup))
            .setter(setter(Builder::parallelGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelGroup").build()).build();

    private static final SdkField<String> ON_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onFailure").getter(getter(WorkflowConfiguration::onFailureAsString)).setter(setter(Builder::onFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            PARAMETERS_FIELD, PARALLEL_GROUP_FIELD, ON_FAILURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowArn;

    private final List<WorkflowParameter> parameters;

    private final String parallelGroup;

    private final String onFailure;

    private WorkflowConfiguration(BuilderImpl builder) {
        this.workflowArn = builder.workflowArn;
        this.parameters = builder.parameters;
        this.parallelGroup = builder.parallelGroup;
        this.onFailure = builder.onFailure;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow resource.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains parameter values for each of the parameters that the workflow document defined for the workflow
     * resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Contains parameter values for each of the parameters that the workflow document defined for the workflow
     *         resource.
     */
    public final List<WorkflowParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Test workflows are defined within named runtime groups called parallel groups. The parallel group is the named
     * group that contains this test workflow. Test workflows within a parallel group can run at the same time. Image
     * Builder starts up to five test workflows in the group at the same time, and starts additional workflows as others
     * complete, until all workflows in the group have completed. This field only applies for test workflows.
     * </p>
     * 
     * @return Test workflows are defined within named runtime groups called parallel groups. The parallel group is the
     *         named group that contains this test workflow. Test workflows within a parallel group can run at the same
     *         time. Image Builder starts up to five test workflows in the group at the same time, and starts additional
     *         workflows as others complete, until all workflows in the group have completed. This field only applies
     *         for test workflows.
     */
    public final String parallelGroup() {
        return parallelGroup;
    }

    /**
     * <p>
     * The action to take if the workflow fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onFailure} will
     * return {@link OnWorkflowFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #onFailureAsString}.
     * </p>
     * 
     * @return The action to take if the workflow fails.
     * @see OnWorkflowFailure
     */
    public final OnWorkflowFailure onFailure() {
        return OnWorkflowFailure.fromValue(onFailure);
    }

    /**
     * <p>
     * The action to take if the workflow fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onFailure} will
     * return {@link OnWorkflowFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #onFailureAsString}.
     * </p>
     * 
     * @return The action to take if the workflow fails.
     * @see OnWorkflowFailure
     */
    public final String onFailureAsString() {
        return onFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parallelGroup());
        hashCode = 31 * hashCode + Objects.hashCode(onFailureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowConfiguration)) {
            return false;
        }
        WorkflowConfiguration other = (WorkflowConfiguration) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(parallelGroup(), other.parallelGroup())
                && Objects.equals(onFailureAsString(), other.onFailureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowConfiguration").add("WorkflowArn", workflowArn())
                .add("Parameters", hasParameters() ? parameters() : null).add("ParallelGroup", parallelGroup())
                .add("OnFailure", onFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "parallelGroup":
            return Optional.ofNullable(clazz.cast(parallelGroup()));
        case "onFailure":
            return Optional.ofNullable(clazz.cast(onFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowConfiguration, T> g) {
        return obj -> g.apply((WorkflowConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow resource.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * Contains parameter values for each of the parameters that the workflow document defined for the workflow
         * resource.
         * </p>
         * 
         * @param parameters
         *        Contains parameter values for each of the parameters that the workflow document defined for the
         *        workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<WorkflowParameter> parameters);

        /**
         * <p>
         * Contains parameter values for each of the parameters that the workflow document defined for the workflow
         * resource.
         * </p>
         * 
         * @param parameters
         *        Contains parameter values for each of the parameters that the workflow document defined for the
         *        workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(WorkflowParameter... parameters);

        /**
         * <p>
         * Contains parameter values for each of the parameters that the workflow document defined for the workflow
         * resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<WorkflowParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<WorkflowParameter>)
         */
        Builder parameters(Consumer<WorkflowParameter.Builder>... parameters);

        /**
         * <p>
         * Test workflows are defined within named runtime groups called parallel groups. The parallel group is the
         * named group that contains this test workflow. Test workflows within a parallel group can run at the same
         * time. Image Builder starts up to five test workflows in the group at the same time, and starts additional
         * workflows as others complete, until all workflows in the group have completed. This field only applies for
         * test workflows.
         * </p>
         * 
         * @param parallelGroup
         *        Test workflows are defined within named runtime groups called parallel groups. The parallel group is
         *        the named group that contains this test workflow. Test workflows within a parallel group can run at
         *        the same time. Image Builder starts up to five test workflows in the group at the same time, and
         *        starts additional workflows as others complete, until all workflows in the group have completed. This
         *        field only applies for test workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelGroup(String parallelGroup);

        /**
         * <p>
         * The action to take if the workflow fails.
         * </p>
         * 
         * @param onFailure
         *        The action to take if the workflow fails.
         * @see OnWorkflowFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnWorkflowFailure
         */
        Builder onFailure(String onFailure);

        /**
         * <p>
         * The action to take if the workflow fails.
         * </p>
         * 
         * @param onFailure
         *        The action to take if the workflow fails.
         * @see OnWorkflowFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnWorkflowFailure
         */
        Builder onFailure(OnWorkflowFailure onFailure);
    }

    static final class BuilderImpl implements Builder {
        private String workflowArn;

        private List<WorkflowParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String parallelGroup;

        private String onFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowConfiguration model) {
            workflowArn(model.workflowArn);
            parameters(model.parameters);
            parallelGroup(model.parallelGroup);
            onFailure(model.onFailure);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final List<WorkflowParameter.Builder> getParameters() {
            List<WorkflowParameter.Builder> result = WorkflowParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<WorkflowParameter.BuilderImpl> parameters) {
            this.parameters = WorkflowParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<WorkflowParameter> parameters) {
            this.parameters = WorkflowParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(WorkflowParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<WorkflowParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> WorkflowParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getParallelGroup() {
            return parallelGroup;
        }

        public final void setParallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
        }

        @Override
        public final Builder parallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
            return this;
        }

        public final String getOnFailure() {
            return onFailure;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        @Override
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        @Override
        public final Builder onFailure(OnWorkflowFailure onFailure) {
            this.onFailure(onFailure == null ? null : onFailure.toString());
            return this;
        }

        @Override
        public WorkflowConfiguration build() {
            return new WorkflowConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
