/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionConfigurationRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<GetDistributionConfigurationRequest.Builder, GetDistributionConfigurationRequest> {
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("distributionConfigurationArn")
            .getter(getter(GetDistributionConfigurationRequest::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DISTRIBUTION_CONFIGURATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String distributionConfigurationArn;

    private GetDistributionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.
     */
    public final String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionConfigurationRequest)) {
            return false;
        }
        GetDistributionConfigurationRequest other = (GetDistributionConfigurationRequest) obj;
        return Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDistributionConfigurationRequest")
                .add("DistributionConfigurationArn", distributionConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("distributionConfigurationArn", DISTRIBUTION_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionConfigurationRequest, T> g) {
        return obj -> g.apply((GetDistributionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDistributionConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String distributionConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionConfigurationRequest model) {
            super(model);
            distributionConfigurationArn(model.distributionConfigurationArn);
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDistributionConfigurationRequest build() {
            return new GetDistributionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
