/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImagePipelineResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetImagePipelineResponse.Builder, GetImagePipelineResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(GetImagePipelineResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<ImagePipeline> IMAGE_PIPELINE_FIELD = SdkField
            .<ImagePipeline> builder(MarshallingType.SDK_POJO).memberName("imagePipeline")
            .getter(getter(GetImagePipelineResponse::imagePipeline)).setter(setter(Builder::imagePipeline))
            .constructor(ImagePipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            IMAGE_PIPELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final ImagePipeline imagePipeline;

    private GetImagePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imagePipeline = builder.imagePipeline;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The image pipeline object.
     * </p>
     * 
     * @return The image pipeline object.
     */
    public final ImagePipeline imagePipeline() {
        return imagePipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(imagePipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImagePipelineResponse)) {
            return false;
        }
        GetImagePipelineResponse other = (GetImagePipelineResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(imagePipeline(), other.imagePipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImagePipelineResponse").add("RequestId", requestId()).add("ImagePipeline", imagePipeline())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "imagePipeline":
            return Optional.ofNullable(clazz.cast(imagePipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("imagePipeline", IMAGE_PIPELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImagePipelineResponse, T> g) {
        return obj -> g.apply((GetImagePipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetImagePipelineResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The image pipeline object.
         * </p>
         * 
         * @param imagePipeline
         *        The image pipeline object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipeline(ImagePipeline imagePipeline);

        /**
         * <p>
         * The image pipeline object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImagePipeline.Builder} avoiding the need
         * to create one manually via {@link ImagePipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImagePipeline.Builder#build()} is called immediately and its
         * result is passed to {@link #imagePipeline(ImagePipeline)}.
         * 
         * @param imagePipeline
         *        a consumer that will call methods on {@link ImagePipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePipeline(ImagePipeline)
         */
        default Builder imagePipeline(Consumer<ImagePipeline.Builder> imagePipeline) {
            return imagePipeline(ImagePipeline.builder().applyMutation(imagePipeline).build());
        }
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private ImagePipeline imagePipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImagePipelineResponse model) {
            super(model);
            requestId(model.requestIdValue);
            imagePipeline(model.imagePipeline);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final ImagePipeline.Builder getImagePipeline() {
            return imagePipeline != null ? imagePipeline.toBuilder() : null;
        }

        public final void setImagePipeline(ImagePipeline.BuilderImpl imagePipeline) {
            this.imagePipeline = imagePipeline != null ? imagePipeline.build() : null;
        }

        @Override
        public final Builder imagePipeline(ImagePipeline imagePipeline) {
            this.imagePipeline = imagePipeline;
            return this;
        }

        @Override
        public GetImagePipelineResponse build() {
            return new GetImagePipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
