/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecycleExecutionResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetLifecycleExecutionResponse.Builder, GetLifecycleExecutionResponse> {
    private static final SdkField<LifecycleExecution> LIFECYCLE_EXECUTION_FIELD = SdkField
            .<LifecycleExecution> builder(MarshallingType.SDK_POJO).memberName("lifecycleExecution")
            .getter(getter(GetLifecycleExecutionResponse::lifecycleExecution)).setter(setter(Builder::lifecycleExecution))
            .constructor(LifecycleExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LifecycleExecution lifecycleExecution;

    private GetLifecycleExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleExecution = builder.lifecycleExecution;
    }

    /**
     * <p>
     * Runtime details for the specified runtime instance of the lifecycle policy.
     * </p>
     * 
     * @return Runtime details for the specified runtime instance of the lifecycle policy.
     */
    public final LifecycleExecution lifecycleExecution() {
        return lifecycleExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecycleExecutionResponse)) {
            return false;
        }
        GetLifecycleExecutionResponse other = (GetLifecycleExecutionResponse) obj;
        return Objects.equals(lifecycleExecution(), other.lifecycleExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLifecycleExecutionResponse").add("LifecycleExecution", lifecycleExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecycleExecution":
            return Optional.ofNullable(clazz.cast(lifecycleExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecycleExecution", LIFECYCLE_EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLifecycleExecutionResponse, T> g) {
        return obj -> g.apply((GetLifecycleExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLifecycleExecutionResponse> {
        /**
         * <p>
         * Runtime details for the specified runtime instance of the lifecycle policy.
         * </p>
         * 
         * @param lifecycleExecution
         *        Runtime details for the specified runtime instance of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleExecution(LifecycleExecution lifecycleExecution);

        /**
         * <p>
         * Runtime details for the specified runtime instance of the lifecycle policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleExecution.Builder} avoiding the
         * need to create one manually via {@link LifecycleExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #lifecycleExecution(LifecycleExecution)}.
         * 
         * @param lifecycleExecution
         *        a consumer that will call methods on {@link LifecycleExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleExecution(LifecycleExecution)
         */
        default Builder lifecycleExecution(Consumer<LifecycleExecution.Builder> lifecycleExecution) {
            return lifecycleExecution(LifecycleExecution.builder().applyMutation(lifecycleExecution).build());
        }
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private LifecycleExecution lifecycleExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecycleExecutionResponse model) {
            super(model);
            lifecycleExecution(model.lifecycleExecution);
        }

        public final LifecycleExecution.Builder getLifecycleExecution() {
            return lifecycleExecution != null ? lifecycleExecution.toBuilder() : null;
        }

        public final void setLifecycleExecution(LifecycleExecution.BuilderImpl lifecycleExecution) {
            this.lifecycleExecution = lifecycleExecution != null ? lifecycleExecution.build() : null;
        }

        @Override
        public final Builder lifecycleExecution(LifecycleExecution lifecycleExecution) {
            this.lifecycleExecution = lifecycleExecution;
            return this;
        }

        @Override
        public GetLifecycleExecutionResponse build() {
            return new GetLifecycleExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
