/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePolicyResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetLifecyclePolicyResponse.Builder, GetLifecyclePolicyResponse> {
    private static final SdkField<LifecyclePolicy> LIFECYCLE_POLICY_FIELD = SdkField
            .<LifecyclePolicy> builder(MarshallingType.SDK_POJO).memberName("lifecyclePolicy")
            .getter(getter(GetLifecyclePolicyResponse::lifecyclePolicy)).setter(setter(Builder::lifecyclePolicy))
            .constructor(LifecyclePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LifecyclePolicy lifecyclePolicy;

    private GetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicy = builder.lifecyclePolicy;
    }

    /**
     * <p>
     * The ARN of the image lifecycle policy resource that was returned.
     * </p>
     * 
     * @return The ARN of the image lifecycle policy resource that was returned.
     */
    public final LifecyclePolicy lifecyclePolicy() {
        return lifecyclePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyResponse)) {
            return false;
        }
        GetLifecyclePolicyResponse other = (GetLifecyclePolicyResponse) obj;
        return Objects.equals(lifecyclePolicy(), other.lifecyclePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLifecyclePolicyResponse").add("LifecyclePolicy", lifecyclePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecyclePolicy":
            return Optional.ofNullable(clazz.cast(lifecyclePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecyclePolicy", LIFECYCLE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePolicyResponse> {
        /**
         * <p>
         * The ARN of the image lifecycle policy resource that was returned.
         * </p>
         * 
         * @param lifecyclePolicy
         *        The ARN of the image lifecycle policy resource that was returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicy(LifecyclePolicy lifecyclePolicy);

        /**
         * <p>
         * The ARN of the image lifecycle policy resource that was returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicy.Builder} avoiding the
         * need to create one manually via {@link LifecyclePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #lifecyclePolicy(LifecyclePolicy)}.
         * 
         * @param lifecyclePolicy
         *        a consumer that will call methods on {@link LifecyclePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicy(LifecyclePolicy)
         */
        default Builder lifecyclePolicy(Consumer<LifecyclePolicy.Builder> lifecyclePolicy) {
            return lifecyclePolicy(LifecyclePolicy.builder().applyMutation(lifecyclePolicy).build());
        }
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private LifecyclePolicy lifecyclePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyResponse model) {
            super(model);
            lifecyclePolicy(model.lifecyclePolicy);
        }

        public final LifecyclePolicy.Builder getLifecyclePolicy() {
            return lifecyclePolicy != null ? lifecyclePolicy.toBuilder() : null;
        }

        public final void setLifecyclePolicy(LifecyclePolicy.BuilderImpl lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy != null ? lifecyclePolicy.build() : null;
        }

        @Override
        public final Builder lifecyclePolicy(LifecyclePolicy lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        @Override
        public GetLifecyclePolicyResponse build() {
            return new GetLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
